/*
 * Decompiled with CFR 0.152.
 */
package revamped_phantoms.mixin;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import revamped_phantoms.PhantomGoals;
import revamped_phantoms.RevampedPhantoms;
import revamped_phantoms.utils.IHasSharedGoals;
import revamped_phantoms.utils.SharedGoalHolder;

@Mixin(value={Phantom.class})
public abstract class PhantomMixin
extends Mob
implements IHasSharedGoals {
    @Shadow
    Phantom.AttackPhase f_33096_;
    @Shadow
    Vec3 f_33097_;
    @Unique
    private SharedGoalHolder revamped_phantoms_goalHolder;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void revamped_phantoms_setup(CallbackInfo ci) {
        this.revamped_phantoms_goalHolder = new SharedGoalHolder();
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")})
    private void revamped_phantoms_registerGoals(CallbackInfo ci) {
        Phantom phantom = (Phantom)this;
        if (RevampedPhantoms.getConfig().isPhantomsGrabPrey()) {
            this.f_21345_.m_25352_(2, (Goal)new PhantomGoals.GrabPreyGoal(phantom));
        }
        if (RevampedPhantoms.getConfig().isPhantomsGrabPrey()) {
            this.f_21345_.m_25352_(1, (Goal)new PhantomGoals.DropPreyGoal(phantom));
        }
        if (RevampedPhantoms.getConfig().isPhantomsStunPrey()) {
            this.f_21345_.m_25352_(1, (Goal)new PhantomGoals.StunPreyGoal(phantom));
        }
        if (RevampedPhantoms.getConfig().isPhantomsAttackAnimals()) {
            this.f_21346_.m_25352_(1, (Goal)new PhantomGoals.LivestockTargetGoal(phantom));
        }
        if (RevampedPhantoms.getConfig().isPhantomsAttackVillagers()) {
            this.f_21346_.m_25352_(1, (Goal)new PhantomGoals.VillagerTargetGoal(phantom));
        }
    }

    @Override
    public SharedGoalHolder revamped_phantoms_getGoalHolder() {
        return this.revamped_phantoms_goalHolder;
    }

    private PhantomMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        throw new AssertionError();
    }
}

