/*
 * Decompiled with CFR 0.152.
 */
package revamped_phantoms.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.architectury.platform.Platform;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import revamped_phantoms.RevampedPhantoms;

public class RevampedPhantomsConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path CONFIG_PATH = Platform.getConfigFolder();
    public static final String FULL_PATH = CONFIG_PATH.toString() + "/revamped_phantoms.json";
    private boolean phantomsAttackAnimals = true;
    private boolean phantomsAttackVillagers = true;
    private float phantomElytraPursueModifier = 8.0f;
    private boolean phantomsStunPrey = true;
    private int ticksBetweenStunAttempts = 200;
    private int ticksStunDuration = 120;
    private boolean phantomsGrabPrey = true;
    private boolean doDaylightSpawns = true;
    private List<String> phantom_attack_blacklist = new ArrayList<String>();

    private static RevampedPhantomsConfig load() {
        RevampedPhantomsConfig config = new RevampedPhantomsConfig();
        try {
            RevampedPhantomsConfig.checkExistence();
            config = (RevampedPhantomsConfig)GSON.fromJson((Reader)new FileReader(FULL_PATH), RevampedPhantomsConfig.class);
            RevampedPhantomsConfig.save(config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            RevampedPhantoms.LOGGER.error("Could not load config (it may be out of date). Using default config.");
        }
        return config;
    }

    public static RevampedPhantomsConfig get() {
        RevampedPhantomsConfig config = RevampedPhantomsConfig.load();
        if (config.phantomElytraPursueModifier < 1.0f) {
            config.phantomElytraPursueModifier = 1.0f;
        }
        if (config.phantomElytraPursueModifier > 32.0f) {
            config.phantomElytraPursueModifier = 32.0f;
        }
        return config;
    }

    public static void save(RevampedPhantomsConfig config) {
        try {
            RevampedPhantomsConfig.checkExistence();
            FileWriter writer = new FileWriter(FULL_PATH);
            GSON.toJson((Object)config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void checkExistence() throws IOException {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        }
        if (!Files.exists(Paths.get(FULL_PATH, new String[0]), new LinkOption[0])) {
            Files.createFile(Paths.get(FULL_PATH, new String[0]), new FileAttribute[0]);
            RevampedPhantomsConfig.save(new RevampedPhantomsConfig());
        }
    }

    public boolean isPhantomsStunPrey() {
        return this.phantomsStunPrey;
    }

    public boolean isPhantomsGrabPrey() {
        return this.phantomsGrabPrey;
    }

    public float getPhantomElytraPursueModifier() {
        return this.phantomElytraPursueModifier;
    }

    public boolean isPhantomsAttackVillagers() {
        return this.phantomsAttackVillagers;
    }

    public boolean isPhantomsAttackAnimals() {
        return this.phantomsAttackAnimals;
    }

    public boolean isDoDaylightSpawns() {
        return this.doDaylightSpawns;
    }

    public int getTicksBetweenStunAttempts() {
        return this.ticksBetweenStunAttempts;
    }

    public int getTicksStunDuration() {
        return this.ticksStunDuration;
    }

    public List<String> getPhantomAttackBlacklist() {
        return this.phantom_attack_blacklist;
    }
}

