/*
 * Decompiled with CFR 0.152.
 */
package revamped_phantoms;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import revamped_phantoms.RevampedPhantoms;
import revamped_phantoms.entity.Shockwave;
import revamped_phantoms.forge.PhantomGoalsImpl;
import revamped_phantoms.mixin.IEntityMixin;
import revamped_phantoms.mixin.IPhantomMixin;
import revamped_phantoms.utils.IHasSharedGoals;

public class PhantomGoals {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getEntityRl(Entity e) {
        return PhantomGoalsImpl.getEntityRl(e);
    }

    public static class DropPreyGoal
    extends Goal {
        private final Phantom self;

        public DropPreyGoal(Phantom p) {
            this.self = p;
        }

        public boolean m_8036_() {
            return this.self.m_146895_() != null;
        }

        public void m_8037_() {
            Entity entity = this.self.m_146895_();
            if (entity == null) {
                return;
            }
            if (this.self.m_20186_() > 30.0 + ((IHasSharedGoals)this.self).revamped_phantoms_getGoalHolder().preyGrabbedY || this.self.f_19797_ > ((IHasSharedGoals)this.self).revamped_phantoms_getGoalHolder().ticksSinceGrabbed) {
                entity.m_8127_();
            }
        }
    }

    public static class GrabPreyGoal
    extends Goal {
        private final Phantom self;
        private boolean isScaredOfCat;
        private int catSearchTick;

        public GrabPreyGoal(Phantom p) {
            this.self = p;
        }

        public boolean m_8036_() {
            boolean shouldOnlyCarry = this.self.m_5448_() instanceof Animal;
            return this.self.m_5448_() != null && ((IPhantomMixin)this.self).getAttackPhase() == Phantom.AttackPhase.SWOOP && this.self.m_146895_() == null && !this.self.m_5448_().m_20159_() && !this.self.m_5448_().m_21255_() && (((IHasSharedGoals)this.self).revamped_phantoms_getGoalHolder().shouldGrab || shouldOnlyCarry);
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.self.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (livingEntity.m_20159_()) {
                return false;
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (livingEntity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (this.self.f_19797_ > this.catSearchTick) {
                this.catSearchTick = this.self.f_19797_ + 20;
                List list = this.self.f_19853_.m_6443_(Cat.class, this.self.m_142469_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            this.self.m_6710_(null);
            ((IPhantomMixin)this.self).setAttackPhase(Phantom.AttackPhase.CIRCLE);
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.self.m_5448_();
            if (livingEntity == null) {
                return;
            }
            ((IPhantomMixin)this.self).setMoveTargetPoint(new Vec3(livingEntity.m_20185_(), livingEntity.m_20227_(0.5), livingEntity.m_20189_()));
            if (this.self.m_142469_().m_82400_((double)0.2f).m_82381_(livingEntity.m_142469_()) && !livingEntity.m_20363_((Entity)this.self)) {
                livingEntity.m_20329_((Entity)this.self);
                ((IHasSharedGoals)this.self).revamped_phantoms_getGoalHolder().preyGrabbedY = this.self.m_20186_();
                ((IHasSharedGoals)this.self).revamped_phantoms_getGoalHolder().ticksSinceGrabbed = this.self.f_19797_ + 200;
                ((IHasSharedGoals)this.self).revamped_phantoms_getGoalHolder().shouldGrab = false;
                ((IPhantomMixin)this.self).setAttackPhase(Phantom.AttackPhase.CIRCLE);
            } else if (this.self.f_19862_ || this.self.f_20916_ > 0 || livingEntity.m_20363_((Entity)this.self)) {
                ((IPhantomMixin)this.self).setAttackPhase(Phantom.AttackPhase.CIRCLE);
            }
        }
    }

    public static class StunPreyGoal
    extends Goal {
        private boolean isScaredOfCat;
        private int catSearchTick;
        private int stunTick;
        private final Phantom self;

        public StunPreyGoal(Phantom p) {
            this.self = p;
        }

        public boolean m_8036_() {
            return this.self.m_5448_() != null && ((IPhantomMixin)this.self).getAttackPhase() == Phantom.AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.self.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (livingEntity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (this.self.f_19797_ > this.catSearchTick) {
                this.catSearchTick = this.self.f_19797_ + 20;
                List list = this.self.f_19853_.m_6443_(Cat.class, this.self.m_142469_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.self.m_5448_();
            if (livingEntity == null) {
                return;
            }
            if (this.self.m_142582_((Entity)livingEntity) && this.self.f_19797_ > this.stunTick && this.self.m_20270_((Entity)livingEntity) < 20.0f) {
                if (!this.self.f_19853_.m_5776_()) {
                    Vec3 pos = this.self.m_146892_();
                    double l = pos.f_82479_;
                    double m = pos.f_82480_;
                    double n = pos.f_82481_;
                    double o = this.self.m_5448_().m_20185_() - l;
                    double p = this.self.m_5448_().m_20227_(0.5) - m;
                    double q = this.self.m_5448_().m_20189_() - n;
                    if (!this.self.m_20067_()) {
                        this.self.m_5496_(SoundEvents.f_12232_, 10.0f, 1.5f + ((IEntityMixin)this.self).getRandom().nextFloat() * 0.1f);
                    }
                    Shockwave shockwave = new Shockwave(this.self.f_19853_, (LivingEntity)this.self, o, p, q);
                    shockwave.m_7678_(l, m, n, 0.0f, 0.0f);
                    this.self.f_19853_.m_7967_((Entity)shockwave);
                }
                this.stunTick = this.self.f_19797_ + RevampedPhantoms.getConfig().getTicksBetweenStunAttempts();
            }
        }
    }

    public static class VillagerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = VillagerTargetGoal.m_186073_((int)20);
        private final Phantom self;

        public VillagerTargetGoal(Phantom p) {
            this.self = p;
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = VillagerTargetGoal.m_186073_((int)60);
            List list = this.self.f_19853_.m_45971_(Villager.class, this.attackTargeting, (LivingEntity)this.self, this.self.m_142469_().m_82377_(32.0, 64.0, 32.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(entity -> entity.m_20186_()).reversed());
                for (Villager villager : list) {
                    if (!this.self.m_21040_((LivingEntity)villager, TargetingConditions.f_26872_) || villager.m_20159_()) continue;
                    this.self.m_6710_((LivingEntity)villager);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.self.m_5448_();
            if (livingEntity != null) {
                return this.self.m_21040_(livingEntity, TargetingConditions.f_26872_);
            }
            return false;
        }
    }

    public static class LivestockTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0).m_26888_(e -> !RevampedPhantoms.getConfig().getPhantomAttackBlacklist().stream().anyMatch(x -> PhantomGoals.getEntityRl((Entity)e).toString().endsWith((String)x)));
        private int nextScanTick = LivestockTargetGoal.m_186073_((int)20);
        private final Phantom self;

        public LivestockTargetGoal(Phantom p) {
            this.self = p;
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = LivestockTargetGoal.m_186073_((int)60);
            List list = this.self.f_19853_.m_45971_(Animal.class, this.attackTargeting, (LivingEntity)this.self, this.self.m_142469_().m_82377_(32.0, 64.0, 32.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(entity -> entity.m_20186_()).reversed());
                for (Animal animal : list) {
                    if (!this.self.m_21040_((LivingEntity)animal, TargetingConditions.f_26872_) || animal.m_20159_() || animal.m_21523_() || animal instanceof Cat) continue;
                    this.self.m_6710_((LivingEntity)animal);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.self.m_5448_();
            if (livingEntity != null) {
                return this.self.m_21040_(livingEntity, TargetingConditions.f_26872_);
            }
            return false;
        }
    }
}

