/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import snownee.jade.addon.forge.InventoryProvider;

public final class JadeCommonConfig {
    public static int inventoryDetailedShowAmount = 54;
    public static int inventoryNormalShowAmount = 9;
    public static int inventoryShowItemPreLine = 9;
    private static final Set<BlockEntityType<?>> inventoryBlacklist = Sets.newHashSet();
    public static boolean bypassLockedContainer = false;
    private static boolean onlyShowVanilla = false;
    private static final Set<String> modBlacklist = Sets.newHashSet();
    private static ForgeConfigSpec.IntValue inventorySneakShowAmountVal;
    private static ForgeConfigSpec.IntValue inventoryNormalShowAmountVal;
    private static ForgeConfigSpec.IntValue inventoryShowItemPreLineVal;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> inventoryBlacklistVal;
    private static ForgeConfigSpec.BooleanValue bypassLockedContainerVal;
    private static ForgeConfigSpec.BooleanValue onlyShowVanillaVal;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> modBlacklistVal;
    static final ForgeConfigSpec spec;

    private JadeCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("inventory");
        inventorySneakShowAmountVal = builder.defineInRange("sneakShowAmount", inventoryDetailedShowAmount, 0, 54);
        inventoryNormalShowAmountVal = builder.defineInRange("normalShowAmount", inventoryNormalShowAmount, 0, 54);
        inventoryShowItemPreLineVal = builder.defineInRange("showItemPreLine", inventoryShowItemPreLine, 1, 18);
        inventoryBlacklistVal = builder.defineList("blacklist", () -> Collections.singletonList("refinedstorage:disk_drive"), (Predicate)Predicates.alwaysTrue());
        bypassLockedContainerVal = builder.define("bypassLockedContainer", bypassLockedContainer);
        builder.pop();
        builder.push("customContainerName");
        onlyShowVanillaVal = builder.define("onlyShowVanilla", onlyShowVanilla);
        modBlacklistVal = builder.defineList("blacklist", () -> Collections.singletonList("thermal"), (Predicate)Predicates.alwaysTrue());
    }

    public static void refresh() {
        inventoryDetailedShowAmount = (Integer)inventorySneakShowAmountVal.get();
        inventoryNormalShowAmount = (Integer)inventoryNormalShowAmountVal.get();
        inventoryShowItemPreLine = (Integer)inventoryShowItemPreLineVal.get();
        bypassLockedContainer = (Boolean)bypassLockedContainerVal.get();
        inventoryBlacklist.clear();
        inventoryBlacklist.addAll(JadeCommonConfig.parseBlockEntityTypes(InventoryProvider.INVENTORY_IGNORE));
        inventoryBlacklist.addAll(JadeCommonConfig.parseBlockEntityTypes((Collection)inventoryBlacklistVal.get()));
        onlyShowVanilla = (Boolean)onlyShowVanillaVal.get();
        modBlacklist.clear();
        modBlacklist.addAll((Collection)modBlacklistVal.get());
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        ((CommentedFileConfig)event.getConfig().getConfigData()).load();
        JadeCommonConfig.refresh();
    }

    public static boolean shouldIgnoreTE(BlockEntityType<?> type) {
        return inventoryBlacklist.contains(type);
    }

    public static boolean shouldIgnoreTE(String id) {
        return JadeCommonConfig.shouldIgnoreTE((BlockEntityType)Registry.f_122830_.m_7745_(ResourceLocation.m_135820_((String)id)));
    }

    private static List<BlockEntityType<?>> parseBlockEntityTypes(Collection<? extends String> ids) {
        try {
            return ids.stream().map(ResourceLocation::m_135820_).map(arg_0 -> ((Registry)Registry.f_122830_).m_7745_(arg_0)).filter(Objects::nonNull).toList();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static boolean shouldShowCustomName(BlockEntity t) {
        String modid = t.m_58903_().getRegistryName().m_135827_();
        if (onlyShowVanilla) {
            return "minecraft".equals(modid);
        }
        return !modBlacklist.contains(modid);
    }

    static {
        spec = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(JadeCommonConfig::new).getRight();
    }
}

