/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.networking;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraftforge.network.NetworkEvent;
import tallestred.piglinproliferation.PPEvents;
import tallestred.piglinproliferation.capablities.TransformationSourceListener;

public class ZiglinCapablitySyncPacket {
    private final int entityId;
    private final String transformedFromId;

    public ZiglinCapablitySyncPacket(int entityId, String transformedFromId) {
        this.entityId = entityId;
        this.transformedFromId = transformedFromId;
    }

    public static ZiglinCapablitySyncPacket decode(FriendlyByteBuf buf) {
        return new ZiglinCapablitySyncPacket(buf.m_130242_(), buf.m_130277_());
    }

    public static void encode(ZiglinCapablitySyncPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130070_(msg.transformedFromId);
    }

    public static void handle(ZiglinCapablitySyncPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(msg.getEntityId());
            if (entity != null && entity instanceof ZombifiedPiglin) {
                ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
                TransformationSourceListener tSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin);
                tSource.setTransformationSource(msg.getTransformedFromId());
            }
        });
        context.get().setPacketHandled(true);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public String getTransformedFromId() {
        return this.transformedFromId;
    }
}

