/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.networking;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class AlchemistBeltSyncPacket {
    private final int entityId;
    private final int slotId;
    private final ItemStack stack;

    public AlchemistBeltSyncPacket(int entityId, int slotID, ItemStack stack) {
        this.entityId = entityId;
        this.slotId = slotID;
        this.stack = stack;
    }

    public static AlchemistBeltSyncPacket decode(FriendlyByteBuf buf) {
        return new AlchemistBeltSyncPacket(buf.m_130242_(), buf.readInt(), buf.m_130267_());
    }

    public static void encode(AlchemistBeltSyncPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.writeInt(msg.slotId);
        buf.m_130055_(msg.stack);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void handle(AlchemistBeltSyncPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(msg.getEntityId());
            if (entity != null && entity instanceof PiglinAlchemist) {
                PiglinAlchemist alchemist = (PiglinAlchemist)entity;
                alchemist.setBeltInventorySlot(msg.slotId, msg.stack);
            }
        });
        context.get().setPacketHandled(true);
    }
}

