/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.goals;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;

public class AlchemistBowAttackGoal<T extends PiglinAlchemist>
extends Goal {
    protected final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int attackIntervalMin;
    private int attackTime = -1;
    private int seeTime;
    private int avoidTime;

    public AlchemistBowAttackGoal(T pMob, double pSpeedModifier, int pAttackIntervalMin, float pAttackRadius) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.getTargetToShootAt() != null && this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof BowItem);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingBow() && ((PiglinAlchemist)((Object)this.mob)).getArrowsShot() < 3;
    }

    protected LivingEntity getTargetToShootAt() {
        return this.mob.m_5448_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.getTargetToShootAt();
        if (livingentity != null) {
            double distanceSquared = this.mob.m_20280_((Entity)livingentity);
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean seeTimeGreaterThanZero = this.seeTime > 0;
            this.mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.getTargetToShootAt(), true));
            this.mob.m_21563_().m_148051_((Entity)livingentity);
            this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            if (this.mob.m_6117_()) {
                int timeToShoot;
                int i;
                if (!canSee && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (canSee && (i = this.mob.m_21252_()) >= (timeToShoot = Mth.m_14107_((double)Mth.m_14139_((double)(distanceSquared / (double)this.attackRadiusSqr), (double)5.0, (double)20.0)))) {
                    this.mob.m_5810_();
                    ((PiglinAlchemist)((Object)this.mob)).m_6504_(livingentity, BowItem.m_40661_((int)i));
                    this.attackTime = this.attackIntervalMin;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof BowItem));
            }
            if (distanceSquared > (double)this.attackRadiusSqr && this.seeTime >= 20) {
                WalkTarget walktarget = new WalkTarget((Entity)livingentity, (float)this.speedModifier, 0);
                this.mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)walktarget);
            } else if (distanceSquared < (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                this.mob.m_21573_().m_26573_();
            }
            if (canSee != seeTimeGreaterThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (distanceSquared <= 6.0) {
                this.avoidTime = this.avoidTime <= 0 ? 60 : (this.avoidTime += 2);
            }
            if (this.avoidTime < 0) {
                this.avoidTime = 0;
            }
            if (this.avoidTime > 60) {
                this.avoidTime = 60;
            }
            if (--this.avoidTime > 0) {
                this.attackTime = -1;
                Vec3 vec3 = this.getPosition();
                if (this.mob.m_21573_().m_26571_() || this.mob.m_21573_().m_26577_() || this.avoidTime == 0) {
                    this.mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                }
                if (vec3 != null) {
                    this.mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(vec3, 1.5f, 0));
                }
            }
        }
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.getTargetToShootAt() != null) {
            return LandRandomPos.m_148521_(this.mob, (int)10, (int)7, (Vec3)this.getTargetToShootAt().m_20182_());
        }
        return LandRandomPos.m_148488_(this.mob, (int)10, (int)7);
    }
}

