/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.common.entities.ai.behaviors;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.phys.Vec3;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.common.entities.ai.behaviors.BaseThrowPotion;

public class ThrowPotionAtTargetTask<E extends PiglinAlchemist>
extends BaseThrowPotion<E> {
    protected final Predicate<Mob> nearbyPiglinPredicate;

    public ThrowPotionAtTargetTask(ItemStack stack, Predicate<PiglinAlchemist> pCanUseSelector, Predicate<Mob> nearbyPiglinPredicate) {
        super(stack, pCanUseSelector);
        this.nearbyPiglinPredicate = nearbyPiglinPredicate;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E alchemist) {
        List list = ((PiglinAlchemist)((Object)alchemist)).f_19853_.m_45976_(AbstractPiglin.class, alchemist.m_142469_().m_82377_(10.0, 3.0, 10.0));
        if (!list.isEmpty()) {
            for (AbstractPiglin piglin : list) {
                if (piglin == alchemist) continue;
                for (MobEffectInstance mobeffectinstance : PotionUtils.m_43547_((ItemStack)this.itemToUse)) {
                    List<AbstractPiglin> listOfAlchemists = list.stream().filter(abstractPiglin -> abstractPiglin != alchemist && abstractPiglin instanceof PiglinAlchemist).toList();
                    if (piglin == null || !alchemist.m_142582_((Entity)piglin) || listOfAlchemists.stream().filter(abstractPiglin -> ((PiglinAlchemist)((Object)((Object)abstractPiglin))).isGonnaThrowPotion()).findAny().isPresent() || !super.checkExtraStartConditions(level, alchemist) || !this.nearbyPiglinPredicate.test((Mob)piglin) || piglin.m_21023_(mobeffectinstance.m_19544_())) continue;
                    if (piglin.m_5448_() != null && listOfAlchemists.size() < 2 && alchemist.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_()).m_186128_(livingEntity -> livingEntity instanceof Mob && ((Mob)livingEntity).m_5448_() instanceof AbstractPiglin || livingEntity.m_21214_() instanceof AbstractPiglin).toList().size() > 1) {
                        return false;
                    }
                    alchemist.m_6274_().m_21879_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get(), (Object)piglin);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel level, E alchemist, long gameTime) {
        Mob throwTarget = (Mob)alchemist.m_6274_().m_21952_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
        Iterator iterator = PotionUtils.m_43547_((ItemStack)this.itemToUse).iterator();
        if (iterator.hasNext()) {
            MobEffectInstance mobeffectinstance = (MobEffectInstance)iterator.next();
            return throwTarget != null && alchemist.m_142582_((Entity)throwTarget) && this.nearbyPiglinPredicate.test(throwTarget) && !throwTarget.m_21023_(mobeffectinstance.m_19544_()) && this.ticksUntilThrow > 0;
        }
        return alchemist.m_142582_((Entity)throwTarget);
    }

    @Override
    protected void start(ServerLevel level, E alchemist, long gameTime) {
        super.start(level, alchemist, gameTime);
        alchemist.m_6274_().m_21889_((Activity)PPActivities.THROW_POTION_ACTIVITY.get());
        Mob throwTarget = (Mob)alchemist.m_6274_().m_21952_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
        if (throwTarget == null) {
            return;
        }
        if (this.ticksUntilThrow <= 0) {
            this.ticksUntilThrow = 20;
        }
    }

    @Override
    protected void stop(ServerLevel level, E alchemist, long gameTime) {
        super.stop(level, alchemist, gameTime);
        alchemist.m_6274_().m_21936_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get());
        this.ticksUntilThrow = 0;
        this.panicTicks = 0;
    }

    protected void tick(ServerLevel level, E alchemist, long gameTime) {
        Mob throwTarget = (Mob)alchemist.m_6274_().m_21952_((MemoryModuleType)PPMemoryModules.POTION_THROW_TARGET.get()).orElseGet(null);
        if (throwTarget == null) {
            return;
        }
        alchemist.m_21391_((Entity)throwTarget, 30.0f, 30.0f);
        BehaviorUtils.m_22595_(alchemist, (LivingEntity)throwTarget);
        BehaviorUtils.m_22595_((LivingEntity)throwTarget, alchemist);
        alchemist.m_21563_().m_148051_((Entity)throwTarget);
        if ((double)alchemist.m_20270_((Entity)throwTarget) > 5.0) {
            alchemist.m_21573_().m_5624_((Entity)throwTarget, 1.0);
        } else {
            alchemist.m_21573_().m_26573_();
        }
        List list = ((PiglinAlchemist)((Object)alchemist)).f_19853_.m_45976_(LivingEntity.class, alchemist.m_142469_().m_82377_(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                Vec3 vec3;
                if ((throwTarget.m_5448_() == null || throwTarget.m_5448_() != entity) && (!(entity instanceof Mob) || ((Mob)entity).m_5448_() == null || ((Mob)entity).m_5448_() != alchemist && ((Mob)entity).m_5448_() != throwTarget) || !((double)entity.m_20270_((Entity)throwTarget) <= 4.0) && !((double)entity.m_20270_(alchemist) <= 4.0)) continue;
                if (this.panicTicks <= 0) {
                    this.panicTicks = 5;
                }
                this.ticksUntilThrow += 5;
                if (--this.panicTicks <= 0 || (vec3 = this.getPosition((PiglinAlchemist)((Object)alchemist))) == null || !alchemist.m_21573_().m_26571_()) continue;
                alchemist.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.5);
            }
        }
        if (this.ticksUntilThrow > 20) {
            this.ticksUntilThrow = 20;
        }
        if (this.panicTicks < 0) {
            this.panicTicks = 0;
        }
        if (this.panicTicks >= 15) {
            this.panicTicks = 15;
        }
        if (!alchemist.m_142582_((Entity)throwTarget)) {
            this.ticksUntilThrow += 5;
        }
        if (this.ticksUntilThrow == 5) {
            alchemist.m_5496_((SoundEvent)PPSounds.ALCHEMIST_ABOUT_TO_THROW_POTION.get(), 1.0f, 1.0f);
        }
        if (--this.ticksUntilThrow <= 0) {
            this.throwPotion(alchemist);
        }
    }

    @Nullable
    protected Vec3 getPosition(PiglinAlchemist alchemist) {
        if (alchemist.m_5448_() != null) {
            return LandRandomPos.m_148521_((PathfinderMob)alchemist, (int)8, (int)7, (Vec3)alchemist.m_5448_().m_20182_());
        }
        return LandRandomPos.m_148488_((PathfinderMob)alchemist, (int)8, (int)7);
    }
}

