/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation.client;

import java.util.function.Function;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tallestred.piglinproliferation.client.renderers.PiglinAlchemistRenderer;
import tallestred.piglinproliferation.client.renderers.layers.PiglinClothingRenderLayer;
import tallestred.piglinproliferation.client.renderers.models.PiglinAlchemistModel;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;

@Mod.EventBusSubscriber(modid="piglinproliferation", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class PPClientEvents {
    public static final ModelLayerLocation ZIGLIN_CLOTHING = new ModelLayerLocation(new ResourceLocation("piglinproliferationziglin_clothing"), "ziglin_clothing");
    public static final ModelLayerLocation PIGLIN_ALCHEMIST = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_alchemist"), "piglin_alchemist");
    public static final ModelLayerLocation PIGLIN_ALCHEMIST_BELT = new ModelLayerLocation(new ResourceLocation("piglinproliferationpiglin_alchemist_belt"), "piglin_alchemist_belt");

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ZIGLIN_CLOTHING, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinModel.m_170811_((CubeDeformation)new CubeDeformation(0.25f)), (int)64, (int)64));
        event.registerLayerDefinition(PIGLIN_ALCHEMIST, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinAlchemistModel.createBodyLayer(new CubeDeformation(0.25f), new CubeDeformation(0.7f), new CubeDeformation(1.05f)), (int)120, (int)64));
        event.registerLayerDefinition(PIGLIN_ALCHEMIST_BELT, () -> LayerDefinition.m_171565_((MeshDefinition)PiglinAlchemistModel.createBodyLayer(new CubeDeformation(0.4f), new CubeDeformation(1.0f), new CubeDeformation(1.2f)), (int)120, (int)64));
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)PPEntityTypes.PIGLIN_ALCHEMIST.get(), PiglinAlchemistRenderer::new);
    }

    @SubscribeEvent
    public static void layer(EntityRenderersEvent.AddLayers event) {
        PPClientEvents.addLayerToRenderer(event, EntityType.f_20531_, PiglinClothingRenderLayer::new);
    }

    private static <T extends Mob, R extends LivingEntityRenderer<T, M>, M extends PiglinModel<T>> void addLayerToRenderer(EntityRenderersEvent.AddLayers event, EntityType<T> entityType, Function<R, ? extends RenderLayer<T, M>> factory) {
        LivingEntityRenderer renderer = event.getRenderer(entityType);
        if (renderer != null) {
            renderer.m_115326_(factory.apply(renderer));
        }
    }
}

