/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tallestred.piglinproliferation.PPActivities;
import tallestred.piglinproliferation.PPMemoryModules;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.PPItems;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;
import tallestred.piglinproliferation.common.entities.PiglinAlchemist;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.networking.PPNetworking;

@Mod(value="piglinproliferation")
public class PiglinProliferation {
    public static final String MODID = "piglinproliferation";
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.m_135785_((ResourceKey)Registry.f_122883_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));

    public PiglinProliferation() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addAttributes);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        PPEntityTypes.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        PPItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        PPSounds.SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        PPMemoryModules.MEMORY_MODULE_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        PPActivities.ACTIVITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PPConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PPConfig.CLIENT_SPEC);
        PPNetworking.registerPackets();
    }

    private void addAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PPEntityTypes.PIGLIN_ALCHEMIST.get(), PiglinAlchemist.createAttributes().m_22265_());
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PPEntityTypes.registerSpawnRequirements());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    private void serverStart(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122884_).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().m_206579_().m_6632_(Registry.f_122883_).orElseThrow();
        PiglinProliferation.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, new ResourceLocation("minecraft:bastion/mobs/piglin"), "piglinproliferation:bastion/alchemist_piglin", 4);
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        Holder emptyProcessorList = processorListRegistry.m_206081_(EMPTY_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.m_7745_(poolRL);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.m_210531_((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.f_210560_.add(piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.f_210559_);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.f_210559_ = listOfPieceEntries;
    }
}

