/*
 * Decompiled with CFR 0.152.
 */
package tallestred.piglinproliferation;

import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tallestred.piglinproliferation.capablities.PPCapablities;
import tallestred.piglinproliferation.capablities.TransformationSourceListener;
import tallestred.piglinproliferation.capablities.TransformationSourceProvider;
import tallestred.piglinproliferation.client.PPSounds;
import tallestred.piglinproliferation.common.entities.PPEntityTypes;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinCallForHelpGoal;
import tallestred.piglinproliferation.common.entities.ai.goals.PiglinSwimInLavaGoal;
import tallestred.piglinproliferation.configuration.PPConfig;
import tallestred.piglinproliferation.networking.PPNetworking;
import tallestred.piglinproliferation.networking.ZiglinCapablitySyncPacket;

@Mod.EventBusSubscriber(modid="piglinproliferation")
public class PPEvents {
    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        TransformationSourceProvider provider = new TransformationSourceProvider();
        if (event.getObject() instanceof ZombifiedPiglin) {
            event.addCapability(TransformationSourceProvider.IDENTIFIER, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_6060_() && !piglin1.m_21023_(MobEffects.f_19607_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43610_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() && !piglin1.m_21023_(MobEffects.f_19605_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43589_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() && !piglin1.m_21023_(MobEffects.f_19601_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43581_));
            piglin.f_21345_.m_25352_(0, (Goal)new PiglinCallForHelpGoal(piglin, piglin1 -> piglin1.m_21223_() < piglin1.m_21233_() / 2.0f && piglin1.m_5448_() != null && !piglin1.m_21023_(MobEffects.f_19600_), alchemist -> alchemist.getItemShownOnOffhand() != null && PotionUtils.m_43579_((ItemStack)alchemist.getItemShownOnOffhand()) == Potions.f_43592_));
            piglin.f_21345_.m_25352_(1, (Goal)new PiglinSwimInLavaGoal((Mob)piglin));
        }
    }

    @SubscribeEvent
    public static void onEffectApplied(PotionEvent.PotionAddedEvent event) {
        if (event.getPotionEffect() == null) {
            return;
        }
        MobEffect mobEffect = event.getPotionEffect().m_19544_();
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.f_19607_) {
                piglin.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
                piglin.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
                piglin.m_21441_(BlockPathTypes.LAVA, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotionEffect() == null) {
            return;
        }
        MobEffect mobEffect = event.getPotionEffect().m_19544_();
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)livingEntity;
            if (mobEffect == MobEffects.f_19607_) {
                piglin.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
                piglin.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
                piglin.m_21441_(BlockPathTypes.LAVA, -1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Arrow) {
            Arrow arrow = (Arrow)entity;
            if (((Boolean)PPConfig.COMMON.healingArrowDamage.get()).booleanValue()) {
                for (MobEffectInstance mobeffectinstance : arrow.f_36855_.m_43488_()) {
                    if (mobeffectinstance.m_19544_() != MobEffects.f_19605_ && mobeffectinstance.m_19544_() != MobEffects.f_19601_) continue;
                    if (event.getEntity() instanceof Mob && ((Mob)event.getEntity()).m_21222_()) {
                        return;
                    }
                    event.setAmount(0.0f);
                    arrow.f_19853_.m_5594_(null, arrow.m_142538_(), (SoundEvent)PPSounds.REGEN_HEALING_ARROW_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    event.getEntity().m_20256_(event.getEntity().m_20184_().m_82542_(-1.0, -1.0, -1.0));
                    event.getEntity().f_19802_ = 0;
                    if (!(event.getEntity() instanceof LivingEntity)) continue;
                    ((LivingEntity)event.getEntity()).f_20916_ = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void attackEntity(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            for (Entity rider : mob.m_20197_()) {
                if (!mob.m_21222_() || !(event.getSource().m_7639_() instanceof AbstractPiglin) || !(rider instanceof AbstractPiglin)) continue;
                AbstractPiglin piglin = (AbstractPiglin)rider;
                if (!event.getSource().m_19387_()) continue;
                if (event.getEntity().f_19853_.f_46443_) {
                    return;
                }
                piglin.m_6274_().m_21936_(MemoryModuleType.f_26334_);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ZombifiedPiglin) {
            TransformationSourceListener transformationSource;
            ZombifiedPiglin ziglin = (ZombifiedPiglin)entity;
            if (!event.getTarget().f_19853_.f_46443_ && (transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin)) != null) {
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_142049_(), transformationSource.getTransformationSource()));
            }
        }
    }

    @SubscribeEvent
    public static void onConvert(LivingConversionEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            if (event.getOutcome().m_6095_() == EntityType.f_20531_) {
                if (piglin.f_19853_.f_46443_) {
                    return;
                }
                ZombifiedPiglin ziglin = (ZombifiedPiglin)event.getOutcome();
                TransformationSourceListener transformationSource = PPEvents.getTransformationSourceListener((LivingEntity)ziglin);
                String piglinName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)piglin.m_6095_()).m_135815_();
                transformationSource.setTransformationSource(piglinName);
                PPNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ziglin), (Object)new ZiglinCapablitySyncPacket(ziglin.m_142049_(), piglinName));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (((List)PPConfig.COMMON.listOfAlchemistBiomes.get()).contains(event.getName().toString())) {
            event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)PPEntityTypes.PIGLIN_ALCHEMIST.get(), ((Integer)PPConfig.COMMON.alchemistWeight.get()).intValue(), ((Integer)PPConfig.COMMON.alchemistMinSpawnCount.get()).intValue(), ((Integer)PPConfig.COMMON.alchemistMaxSpawnCount.get()).intValue()));
        }
    }

    public static TransformationSourceListener getTransformationSourceListener(LivingEntity entity) {
        LazyOptional listener = entity.getCapability(PPCapablities.TRANSFORMATION_SOURCE_TRACKER);
        if (listener.isPresent()) {
            return (TransformationSourceListener)listener.orElseThrow(() -> new IllegalStateException("Capability not found! Report this to the piglin proliferation github!"));
        }
        return null;
    }
}

