/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ht.treechop.api.ChopEvent;
import ht.treechop.common.config.ConfigHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TinkersConstruct {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ConfigHandler.COMMON.compatForTinkersConstruct.get().booleanValue() && ModList.get().isLoaded("tconstruct")) {
            MinecraftForge.EVENT_BUS.register(EventHandler.class);
        }
    }

    private static class EventHandler {
        private EventHandler() {
        }

        private static double treeAoeChops() {
            return ConfigHandler.COMMON.tinkersConstructTreeAOEChops.get().intValue();
        }

        private static double woodAoeChops() {
            return ConfigHandler.COMMON.tinkersConstructWoodAOEChops.get().intValue();
        }

        private static double expandedMultiplier() {
            return ConfigHandler.COMMON.tinkersConstructExpandedMultiplier.get();
        }

        @SubscribeEvent
        public static void onChop(ChopEvent.StartChopEvent event) {
            ToolStack toolStack;
            int bonusChops;
            ItemStack tool = event.getPlayer().m_21205_();
            if (tool.m_41720_() instanceof ModifiableItem && (bonusChops = EventHandler.getNumChops(toolStack = ToolStack.from((ItemStack)tool)) - 1) > 0) {
                event.setNumChops(event.getNumChops() + bonusChops);
            }
        }

        private static int getNumChops(ToolStack toolStack) {
            ModifierId expandedId = new ModifierId("tconstruct", "expanded");
            double level = toolStack.getModifierLevel(expandedId);
            if ("tconstruct:tree".equals(EventHandler.getAoeId(toolStack))) {
                return (int)(EventHandler.treeAoeChops() * (1.0 + level * EventHandler.expandedMultiplier()));
            }
            return (int)(EventHandler.woodAoeChops() * (1.0 + level * EventHandler.expandedMultiplier()));
        }

        private static String getAoeId(ToolStack toolStack) {
            block4: {
                try {
                    JsonElement genericData = IAreaOfEffectIterator.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)toolStack.getDefinition().getData().getAOE());
                    if (!genericData.isJsonObject()) break block4;
                    JsonObject data = genericData.getAsJsonObject();
                    String aoeId = EventHandler.getJsonStringOrEmpty(data, "type");
                    if (aoeId.equals("tconstruct:fallback")) {
                        if ((data = data.getAsJsonObject("if_matches")) != null) {
                            return EventHandler.getJsonStringOrEmpty(data, "type");
                        }
                        break block4;
                    }
                    return aoeId;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            return "";
        }

        private static String getJsonStringOrEmpty(JsonObject json, String field) {
            JsonElement element = json.get(field);
            return element != null ? element.getAsString() : "";
        }
    }
}

