/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.api.TreeData;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.EntityChopSettings;
import ht.treechop.common.util.TreeCache;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TheOneProbeInfoProvider
implements IProbeInfoProvider {
    private static final boolean SHOW_TREE_BLOCKS = true;
    private static final boolean SHOW_NUM_CHOPS_REMAINING = true;
    private static final TreeCache treeCache = new TreeCache();

    public static Void register(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)new TheOneProbeInfoProvider());
        return null;
    }

    private static BlockState getLogState(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState();
        }
        return state;
    }

    public ResourceLocation getID() {
        return TreeChop.resource("tree_info");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo builder, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        BlockPos blockPos = iProbeHitData.getPos();
        EntityChopSettings chopSettings = ChopUtil.getPlayerChopSettings(player);
        if (!ChopUtil.playerWantsToChop(player, chopSettings) || ChopUtil.isBlockChoppable((BlockGetter)level, blockPos, blockState)) {
            // empty if block
        }
        AtomicInteger numChops = new AtomicInteger(0);
        int maxNumTreeBlocks = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        TreeData tree = treeCache.getTree(level, blockPos, maxNumTreeBlocks);
        if (tree.isAProperTree(chopSettings.getTreesMustHaveLeaves())) {
            tree.getLogBlocks().ifPresent(treeBlocks -> {
                treeBlocks.forEach(pos -> numChops.getAndAdd(ChopUtil.getNumChops(level, pos)));
                builder.text((Component)new TranslatableComponent("treechop.waila.x_out_of_y_chops", new Object[]{numChops.get(), ChopUtil.numChopsToFell(level, treeBlocks)}));
                IItemStyle itemStyle = builder.defaultItemStyle();
                IProbeInfo tiles = builder.horizontal();
                treeBlocks.stream().collect(Collectors.groupingBy(pos -> {
                    BlockState state = level.m_8055_(pos);
                    return TheOneProbeInfoProvider.getLogState(level, pos, state).m_60734_();
                }, Collectors.counting())).forEach((block, count) -> {
                    ItemStack stack = block.m_5456_().m_7968_();
                    stack.m_41764_(count.intValue());
                    tiles.item(stack, itemStyle);
                });
            });
        }
    }
}

