/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings;

import ht.treechop.TreeChop;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.SneakBehavior;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class EntityChopSettings
extends ChopSettings {
    private boolean isSynced = false;

    public EntityChopSettings() {
    }

    public EntityChopSettings(ChopSettings template) {
        super(template);
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setSynced() {
        this.isSynced = true;
    }

    public CompoundTag makeSaveData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("choppingEnabled", this.getChoppingEnabled());
        nbt.m_128379_("fellingEnabled", this.getFellingEnabled());
        nbt.m_128359_("sneakBehavior", this.getSneakBehavior().name());
        nbt.m_128379_("treesMustHaveLeaves", this.getTreesMustHaveLeaves());
        nbt.m_128379_("chopInCreativeMode", this.getChopInCreativeMode());
        nbt.m_128379_("isSynced", this.isSynced());
        return nbt;
    }

    public EntityChopSettings readSaveData(CompoundTag tag) {
        if (tag.m_128441_("isSynced")) {
            String sneakBehaviorId;
            Optional<Boolean> choppingEnabled = this.getBoolean(tag, "choppingEnabled");
            Optional<Boolean> fellingEnabled = this.getBoolean(tag, "fellingEnabled");
            Optional<Boolean> onlyChopTreesWithLeaves = this.getBoolean(tag, "treesMustHaveLeaves");
            Optional<Boolean> chopInCreativeMode = this.getBoolean(tag, "chopInCreativeMode");
            Optional<Boolean> isSynced = this.getBoolean(tag, "isSynced");
            SneakBehavior defaultSneakBehavior = ConfigHandler.defaultChopSettings.get().getSneakBehavior();
            String string = sneakBehaviorId = tag.m_128441_("sneakBehavior") ? tag.m_128461_("sneakBehavior") : "";
            if (sneakBehaviorId.isEmpty()) {
                this.setSneakBehavior(defaultSneakBehavior);
            } else {
                SneakBehavior sneakBehavior;
                try {
                    sneakBehavior = SneakBehavior.valueOf(sneakBehaviorId);
                }
                catch (IllegalArgumentException e) {
                    TreeChop.LOGGER.warn(String.format("NBT contains bad sneak behavior value \"%s\"; using default value \"%s\"", tag.m_128461_("sneakBehavior"), defaultSneakBehavior.name()));
                    sneakBehavior = defaultSneakBehavior;
                }
                this.setSneakBehavior(sneakBehavior);
            }
            this.setChoppingEnabled(choppingEnabled.orElse(this.getChoppingEnabled()));
            this.setFellingEnabled(fellingEnabled.orElse(this.getFellingEnabled()));
            this.setTreesMustHaveLeaves(onlyChopTreesWithLeaves.orElse(this.getTreesMustHaveLeaves()));
            this.setChopInCreativeMode(chopInCreativeMode.orElse(this.getChopInCreativeMode()));
            if (isSynced.orElse(false).booleanValue()) {
                this.setSynced();
            }
        }
        return this;
    }
}

