/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class ChopResult {
    public static final ChopResult IGNORED = new ChopResult(null, Collections.emptyList(), Collections.emptyList());
    public static final int MAX_NUM_FELLING_EFFECTS = 32;
    private final Level level;
    private final Collection<Chop> chops;
    private final Collection<BlockPos> fells;

    public ChopResult(Level level, Collection<Chop> chops, Collection<BlockPos> fells) {
        this.level = level;
        this.chops = chops;
        this.fells = fells;
    }

    private static void chopBlocks(Level level, Player player, ItemStack tool, Stream<Chop> chops, boolean felling) {
        chops.forEach(chop -> chop.apply(level, player, tool, felling));
    }

    private static void fellBlocks(Level level, BlockPos targetPos, Entity agent, Stream<BlockPos> blocks) {
        Consumer<BlockPos> blockBreaker;
        ServerPlayer player;
        if (level.m_5776_() || agent instanceof ServerPlayer && (player = (ServerPlayer)agent).m_7500_()) {
            BlockState air = Blocks.f_50016_.m_49966_();
            blockBreaker = pos -> level.m_46597_(pos, air);
        } else {
            blockBreaker = pos -> ChopResult.harvestWorldBlock(null, level, pos, ItemStack.f_41583_);
        }
        blocks.forEach(blockBreaker);
    }

    private static void playBlockBreakEffects(Level level, List<BlockPos> logs, List<BlockPos> leaves) {
        int numLogsAndLeaves = logs.size() + leaves.size();
        int numEffects = Math.min((int)Math.ceil(Math.sqrt(numLogsAndLeaves)), 32) - 1;
        int numLeavesEffects = Math.max(1, (int)Math.ceil((double)numEffects * ((double)leaves.size() / (double)numLogsAndLeaves)));
        int numLogsEffects = Math.max(1, numEffects - numLeavesEffects);
        Collections.shuffle(logs);
        Collections.shuffle(leaves);
        Stream.concat(logs.stream().limit(numLogsEffects), leaves.stream().limit(numLeavesEffects)).forEach(pos -> level.m_46796_(2001, pos, Block.m_49956_((BlockState)level.m_8055_(pos))));
    }

    private static void harvestWorldBlock(Entity agent, Level level, BlockPos pos, ItemStack tool) {
        BlockState blockState = level.m_8055_(pos);
        if (level instanceof ServerLevel) {
            FluidState fluidStateOrAir = level.m_6425_(pos);
            blockState.m_60734_().m_6786_((LevelAccessor)level, pos, blockState);
            Block.m_49881_((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)agent, (ItemStack)tool);
            level.m_46597_(pos, fluidStateOrAir.m_76188_());
        }
    }

    public boolean apply(BlockPos targetPos, ServerPlayer agent, ItemStack tool, boolean breakLeaves) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            GameType gameType = agent.f_8941_.m_9290_();
            AtomicBoolean somethingChanged = new AtomicBoolean(false);
            List<BlockPos> logs = Stream.concat(this.chops.stream().map(Chop::getBlockPos), this.fells.stream()).filter(pos -> !somethingChanged.get() && !agent.m_36187_((Level)level2, pos, gameType)).peek(pos -> {
                BlockState blockState = level2.m_8055_(pos);
                somethingChanged.compareAndSet(false, blockState.m_60795_());
            }).collect(Collectors.toList());
            if (somethingChanged.get()) {
                return true;
            }
            ChopResult.chopBlocks((Level)level2, (Player)agent, tool, this.chops.stream(), this.isFelling());
            if (this.isFelling()) {
                List<Object> leaves = breakLeaves ? ChopUtil.getTreeLeaves((Level)level2, logs).stream().filter(pos -> !agent.m_36187_((Level)level2, pos, agent.f_8941_.m_9290_())).filter(pos -> !this.decayLeavesInsteadOfBreaking(level2, (BlockPos)pos)).collect(Collectors.toList()) : Collections.emptyList();
                logs.remove(targetPos);
                ChopResult.playBlockBreakEffects((Level)level2, logs, leaves);
                this.fells.remove(targetPos);
                ChopResult.fellBlocks((Level)level2, targetPos, (Entity)agent, Stream.of(this.fells, leaves).flatMap(Collection::stream));
                return true;
            }
        }
        return false;
    }

    private boolean decayLeavesInsteadOfBreaking(ServerLevel level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_61138_((Property)LeavesBlock.f_54419_) && blockState.m_61138_((Property)LeavesBlock.f_54418_)) {
            BlockState decayingState = (BlockState)((BlockState)blockState.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(7));
            decayingState.m_60735_(level, pos, level.f_46441_);
            return true;
        }
        return false;
    }

    public boolean isFelling() {
        return !this.fells.isEmpty();
    }
}

