/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import com.mojang.datafixers.util.Pair;
import ht.treechop.TreeChop;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.registry.ForgeModBlocks;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeChoppedLogBakedModel
extends ChoppedLogBakedModel
implements IDynamicBakedModel {
    public static ModelProperty<Map<Direction, BlockState>> STRIPPED_NEIGHBORS = new ModelProperty();
    public static ModelProperty<BlockState> STRIPPED_BLOCK_STATE = new ModelProperty();
    public static ModelProperty<Integer> RADIUS = new ModelProperty();
    public static ModelProperty<ChoppedLogShape> CHOPPED_LOG_SHAPE = new ModelProperty();

    public static void overrideBlockStateModels(ModelBakeEvent event) {
        for (BlockState blockState : ((Block)ForgeModBlocks.CHOPPED_LOG.get()).m_49965_().m_61056_()) {
            ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
            BakedModel existingModel = event.getModelManager().m_119422_(variantMRL);
            if (existingModel == event.getModelManager().m_119409_()) {
                TreeChop.LOGGER.warn("Did not find the expected vanilla baked model(s) for treechop:chopped_log in registry");
                continue;
            }
            if (existingModel instanceof ForgeChoppedLogBakedModel) {
                TreeChop.LOGGER.warn("Tried to replace ChoppedLogBakedModel twice");
                continue;
            }
            BakedModel customModel = new ForgeChoppedLogBakedModel().m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), null, null);
            event.getModelRegistry().put(variantMRL, customModel);
        }
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack itemStack, boolean fabulous) {
        return Collections.singletonList(Pair.of((Object)this, (Object)RENDER_TYPE));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            BlockState strippedState = ChopUtil.getStrippedState(level, pos, entity.getOriginalState());
            ModelDataMap.Builder builder = new ModelDataMap.Builder();
            builder.withInitial(STRIPPED_NEIGHBORS, this.getStrippedNeighbors(level, pos, entity));
            builder.withInitial(STRIPPED_BLOCK_STATE, (Object)strippedState);
            builder.withInitial(RADIUS, (Object)entity.getRadius());
            builder.withInitial(CHOPPED_LOG_SHAPE, (Object)entity.getShape());
            return builder.build();
        }
        return new ModelDataMap.Builder().build();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        if (side == null) {
            BlockState strippedState = this.or((BlockState)extraData.getData(STRIPPED_BLOCK_STATE), Blocks.f_50010_.m_49966_());
            Map<Direction, BlockState> strippedNeighbors = this.or((Map)extraData.getData(STRIPPED_NEIGHBORS), Collections.emptyMap());
            ChoppedLogShape shape = this.or((ChoppedLogShape)((Object)extraData.getData(CHOPPED_LOG_SHAPE)), ChoppedLogShape.PILLAR_Y);
            int radius = this.or((Integer)extraData.getData(RADIUS), 8);
            return this.getQuads(strippedState, shape, radius, rand, strippedNeighbors).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        BlockState strippedState = this.or((BlockState)data.getData(STRIPPED_BLOCK_STATE), Blocks.f_50010_.m_49966_());
        return ForgeChoppedLogBakedModel.getBlockModel(strippedState).m_6160_();
    }

    private <T> T or(T value, T fallback) {
        return value != null ? value : fallback;
    }
}

