/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.model;

import com.mojang.datafixers.util.Pair;
import ht.treechop.client.model.ModelUtil;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.Vector3;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class ChoppedLogBakedModel
implements UnbakedModel,
BakedModel {
    private static TextureAtlasSprite defaultSprite;
    protected static final ResourceLocation DEFAULT_TEXTURE_RESOURCE;
    public static final RenderType RENDER_TYPE;

    private static BlockState getStrippedNeighbor(BlockAndTintGetter level, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.m_142300_(direction);
        return ChopUtil.getStrippedState(level, pos, level.m_8055_(neighborPos));
    }

    protected Map<Direction, BlockState> getStrippedNeighbors(BlockAndTintGetter level, BlockPos pos, ChoppedLogBlock.MyEntity entity) {
        if (entity.getOriginalState().m_60804_((BlockGetter)level, pos)) {
            return entity.getShape().getSolidSides((BlockGetter)level, pos).stream().collect(Collectors.toMap(side -> side, side -> ChoppedLogBakedModel.getStrippedNeighbor(level, pos, side)));
        }
        return Collections.emptyMap();
    }

    protected List<BakedQuad> getBlockQuads(BlockState blockState, Direction side, Random rand) {
        BakedModel model = ChoppedLogBakedModel.getBlockModel(blockState);
        return model.m_6840_(blockState, side, rand);
    }

    @NotNull
    public static BakedModel getBlockModel(BlockState blockState) {
        ModelResourceLocation modelLocation = BlockModelShaper.m_110895_((BlockState)blockState);
        return Minecraft.m_91087_().m_91304_().m_119422_(modelLocation);
    }

    @NotNull
    public Collection<ResourceLocation> m_7970_() {
        return Collections.emptyList();
    }

    @NotNull
    public Collection<Material> m_5500_(@NotNull Function<ResourceLocation, UnbakedModel> var1, @NotNull Set<Pair<String, String>> var2) {
        return Collections.emptyList();
    }

    @Nullable
    public BakedModel m_7611_(@NotNull ModelBakery modelBakery, Function<Material, TextureAtlasSprite> textureGetter, ModelState modelState, ResourceLocation modelId) {
        defaultSprite = textureGetter.apply(new Material(TextureAtlas.f_118259_, DEFAULT_TEXTURE_RESOURCE));
        return this;
    }

    @NotNull
    public List<BakedQuad> m_6840_(@Nullable BlockState blockState, @Nullable Direction direction, @NotNull Random randomSource) {
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.getDefaultSprite();
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    protected TextureAtlasSprite getDefaultSprite() {
        return defaultSprite;
    }

    protected Stream<BakedQuad> getQuads(BlockState strippedState, ChoppedLogShape shape, int radius, Random random, Map<Direction, BlockState> strippedNeighbors) {
        Direction[] allDirections = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, null};
        AABB box = shape.getBoundingBox(radius);
        Vector3 mins = new Vector3(box.f_82288_, box.f_82289_, box.f_82290_);
        Vector3 maxes = new Vector3(box.f_82291_, box.f_82292_, box.f_82293_);
        return Stream.concat(Arrays.stream(allDirections).flatMap(side -> this.getBlockQuads(strippedState, (Direction)side, random).stream().map(quad -> ModelUtil.trimQuad(quad, mins, maxes))), strippedNeighbors.entrySet().stream().flatMap(entry -> {
            Direction side = (Direction)entry.getKey();
            BlockState strippedNeighbor = (BlockState)entry.getValue();
            Vec3i normal = side.m_122436_().m_142393_(16);
            Vector3 transform = new Vector3(normal.m_123341_(), normal.m_123342_(), normal.m_123343_());
            return ChoppedLogBakedModel.getBlockModel(strippedNeighbor).m_6840_(strippedNeighbor, side.m_122424_(), random).stream().map(quad -> ModelUtil.translateQuad(quad, transform));
        })).filter(Objects::nonNull);
    }

    static {
        DEFAULT_TEXTURE_RESOURCE = new ResourceLocation("block/stripped_oak_log");
        RENDER_TYPE = RenderType.m_110463_();
    }
}

