/*
 * Decompiled with CFR 0.152.
 */
package com.limitedchunks.config;

import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration {
    public final ForgeConfigSpec.IntValue chunkunloadnoplayer;
    public final ForgeConfigSpec.BooleanValue debugLog;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludedtickets;

    protected CommonConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("Chunk settings");
        builder.comment("How long a player can keep chunkloaded chunks active after logging out. Default: 10 min");
        this.chunkunloadnoplayer = builder.defineInRange("chunkunloadnoplayer", 10, 0, 2000);
        builder.comment("Print log messages for which chunk tickets are unloaded where. Default: false");
        this.debugLog = builder.define("debugmessage", false);
        builder.comment("List of excluded ticket/chunkload types, these are mod-specific. : e.g. format :  [\"mekanism\", \"player\"]");
        this.excludedtickets = builder.defineList("excludedtickets", Collections.emptyList(), e -> e instanceof String);
        builder.pop();
    }
}

