/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.registry;

import java.util.function.Supplier;
import mod.schnappdragon.habitat.common.entity.vehicle.HabitatBoat;
import mod.schnappdragon.habitat.common.item.FairyRingMushroomItem;
import mod.schnappdragon.habitat.common.item.FuelBlockItem;
import mod.schnappdragon.habitat.common.item.HabitatBoatItem;
import mod.schnappdragon.habitat.common.item.HabitatChestItem;
import mod.schnappdragon.habitat.common.item.KabloomFruitItem;
import mod.schnappdragon.habitat.common.item.WallOrBaseItem;
import mod.schnappdragon.habitat.core.misc.HabitatFoods;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.util.CompatHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class HabitatItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"habitat");
    public static final RegistryObject<Item> RAFFLESIA = ITEMS.register("rafflesia", () -> new ItemNameBlockItem((Block)HabitatBlocks.RAFFLESIA.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final RegistryObject<Item> KABLOOM_PULP = ITEMS.register("kabloom_pulp", () -> new ItemNameBlockItem((Block)HabitatBlocks.KABLOOM_BUSH.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(HabitatFoods.KABLOOM_PULP)));
    public static final RegistryObject<Item> KABLOOM_FRUIT = ITEMS.register("kabloom_fruit", () -> new KabloomFruitItem(new Item.Properties().m_41487_(16).m_41491_(CreativeModeTab.f_40757_)));
    public static final RegistryObject<Item> KABLOOM_FRUIT_PILE = ITEMS.register("kabloom_fruit_pile", () -> new BlockItem((Block)HabitatBlocks.KABLOOM_FRUIT_PILE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final RegistryObject<Item> KABLOOM_PULP_BLOCK = ITEMS.register("kabloom_pulp_block", () -> new BlockItem((Block)HabitatBlocks.KABLOOM_PULP_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final RegistryObject<Item> SLIME_FERN = ITEMS.register("slime_fern", () -> new WallOrBaseItem((Block)HabitatBlocks.SLIME_FERN.get(), (Block)HabitatBlocks.WALL_SLIME_FERN.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final RegistryObject<Item> ORANGE_BALL_CACTUS_FLOWER = HabitatItems.registerBlockItem("orange_ball_cactus_flower", HabitatBlocks.ORANGE_BALL_CACTUS_FLOWER, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> PINK_BALL_CACTUS_FLOWER = HabitatItems.registerBlockItem("pink_ball_cactus_flower", HabitatBlocks.PINK_BALL_CACTUS_FLOWER, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> RED_BALL_CACTUS_FLOWER = HabitatItems.registerBlockItem("red_ball_cactus_flower", HabitatBlocks.RED_BALL_CACTUS_FLOWER, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> YELLOW_BALL_CACTUS_FLOWER = HabitatItems.registerBlockItem("yellow_ball_cactus_flower", HabitatBlocks.YELLOW_BALL_CACTUS_FLOWER, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> ORANGE_BALL_CACTUS = HabitatItems.registerBlockItem("orange_ball_cactus", HabitatBlocks.ORANGE_BALL_CACTUS, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> PINK_BALL_CACTUS = HabitatItems.registerBlockItem("pink_ball_cactus", HabitatBlocks.PINK_BALL_CACTUS, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> RED_BALL_CACTUS = HabitatItems.registerBlockItem("red_ball_cactus", HabitatBlocks.RED_BALL_CACTUS, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> YELLOW_BALL_CACTUS = HabitatItems.registerBlockItem("yellow_ball_cactus", HabitatBlocks.YELLOW_BALL_CACTUS, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> DRIED_BALL_CACTUS = ITEMS.register("dried_ball_cactus", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40755_).m_41489_(HabitatFoods.DRIED_BALL_CACTUS)));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM = ITEMS.register("fairy_ring_mushroom", () -> new FairyRingMushroomItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_BLOCK = HabitatItems.registerBlockItem("fairy_ring_mushroom_block", HabitatBlocks.FAIRY_RING_MUSHROOM_BLOCK, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_STEM = HabitatItems.registerBlockItem("fairy_ring_mushroom_stem", HabitatBlocks.FAIRY_RING_MUSHROOM_STEM, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> FAIRYLIGHT = HabitatItems.registerBlockItem("fairylight", HabitatBlocks.FAIRYLIGHT, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> FAIRY_SPORE_LANTERN = HabitatItems.registerBlockItem("fairy_spore_lantern", HabitatBlocks.FAIRY_SPORE_LANTERN, CreativeModeTab.f_40750_);
    public static final RegistryObject<Item> STRIPPED_FAIRY_RING_MUSHROOM_STEM = HabitatItems.registerBlockItem("stripped_fairy_ring_mushroom_stem", HabitatBlocks.STRIPPED_FAIRY_RING_MUSHROOM_STEM, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> ENHANCED_FAIRY_RING_MUSHROOM_STEM = HabitatItems.registerBlockItem("enhanced_fairy_ring_mushroom_stem", HabitatBlocks.ENHANCED_FAIRY_RING_MUSHROOM_STEM, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> STRIPPED_FAIRY_RING_MUSHROOM_HYPHAE = HabitatItems.registerBlockItem("stripped_fairy_ring_mushroom_hyphae", HabitatBlocks.STRIPPED_FAIRY_RING_MUSHROOM_HYPHAE, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_HYPHAE = HabitatItems.registerBlockItem("fairy_ring_mushroom_hyphae", HabitatBlocks.FAIRY_RING_MUSHROOM_HYPHAE, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_PLANKS = HabitatItems.registerBlockItem("fairy_ring_mushroom_planks", HabitatBlocks.FAIRY_RING_MUSHROOM_PLANKS, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_SLAB = HabitatItems.registerBlockItem("fairy_ring_mushroom_slab", HabitatBlocks.FAIRY_RING_MUSHROOM_SLAB, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_STAIRS = HabitatItems.registerBlockItem("fairy_ring_mushroom_stairs", HabitatBlocks.FAIRY_RING_MUSHROOM_STAIRS, CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_PRESSURE_PLATE = HabitatItems.registerBlockItem("fairy_ring_mushroom_pressure_plate", HabitatBlocks.FAIRY_RING_MUSHROOM_PRESSURE_PLATE, CompatHelper.compatItemGroup(CreativeModeTab.f_40751_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_FENCE = ITEMS.register("fairy_ring_mushroom_fence", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_FENCE.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40750_, "enhanced_mushrooms"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_FENCE_GATE = ITEMS.register("fairy_ring_mushroom_fence_gate", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_FENCE_GATE.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40751_, "enhanced_mushrooms"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_BUTTON = HabitatItems.registerBlockItem("fairy_ring_mushroom_button", HabitatBlocks.FAIRY_RING_MUSHROOM_BUTTON, CompatHelper.compatItemGroup(CreativeModeTab.f_40751_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_TRAPDOOR = HabitatItems.registerBlockItem("fairy_ring_mushroom_trapdoor", HabitatBlocks.FAIRY_RING_MUSHROOM_TRAPDOOR, CompatHelper.compatItemGroup(CreativeModeTab.f_40751_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_DOOR = HabitatItems.registerBlockItem("fairy_ring_mushroom_door", HabitatBlocks.FAIRY_RING_MUSHROOM_DOOR, CompatHelper.compatItemGroup(CreativeModeTab.f_40751_, "enhanced_mushrooms"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_SIGN = ITEMS.register("fairy_ring_mushroom_sign", () -> new SignItem(HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40750_, "enhanced_mushrooms")).m_41487_(16), (Block)HabitatBlocks.FAIRY_RING_MUSHROOM_SIGN.get(), (Block)HabitatBlocks.FAIRY_RING_MUSHROOM_WALL_SIGN.get()));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_VERTICAL_SLAB = ITEMS.register("fairy_ring_mushroom_vertical_slab", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_VERTICAL_SLAB.get(), 150, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_BOOKSHELF = ITEMS.register("fairy_ring_mushroom_bookshelf", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_BOOKSHELF.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_LADDER = ITEMS.register("fairy_ring_mushroom_ladder", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_LADDER.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40750_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> STRIPPED_FAIRY_RING_MUSHROOM_POST = ITEMS.register("stripped_fairy_ring_mushroom_post", () -> new FuelBlockItem((Block)HabitatBlocks.STRIPPED_FAIRY_RING_MUSHROOM_POST.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_POST = ITEMS.register("fairy_ring_mushroom_post", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_POST.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40749_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_CHEST = ITEMS.register("fairy_ring_mushroom_chest", () -> new HabitatChestItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_CHEST.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40750_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_TRAPPED_CHEST = ITEMS.register("fairy_ring_mushroom_trapped_chest", () -> new HabitatChestItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_TRAPPED_CHEST.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40751_, "enhanced_mushrooms", "quark"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_BEEHIVE = HabitatItems.registerBlockItem("fairy_ring_mushroom_beehive", HabitatBlocks.FAIRY_RING_MUSHROOM_BEEHIVE, CompatHelper.compatItemGroup(CreativeModeTab.f_40750_, "enhanced_mushrooms", "buzzier_bees"));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_CABINET = ITEMS.register("fairy_ring_mushroom_cabinet", () -> new FuelBlockItem((Block)HabitatBlocks.FAIRY_RING_MUSHROOM_CABINET.get(), 300, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40750_, "enhanced_mushrooms", "farmersdelight"))));
    public static final RegistryObject<Item> FAIRY_RING_MUSHROOM_BOAT = ITEMS.register("fairy_ring_mushroom_boat", () -> new HabitatBoatItem(HabitatBoat.Type.FAIRY_RING_MUSHROOM, HabitatItems.getProperties(CompatHelper.compatItemGroup(CreativeModeTab.f_40752_, "enhanced_mushrooms"))));
    public static final RegistryObject<Item> POOKA_SPAWN_EGG = ITEMS.register("pooka_spawn_egg", () -> new ForgeSpawnEggItem(HabitatEntityTypes.POOKA, 15920353, 16771962, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    public static final RegistryObject<Item> PASSERINE_SPAWN_EGG = ITEMS.register("passerine_spawn_egg", () -> new ForgeSpawnEggItem(HabitatEntityTypes.PASSERINE, 1259855, 0xCC3C55, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));

    private static Item.Properties getProperties(CreativeModeTab group) {
        return new Item.Properties().m_41491_(group);
    }

    private static RegistryObject<Item> registerBlockItem(String name, Supplier<Block> block, CreativeModeTab group) {
        return HabitatItems.registerBlockItem(name, block, HabitatItems.getProperties(group));
    }

    private static RegistryObject<Item> registerBlockItem(String name, Supplier<Block> block, Item.Properties properties) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), properties));
    }
}

