/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class ColorableParticleOption
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ColorableParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<ColorableParticleOption>(){

        public ColorableParticleOption fromCommand(ParticleType<ColorableParticleOption> type, StringReader reader) throws CommandSyntaxException {
            Vector3f vector3f = ColorableParticleOption.readVector3f(reader);
            return new ColorableParticleOption(type, vector3f);
        }

        public ColorableParticleOption fromNetwork(ParticleType<ColorableParticleOption> type, FriendlyByteBuf buffer) {
            return new ColorableParticleOption(type, ColorableParticleOption.readVector3f(buffer));
        }
    };
    protected final ParticleType<ColorableParticleOption> type;
    protected final Vector3f color;

    public static Codec<ColorableParticleOption> codec(ParticleType<ColorableParticleOption> type) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Vector3f.f_176762_.fieldOf("color").forGetter(codec -> codec.color)).apply((Applicative)builder, color -> new ColorableParticleOption(type, (Vector3f)color)));
    }

    public ColorableParticleOption(ParticleType<ColorableParticleOption> type, Vector3f color) {
        this.type = type;
        this.color = color;
    }

    public static Vector3f readVector3f(StringReader reader) throws CommandSyntaxException {
        reader.expect(' ');
        float f = reader.readFloat();
        reader.expect(' ');
        float f1 = reader.readFloat();
        reader.expect(' ');
        float f2 = reader.readFloat();
        return new Vector3f(f, f1, f2);
    }

    public static Vector3f readVector3f(FriendlyByteBuf buffer) {
        return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.color.m_122239_());
        buffer.writeFloat(this.color.m_122260_());
        buffer.writeFloat(this.color.m_122269_());
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.color.m_122239_()), Float.valueOf(this.color.m_122260_()), Float.valueOf(this.color.m_122269_()));
    }

    public Vector3f getColor() {
        return this.color;
    }

    public ParticleType<ColorableParticleOption> m_6012_() {
        return this.type;
    }
}

