/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.monster;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.entity.IHabitatShearable;
import mod.schnappdragon.habitat.core.HabitatConfig;
import mod.schnappdragon.habitat.core.misc.HabitatCriterionTriggers;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatEntityTypeTags;
import mod.schnappdragon.habitat.core.tags.HabitatItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Pooka
extends Rabbit
implements Enemy,
IHabitatShearable {
    private static final EntityDataAccessor<Integer> DATA_STATE_ID = SynchedEntityData.m_135353_(Pooka.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int aidId;
    private int aidDuration;
    private int ailmentId;
    private int ailmentDuration;
    private int forgiveTicks;
    private int aidTicks;

    public Pooka(EntityType<? extends Pooka> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 3;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PookaPanicGoal(2.2));
        this.f_21346_.m_25352_(1, (Goal)new PookaHurtByTargetGoal().m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, new PookaNearestAttackableTargetGoal<Player>(Player.class));
        this.f_21346_.m_25352_(2, new PookaNearestAttackableTargetGoal<Mob>(Mob.class, mob -> mob.m_6095_().m_204039_(HabitatEntityTypeTags.POOKA_ATTACK_TARGETS)));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new PookaTemptGoal(1.25, Ingredient.m_204132_(HabitatItemTags.POOKA_FOOD), false));
        this.f_21345_.m_25352_(4, (Goal)new PookaMeleeAttackGoal());
        this.f_21345_.m_25352_(4, new PookaAvoidEntityGoal<Mob>(Mob.class, 10.0f, 2.2, 2.2, mob -> mob.m_6095_().m_204039_(HabitatEntityTypeTags.PACIFIED_POOKA_SCARED_BY)));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 8.0);
    }

    protected int m_6552_(Player player) {
        return this.f_21364_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STATE_ID, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AidId", this.aidId);
        compound.m_128405_("AidDuration", this.aidDuration);
        compound.m_128405_("AilmentId", this.ailmentId);
        compound.m_128405_("AilmentDuration", this.ailmentDuration);
        compound.m_128405_("ForgiveTicks", this.forgiveTicks);
        compound.m_128405_("AidTicks", this.aidTicks);
        compound.m_128405_("State", this.getStateId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAidAndAilment(compound.m_128451_("AidId"), compound.m_128451_("AidDuration"), compound.m_128451_("AilmentId"), compound.m_128451_("AilmentDuration"));
        this.forgiveTicks = compound.m_128451_("ForgiveTicks");
        this.aidTicks = compound.m_128451_("AidTicks");
        this.setStateId(compound.m_128451_("State"));
    }

    private void setAidAndAilment(int aidI, int aidD, int ailI, int ailD) {
        this.aidId = aidI;
        this.aidDuration = aidD;
        this.ailmentId = ailI;
        this.ailmentDuration = ailD;
    }

    private void setStateId(int state) {
        this.f_19804_.m_135381_(DATA_STATE_ID, (Object)state);
    }

    public int getStateId() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(DATA_STATE_ID)), (int)0, (int)2);
    }

    private void setState(State state) {
        this.setStateId(state.ordinal());
    }

    public State getState() {
        return State.getStateById(this.getStateId());
    }

    public boolean isHostile() {
        return this.getState().equals((Object)State.HOSTILE);
    }

    public boolean isPacified() {
        return this.getState().equals((Object)State.PACIFIED);
    }

    private void setForgiveTimer() {
        this.forgiveTicks = 12000;
    }

    private void setAidTimer() {
        this.aidTicks = (int)((20.0f + this.f_19796_.nextFloat() * 4.0f) * (float)((Integer)HabitatConfig.COMMON.pookaAidCooldown.get()).intValue());
    }

    private void resetAidTimer() {
        this.aidTicks = 0;
    }

    public void m_6135_() {
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)14);
        }
        super.m_6135_();
    }

    public void m_8024_() {
        LivingEntity livingentity;
        if (this.forgiveTicks > 0) {
            --this.forgiveTicks;
        }
        if (this.aidTicks > 0) {
            --this.aidTicks;
        }
        if (this.f_19861_ && this.isHostile() && this.f_29652_ == 0 && (livingentity = this.m_5448_()) != null && this.m_20280_((Entity)livingentity) < 16.0) {
            this.facePoint(livingentity.m_20185_(), livingentity.m_20189_());
            this.f_21342_.m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), this.f_21342_.m_24999_());
            this.m_29716_();
            this.f_29651_ = true;
        }
        super.m_8024_();
    }

    private void facePoint(double x, double z) {
        this.m_146922_((float)(Mth.m_14136_((double)(z - this.m_20189_()), (double)(x - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    public boolean m_6573_(Player player) {
        return !this.isHostile();
    }

    protected void m_6119_() {
        super.m_6119_();
        if (this.isHostile()) {
            this.m_21455_(true, true);
        }
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6084_() && !this.isHostile() && !this.m_6162_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        return this.onSheared(player, item, world, pos, fortune, SoundSource.PLAYERS);
    }

    @Override
    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune, SoundSource source) {
        this.f_19853_.m_142346_((Entity)player, GameEvent.f_157781_, pos);
        world.m_6269_(null, (Entity)this, (SoundEvent)HabitatSoundEvents.POOKA_SHEAR.get(), source, 1.0f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
        if (!this.f_19853_.m_5776_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
            world.m_7967_((Entity)Pooka.convertPookaToRabbit(this));
        }
        return Collections.emptyList();
    }

    public static Rabbit convertPookaToRabbit(Pooka pooka) {
        Rabbit rabbit = (Rabbit)EntityType.f_20517_.m_20615_(pooka.f_19853_);
        rabbit.m_7678_(pooka.m_20185_(), pooka.m_20186_(), pooka.m_20189_(), pooka.m_146908_(), pooka.m_146909_());
        rabbit.m_21153_(pooka.m_21223_());
        rabbit.f_20883_ = pooka.f_20883_;
        if (pooka.m_8077_()) {
            rabbit.m_6593_(pooka.m_7770_());
            rabbit.m_20340_(pooka.m_20151_());
        }
        if (pooka.m_21532_()) {
            rabbit.m_21530_();
        }
        rabbit.m_29733_(pooka.m_29719_());
        rabbit.m_6863_(pooka.m_6162_());
        rabbit.m_20331_(pooka.m_20147_());
        return rabbit;
    }

    public static Pooka convertRabbitToPooka(Rabbit rabbit) {
        Pooka pooka = (Pooka)((EntityType)HabitatEntityTypes.POOKA.get()).m_20615_(rabbit.f_19853_);
        pooka.m_7678_(rabbit.m_20185_(), rabbit.m_20186_(), rabbit.m_20189_(), rabbit.m_146908_(), rabbit.m_146909_());
        pooka.m_21153_(rabbit.m_21223_());
        pooka.f_20883_ = rabbit.f_20883_;
        if (rabbit.m_8077_()) {
            pooka.m_6593_(rabbit.m_7770_());
            pooka.m_20340_(rabbit.m_20151_());
        }
        pooka.m_21530_();
        pooka.setForgiveTimer();
        Pair<Integer, Integer> aid = pooka.getRandomAid();
        Pair<Integer, Integer> ailment = pooka.getRandomAilment();
        pooka.setAidAndAilment((Integer)aid.getLeft(), (Integer)aid.getRight(), (Integer)ailment.getLeft(), (Integer)ailment.getRight());
        pooka.m_29733_(rabbit.m_29719_());
        pooka.m_6863_(rabbit.m_6162_());
        pooka.m_20331_(rabbit.m_20147_());
        return pooka;
    }

    public SoundSource m_5720_() {
        return this.isHostile() ? SoundSource.HOSTILE : SoundSource.NEUTRAL;
    }

    protected SoundEvent m_29718_() {
        return (SoundEvent)HabitatSoundEvents.POOKA_JUMP.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)HabitatSoundEvents.POOKA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)HabitatSoundEvents.POOKA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)HabitatSoundEvents.POOKA_DEATH.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result;
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6898_(stack)) {
            if (this.isHostile()) {
                if (!this.f_19853_.f_46443_) {
                    this.m_21530_();
                    this.m_142075_(player, hand, stack);
                    if (this.forgiveTicks == 0) {
                        int roll = this.f_19796_.nextInt(5);
                        if ((this.m_6162_() && roll > 0 || roll == 0) && this.isAlone()) {
                            this.setState(State.PACIFIED);
                            this.m_5496_((SoundEvent)HabitatSoundEvents.POOKA_PACIFY.get(), 1.0f, 1.0f);
                            HabitatCriterionTriggers.PACIFY_POOKA.trigger((ServerPlayer)player);
                            this.f_21344_.m_26573_();
                            this.m_6710_(null);
                            this.m_6703_(null);
                            this.f_19853_.m_7605_((Entity)this, (byte)18);
                        } else {
                            this.f_19853_.m_7605_((Entity)this, (byte)12);
                        }
                    } else {
                        this.forgiveTicks = (int)((double)this.forgiveTicks - (double)this.forgiveTicks * 0.1);
                        this.f_19853_.m_7605_((Entity)this, (byte)12);
                    }
                    this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_21223_() < this.m_21233_() && stack.m_41614_()) {
                if (!this.f_19853_.f_46443_) {
                    this.m_142075_(player, hand, stack);
                    this.m_5634_(stack.m_41720_().m_41473_().m_38744_());
                    this.m_146859_(GameEvent.f_157771_, this.m_146901_());
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        if ((result = super.m_6071_(player, hand)).m_19077_()) {
            this.m_21530_();
        }
        return result;
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack)) {
            this.m_5496_((SoundEvent)HabitatSoundEvents.POOKA_EAT.get(), 1.0f, 1.0f);
        }
        super.m_142075_(player, hand, stack);
    }

    private boolean isAlone() {
        return this.f_19853_.m_6443_(Pooka.class, this.m_142469_().m_82377_(16.0, 10.0, 16.0), Pooka::isHostile).size() == 1;
    }

    public void unpacify() {
        this.m_27594_();
        this.resetAidTimer();
        this.setForgiveTimer();
        this.setState(State.HOSTILE);
        this.f_19853_.m_7605_((Entity)this, (byte)13);
    }

    public Pooka getBreedOffspring(ServerLevel serverWorld, AgeableMob entity) {
        Pooka pooka = (Pooka)((EntityType)HabitatEntityTypes.POOKA.get()).m_20615_((Level)serverWorld);
        State state = State.HOSTILE;
        int i = this.getRandomRabbitType((LevelAccessor)serverWorld);
        Pair<Integer, Integer> aid = this.getRandomAid();
        int aidI = (Integer)aid.getLeft();
        int aidD = (Integer)aid.getRight();
        Pair<Integer, Integer> ailment = this.getRandomAilment();
        int ailI = (Integer)ailment.getLeft();
        int ailD = (Integer)ailment.getRight();
        if (entity instanceof Pooka) {
            Pooka parent = (Pooka)entity;
            if (!this.isHostile() && !parent.isHostile()) {
                state = State.PASSIVE;
            }
            if (this.f_19796_.nextInt(20) != 0) {
                i = this.f_19796_.nextBoolean() ? parent.m_29719_() : this.m_29719_();
            }
            if (this.f_19796_.nextInt(20) != 0) {
                if (this.f_19796_.nextBoolean()) {
                    aidI = parent.aidId;
                    aidD = parent.aidDuration;
                } else {
                    aidI = this.aidId;
                    aidD = this.aidDuration;
                }
            }
            if (this.f_19796_.nextInt(20) != 0) {
                if (this.f_19796_.nextBoolean()) {
                    ailI = parent.ailmentId;
                    ailD = parent.ailmentDuration;
                } else {
                    ailI = this.ailmentId;
                    ailD = this.ailmentDuration;
                }
            }
        }
        pooka.setState(state);
        pooka.m_29733_(i);
        pooka.setAidAndAilment(aidI, aidD, ailI, ailD);
        pooka.m_21530_();
        return pooka;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(HabitatItemTags.POOKA_FOOD);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7848_(Animal animal) {
        if (!(animal instanceof Pooka)) return false;
        Pooka pooka = (Pooka)animal;
        if (this.isHostile()) return false;
        if (pooka.isHostile()) return false;
        if (!super.m_7848_(animal)) return false;
        return true;
    }

    public static boolean checkPookaSpawnRules(EntityType<Pooka> pooka, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return world.m_46791_() != Difficulty.PEACEFUL && world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184234_) && world.m_7445_() >= 5 && world.m_6042_().m_63935_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Pair<Integer, Integer> aid = this.getRandomAid();
        Pair<Integer, Integer> ailment = this.getRandomAilment();
        int i = this.getRandomRabbitType((LevelAccessor)worldIn);
        if (spawnDataIn instanceof Rabbit.RabbitGroupData) {
            Rabbit.RabbitGroupData data = (Rabbit.RabbitGroupData)spawnDataIn;
            i = data.f_29749_;
        } else {
            spawnDataIn = new Rabbit.RabbitGroupData(i);
        }
        this.m_29733_(i);
        this.setState(State.HOSTILE);
        this.setAidAndAilment((Integer)aid.getLeft(), (Integer)aid.getRight(), (Integer)ailment.getLeft(), (Integer)ailment.getRight());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private int getRandomRabbitType(LevelAccessor world) {
        Holder biomeHolder = world.m_204166_(this.m_142538_());
        Biome biome = (Biome)biomeHolder.m_203334_();
        int i = this.f_19796_.nextInt(100);
        if (biome.m_47530_() == Biome.Precipitation.SNOW) {
            return i < 80 ? 1 : 3;
        }
        if (Biome.m_204183_((Holder)biomeHolder) == Biome.BiomeCategory.DESERT) {
            return 4;
        }
        return i < 50 ? 0 : (i < 90 ? 5 : 2);
    }

    private Pair<Integer, Integer> getRandomAid() {
        return this.getEffect(HabitatConfig.COMMON.pookaPositiveEffects);
    }

    private Pair<Integer, Integer> getRandomAilment() {
        return this.getEffect(HabitatConfig.COMMON.pookaNegativeEffects);
    }

    private Pair<Integer, Integer> getEffect(ForgeConfigSpec.ConfigValue<String> config) {
        List<String> stewEffectPairs = Arrays.asList(StringUtils.deleteWhitespace((String)((String)config.get())).split(","));
        String[] pair = stewEffectPairs.get(this.f_19796_.nextInt(stewEffectPairs.size())).split(":");
        return Pair.of((Object)Integer.parseInt(pair[0]), (Object)(Integer.parseInt(pair[1]) * 20));
    }

    public boolean m_7327_(Entity entityIn) {
        if (entityIn.m_6095_() == EntityType.f_20517_ && entityIn.m_6084_() && !entityIn.m_6673_(DamageSource.m_19370_((LivingEntity)this))) {
            this.m_5496_((SoundEvent)HabitatSoundEvents.POOKA_ATTACK.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            this.m_146852_(GameEvent.f_157808_, (Entity)this);
            Rabbit rabbit = (Rabbit)entityIn;
            rabbit.m_5496_((SoundEvent)HabitatSoundEvents.RABBIT_CONVERTED_TO_POOKA.get(), 1.0f, rabbit.m_6162_() ? (rabbit.m_21187_().nextFloat() - rabbit.m_21187_().nextFloat()) * 0.2f + 1.5f : (rabbit.m_21187_().nextFloat() - rabbit.m_21187_().nextFloat()) * 0.2f + 1.0f);
            rabbit.m_146870_();
            this.f_19853_.m_7967_((Entity)Pooka.convertRabbitToPooka(rabbit));
            for (int i = 0; i < 8; ++i) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)HabitatParticleTypes.FAIRY_RING_SPORE.get()), rabbit.m_20208_(0.5), rabbit.m_20227_(0.5), rabbit.m_20262_(0.5), 0, rabbit.m_21187_().nextGaussian(), 0.0, rabbit.m_21187_().nextGaussian(), 0.01);
            }
            return false;
        }
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag) {
            MobEffect effect;
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            this.m_5496_((SoundEvent)HabitatSoundEvents.POOKA_ATTACK.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            if (!this.m_6162_() && entityIn instanceof LivingEntity && (effect = MobEffect.m_19453_((int)this.ailmentId)) != null) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(effect, this.ailmentDuration * (this.f_19853_.m_46791_() == Difficulty.HARD ? 2 : 1)));
            }
        }
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            MobEffect effect = MobEffect.m_19453_((int)this.aidId);
            if (!this.m_6162_() && effect != null) {
                this.m_7292_(new MobEffectInstance(effect, this.aidDuration));
            }
            if (this.isPacified() && source.m_7639_() instanceof Player && !source.m_19390_()) {
                this.unpacify();
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_7822_(byte id) {
        switch (id) {
            case 12: {
                this.spawnParticles((ParticleOptions)ParticleTypes.f_123762_, 7, true);
                break;
            }
            case 13: {
                this.spawnParticles((ParticleOptions)ParticleTypes.f_123792_, 7, true);
                break;
            }
            case 14: {
                this.spawnParticles((ParticleOptions)HabitatParticleTypes.FAIRY_RING_SPORE.get(), 1, false);
                break;
            }
            case 15: {
                this.spawnParticles((ParticleOptions)HabitatParticleTypes.FAIRY_RING_SPORE.get(), 8, false);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    protected void spawnParticles(ParticleOptions particle, int number, boolean vanillaPresets) {
        for (int i = 0; i < number; ++i) {
            double d0 = this.f_19796_.nextGaussian() * (vanillaPresets ? 0.02 : 0.01);
            double d1 = vanillaPresets ? this.f_19796_.nextGaussian() * 0.02 : 0.0;
            double d2 = this.f_19796_.nextGaussian() * (vanillaPresets ? 0.02 : 0.01);
            double d3 = vanillaPresets ? 0.5 : 0.0;
            this.f_19853_.m_7106_(particle, this.m_20208_(0.5 + d3), this.m_20187_() + d3, this.m_20262_(0.5 + d3), d0, d1, d2);
        }
    }

    class PookaPanicGoal
    extends PanicGoal {
        public PookaPanicGoal(double speedIn) {
            super((PathfinderMob)Pooka.this, speedIn);
        }

        public void m_8037_() {
            super.m_8037_();
            Pooka.this.m_29725_(this.f_25685_);
        }
    }

    class PookaHurtByTargetGoal
    extends HurtByTargetGoal {
        private int timestamp;

        public PookaHurtByTargetGoal() {
            super((PathfinderMob)Pooka.this, new Class[0]);
        }

        public void m_8056_() {
            this.timestamp = this.f_26135_.m_21213_();
            super.m_8056_();
        }

        public boolean m_8036_() {
            return this.f_26135_.m_21213_() != this.timestamp && this.f_26135_.m_142581_() != null && this.m_26150_(this.f_26135_.m_142581_(), TargetingConditions.m_148352_().m_148355_().m_26893_());
        }

        public boolean m_8045_() {
            return Pooka.this.isHostile() && super.m_8045_();
        }

        protected void m_5766_(Mob mob, LivingEntity target) {
            if (mob instanceof Pooka) {
                Pooka pooka = (Pooka)mob;
                if (this.f_26135_.m_142582_((Entity)target)) {
                    if (pooka.isHostile()) {
                        super.m_5766_(mob, target);
                    } else if (pooka.isPacified() && target instanceof Player) {
                        pooka.unpacify();
                        super.m_5766_(mob, target);
                    }
                }
            }
        }
    }

    class PookaNearestAttackableTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public PookaNearestAttackableTargetGoal(@Nullable Class<T> targetClassIn, Predicate<LivingEntity> targetPredicate) {
            super((Mob)Pooka.this, targetClassIn, 10, true, false, targetPredicate);
        }

        public PookaNearestAttackableTargetGoal(Class<T> targetClassIn) {
            super((Mob)Pooka.this, targetClassIn, true);
        }

        public boolean m_8036_() {
            return Pooka.this.isHostile() && super.m_8036_();
        }
    }

    class PookaTemptGoal
    extends TemptGoal {
        public PookaTemptGoal(double speed, Ingredient temptItem, boolean scaredByMovement) {
            super((PathfinderMob)Pooka.this, speed, temptItem, scaredByMovement);
        }

        public boolean m_8036_() {
            return !Pooka.this.isHostile() && super.m_8036_();
        }

        public void m_8037_() {
            super.m_8037_();
            MobEffect aid = MobEffect.m_19453_((int)Pooka.this.aidId);
            if (!Pooka.this.m_6162_() && Pooka.this.aidTicks == 0 && aid != null) {
                this.f_25925_.m_7292_(new MobEffectInstance(aid, Pooka.this.aidDuration * 2));
                Pooka.this.setAidTimer();
            }
        }
    }

    class PookaMeleeAttackGoal
    extends MeleeAttackGoal {
        public PookaMeleeAttackGoal() {
            super((PathfinderMob)Pooka.this, 1.4, true);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }

        public boolean m_8036_() {
            return Pooka.this.isHostile() && super.m_8036_();
        }

        public boolean m_8045_() {
            return Pooka.this.isHostile() && super.m_8045_();
        }
    }

    class PookaAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public PookaAvoidEntityGoal(Class<T> entity, float range, double v1, double v2, Predicate<LivingEntity> predicate) {
            super((PathfinderMob)Pooka.this, entity, range, v1, v2, predicate);
        }

        public boolean m_8036_() {
            return !Pooka.this.isHostile() && super.m_8036_();
        }
    }

    public static enum State {
        HOSTILE,
        PACIFIED,
        PASSIVE;

        private static final State[] STATES;

        public static State getStateById(int id) {
            return STATES[Mth.m_14045_((int)id, (int)0, (int)2)];
        }

        static {
            STATES = State.values();
        }
    }
}

