/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class WoodPostBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_X = WoodPostBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_Y = WoodPostBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = WoodPostBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty[] CHAINED = new BooleanProperty[]{HabitatBlockStateProperties.CHAINED_DOWN, HabitatBlockStateProperties.CHAINED_UP, HabitatBlockStateProperties.CHAINED_NORTH, HabitatBlockStateProperties.CHAINED_SOUTH, HabitatBlockStateProperties.CHAINED_WEST, HabitatBlockStateProperties.CHAINED_EAST};
    private final Supplier<Block> strippedBlock;

    public WoodPostBlock(BlockBehaviour.Properties properties) {
        this(null, properties);
    }

    public WoodPostBlock(Supplier<Block> block, BlockBehaviour.Properties properties) {
        super(properties);
        this.strippedBlock = block;
        BlockState defaultState = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y);
        for (BooleanProperty property : CHAINED) {
            defaultState = (BlockState)defaultState.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(defaultState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case X: {
                return SHAPE_X;
            }
            case Y: {
                return SHAPE_Y;
            }
        }
        return SHAPE_Z;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, AXIS});
        for (BooleanProperty property : CHAINED) {
            builder.m_61104_(new Property[]{property});
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getRelevantState(context.m_43725_(), context.m_8083_(), context.m_43719_().m_122434_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.getRelevantState(worldIn, pos, (Direction.Axis)state.m_61143_(AXIS));
        if (!newState.equals(state)) {
            worldIn.m_46597_(pos, newState);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, ToolAction toolAction) {
        if (ToolActions.AXE_STRIP.equals(toolAction) && this.strippedBlock != null && this.strippedBlock.get() instanceof WoodPostBlock) {
            BlockState newState = (BlockState)((BlockState)this.strippedBlock.get().m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)))).m_61124_(AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
            for (BooleanProperty property : CHAINED) {
                newState = (BlockState)newState.m_61124_((Property)property, (Comparable)((Boolean)state.m_61143_((Property)property)));
            }
            return newState;
        }
        return super.getToolModifiedState(state, world, pos, player, stack, toolAction);
    }

    private BlockState getRelevantState(Level world, BlockPos pos, Direction.Axis axis) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_(AXIS, (Comparable)axis);
        for (Direction direction : Direction.values()) {
            BlockState sideState;
            if (direction.m_122434_() == axis || (!((sideState = world.m_8055_(pos.m_142300_(direction))).m_60734_() instanceof ChainBlock) || sideState.m_61143_((Property)ChainBlock.f_55923_) != direction.m_122434_()) && (direction != Direction.DOWN || !(sideState.m_60734_() instanceof LanternBlock) || !((Boolean)sideState.m_61143_((Property)LanternBlock.f_153459_)).booleanValue())) continue;
            state = (BlockState)state.m_61124_((Property)CHAINED[direction.ordinal()], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

