/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import java.util.function.Supplier;
import mod.schnappdragon.habitat.common.block.BallCactusColor;
import mod.schnappdragon.habitat.common.block.HabitatFlowerBlock;
import mod.schnappdragon.habitat.core.tags.HabitatBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class BallCactusFlowerBlock
extends HabitatFlowerBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private final BallCactusColor color;

    public BallCactusFlowerBlock(BallCactusColor colorIn, Supplier<MobEffect> stewEffect, int stewEffectDuration, BlockBehaviour.Properties properties) {
        super(stewEffect, stewEffectDuration, properties);
        this.color = colorIn;
    }

    public BallCactusColor getColor() {
        return this.color;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.NONE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(HabitatBlockTags.BALL_CACTUS_FLOWER_PLACEABLE) || worldIn.m_8055_(pos.m_7495_()).m_204336_(HabitatBlockTags.BALL_CACTUS_GROWS_ON);
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (this.canGrow((Level)worldIn, pos) && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(10) == 0 ? 1 : 0) != 0)) {
            worldIn.m_46597_(pos, this.color.getGrowingBallCactus().m_49966_());
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrow((Level)worldIn, pos);
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return this.canGrow(worldIn, pos);
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.m_46597_(pos, (rand.nextBoolean() ? this.color.getGrowingBallCactus() : this.color.getBallCactus()).m_49966_());
    }

    public boolean canGrow(Level worldIn, BlockPos pos) {
        return !worldIn.m_8055_(pos.m_7495_()).m_204336_(HabitatBlockTags.BALL_CACTUS_FLOWER_PLACEABLE);
    }
}

