/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.schnappdragon.habitat.common.entity.monster.Pooka;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PookaModel<T extends Pooka>
extends EntityModel<T> {
    private final ModelPart leftRearFoot;
    private final ModelPart rightRearFoot;
    private final ModelPart leftHaunch;
    private final ModelPart rightHaunch;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart head;
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final ModelPart tail;
    private float jumpRotation;

    public PookaModel(ModelPart part) {
        this.leftRearFoot = part.m_171324_("left_hind_foot");
        this.rightRearFoot = part.m_171324_("right_hind_foot");
        this.leftHaunch = part.m_171324_("left_haunch");
        this.rightHaunch = part.m_171324_("right_haunch");
        this.body = part.m_171324_("body");
        this.leftFrontLeg = part.m_171324_("left_front_leg");
        this.rightFrontLeg = part.m_171324_("right_front_leg");
        this.head = part.m_171324_("head");
        this.rightEar = part.m_171324_("right_ear");
        this.leftEar = part.m_171324_("left_ear");
        this.tail = part.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("left_hind_foot", CubeListBuilder.m_171558_().m_171514_(26, 24).m_171481_(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), PartPose.m_171419_((float)3.0f, (float)17.5f, (float)3.7f));
        partdefinition.m_171599_("right_hind_foot", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171481_(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), PartPose.m_171419_((float)-3.0f, (float)17.5f, (float)3.7f));
        partdefinition.m_171599_("left_haunch", CubeListBuilder.m_171558_().m_171514_(30, 15).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), PartPose.m_171423_((float)3.0f, (float)17.5f, (float)3.7f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_haunch", CubeListBuilder.m_171558_().m_171514_(16, 15).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), PartPose.m_171423_((float)-3.0f, (float)17.5f, (float)3.7f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -2.0f, -10.0f, 6.0f, 5.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)8.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        body.m_171599_("big_mushroom_x", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171481_(0.0f, -7.0f, -3.0f, 3.0f, 5.0f, 0.0f), PartPose.f_171404_);
        body.m_171599_("big_mushroom_z", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(1.5f, -7.0f, -4.5f, 0.0f, 5.0f, 3.0f), PartPose.f_171404_);
        body.m_171599_("small_mushroom_x", CubeListBuilder.m_171558_().m_171514_(22, 27).m_171481_(-3.0f, -6.0f, -7.0f, 3.0f, 4.0f, 0.0f), PartPose.f_171404_);
        body.m_171599_("small_mushroom_z", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171481_(-1.5f, -6.0f, -8.5f, 0.0f, 4.0f, 3.0f), PartPose.f_171404_);
        partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(8, 15).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)17.0f, (float)-1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)17.0f, (float)-1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-2.5f, -4.0f, -5.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-1.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(32, 9).m_171481_(-0.5f, -2.5f, -5.5f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        PartDefinition rightEar = partdefinition.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -10.0f, -1.0f, 3.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f));
        rightEar.m_171599_("right_ear_stalk", CubeListBuilder.m_171558_().m_171514_(1, 6).m_171481_(-3.5f, -5.0f, -0.5f, 3.0f, 1.0f, 0.0f), PartPose.f_171404_);
        PartDefinition leftEar = partdefinition.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(0.5f, -10.0f, -1.0f, 3.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        leftEar.m_171599_("left_ear_stalk", CubeListBuilder.m_171558_().m_171514_(1, 6).m_171481_(0.5f, -5.0f, -0.5f, 3.0f, 1.0f, 0.0f), PartPose.f_171404_);
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171481_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)7.0f, (float)-0.3490659f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.56666666f, 0.56666666f, 0.56666666f);
            poseStack.m_85837_(0.0, 1.375, 0.125);
            ImmutableList.of((Object)this.head, (Object)this.leftEar, (Object)this.rightEar).forEach(part -> part.m_104306_(poseStack, consumer, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.4f, 0.4f, 0.4f);
            poseStack.m_85837_(0.0, 2.25, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail).forEach(part -> part.m_104306_(poseStack, consumer, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_85837_(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.head, (Object)this.rightEar, (Object)this.leftEar, (Object)this.tail).forEach(part -> part.m_104306_(poseStack, consumer, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            poseStack.m_85849_();
        }
    }

    public void setupAnim(Pooka pooka, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)pooka.f_19797_;
        this.rightEar.f_104203_ = this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leftEar.f_104203_ = this.head.f_104203_;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.rightEar.f_104204_ = this.head.f_104204_ - 0.2617994f;
        this.leftEar.f_104204_ = this.head.f_104204_ + 0.2617994f;
        this.jumpRotation = Mth.m_14031_((float)(pooka.m_29735_(f) * (float)Math.PI));
        this.rightHaunch.f_104203_ = this.leftHaunch.f_104203_ = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rightRearFoot.f_104203_ = this.leftRearFoot.f_104203_ = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rightFrontLeg.f_104203_ = this.leftFrontLeg.f_104203_ = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    public void prepareMobModel(Pooka pooka, float limbSwing, float limbSwingAmount, float partialTick) {
        this.jumpRotation = Mth.m_14031_((float)(pooka.m_29735_(partialTick) * (float)Math.PI));
    }
}

