/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public interface IUpgradeItem<T extends IUpgradeWrapper> {
    public UpgradeType<T> getType();

    default public UpgradeSlotChangeResult canAddUpgradeTo(IStorageWrapper storageWrapper, ItemStack upgradeStack, boolean firstLevelStorage, boolean isClientSide) {
        return this.checkUpgradePerStorageTypeLimit(storageWrapper);
    }

    private UpgradeSlotChangeResult checkUpgradePerStorageTypeLimit(IStorageWrapper storageWrapper) {
        int upgradesPerStorage = this.getUpgradesPerStorage(storageWrapper.getStorageType());
        int upgradesInGroupPerStorage = this.getUpgradesInGroupPerStorage(storageWrapper.getStorageType());
        if (upgradesPerStorage == Integer.MAX_VALUE && upgradesInGroupPerStorage == Integer.MAX_VALUE) {
            return new UpgradeSlotChangeResult.Success();
        }
        if (upgradesPerStorage == 0) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.upgrade_not_allowed", this.getName(), storageWrapper.getDisplayName()), Set.of(), Set.of(), Set.of());
        }
        if (upgradesInGroupPerStorage == 0) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.upgrade_not_allowed", new TranslatableComponent(this.getUpgradeGroup().translName()), storageWrapper.getDisplayName()), Set.of(), Set.of(), Set.of());
        }
        HashSet<Integer> slotsWithUpgrade = new HashSet<Integer>();
        InventoryHelper.iterate((IItemHandler)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            if (stack.m_41720_() == this) {
                slotsWithUpgrade.add((Integer)slot);
            }
        });
        if (slotsWithUpgrade.size() >= upgradesPerStorage) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.only_x_upgrades_allowed", upgradesPerStorage, this.getName(), storageWrapper.getDisplayName(), upgradesPerStorage), slotsWithUpgrade, Set.of(), Set.of());
        }
        HashSet<Integer> slotsWithUgradeGroup = new HashSet<Integer>();
        InventoryHelper.iterate((IItemHandler)storageWrapper.getUpgradeHandler(), (slot, stack) -> {
            IUpgradeItem upgradeItem;
            Item patt2424$temp = stack.m_41720_();
            if (patt2424$temp instanceof IUpgradeItem && (upgradeItem = (IUpgradeItem)patt2424$temp).getUpgradeGroup() == this.getUpgradeGroup()) {
                slotsWithUgradeGroup.add((Integer)slot);
            }
        });
        if (slotsWithUgradeGroup.size() >= upgradesInGroupPerStorage) {
            return new UpgradeSlotChangeResult.Fail(TranslationHelper.INSTANCE.translError("add.only_x_upgrades_allowed", upgradesInGroupPerStorage, new TranslatableComponent(this.getUpgradeGroup().translName()), storageWrapper.getDisplayName()), slotsWithUgradeGroup, Set.of(), Set.of());
        }
        return new UpgradeSlotChangeResult.Success();
    }

    default public UpgradeSlotChangeResult canRemoveUpgradeFrom(IStorageWrapper storageWrapper, boolean isClientSide) {
        return new UpgradeSlotChangeResult.Success();
    }

    default public UpgradeSlotChangeResult canSwapUpgradeFor(ItemStack upgradeStackToPut, IStorageWrapper storageWrapper, boolean isClientSide) {
        Item item = upgradeStackToPut.m_41720_();
        if (item instanceof IUpgradeItem) {
            UpgradeSlotChangeResult result;
            int upgradesInGroupPerStorage;
            IUpgradeItem upgradeToPut = (IUpgradeItem)item;
            int upgradesPerStorage = upgradeToPut.getUpgradesPerStorage(storageWrapper.getStorageType());
            if (upgradesPerStorage < (upgradesInGroupPerStorage = upgradeToPut.getUpgradesInGroupPerStorage(storageWrapper.getStorageType()))) {
                UpgradeSlotChangeResult result2;
                if (upgradeStackToPut.m_41720_() != this && !(result2 = upgradeToPut.checkUpgradePerStorageTypeLimit(storageWrapper)).isSuccessful()) {
                    return result2;
                }
            } else if (upgradeToPut.getUpgradeGroup() != this.getUpgradeGroup() && !(result = upgradeToPut.checkUpgradePerStorageTypeLimit(storageWrapper)).isSuccessful()) {
                return result;
            }
        }
        return this.canRemoveUpgradeFrom(storageWrapper, isClientSide);
    }

    default public int getInventoryColumnsTaken() {
        return 0;
    }

    default public ItemStack getCleanedUpgradeStack(ItemStack upgradeStack) {
        return upgradeStack;
    }

    public int getUpgradesPerStorage(String var1);

    public int getUpgradesInGroupPerStorage(String var1);

    default public UpgradeGroup getUpgradeGroup() {
        return UpgradeGroup.NONE;
    }

    public Component getName();
}

