/*
 * Decompiled with CFR 0.152.
 */
package com.github.justinwon777.humancompanions.entity;

import com.github.justinwon777.humancompanions.container.CompanionContainer;
import com.github.justinwon777.humancompanions.core.Config;
import com.github.justinwon777.humancompanions.core.EntityInit;
import com.github.justinwon777.humancompanions.core.PacketHandler;
import com.github.justinwon777.humancompanions.entity.CompanionData;
import com.github.justinwon777.humancompanions.entity.ai.AvoidCreeperGoal;
import com.github.justinwon777.humancompanions.entity.ai.CustomFollowOwnerGoal;
import com.github.justinwon777.humancompanions.entity.ai.CustomOwnerHurtByTargetGoal;
import com.github.justinwon777.humancompanions.entity.ai.CustomOwnerHurtTargetGoal;
import com.github.justinwon777.humancompanions.entity.ai.CustomWaterAvoidingRandomStrollGoal;
import com.github.justinwon777.humancompanions.entity.ai.EatGoal;
import com.github.justinwon777.humancompanions.entity.ai.LowHealthGoal;
import com.github.justinwon777.humancompanions.entity.ai.MoveBackToGuardGoal;
import com.github.justinwon777.humancompanions.entity.ai.MoveBackToPatrolGoal;
import com.github.justinwon777.humancompanions.entity.ai.PatrolGoal;
import com.github.justinwon777.humancompanions.networking.OpenInventoryPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public class AbstractHumanCompanionEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEX = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BASE_HEALTH = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXP_LVL = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALERT = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HUNTING = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FOLLOWING = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GUARDING = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STATIONERY = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> PATROL_POS = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> PATROL_RADIUS = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> FOOD1 = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> FOOD2 = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> FOOD1_AMT = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FOOD2_AMT = SynchedEntityData.m_135353_(AbstractHumanCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public SimpleContainer inventory = new SimpleContainer(27);
    public EquipmentSlot[] armorTypes = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};
    public List<NearestAttackableTargetGoal> alertMobGoals = new ArrayList<NearestAttackableTargetGoal>();
    public List<NearestAttackableTargetGoal> huntMobGoals = new ArrayList<NearestAttackableTargetGoal>();
    public PatrolGoal patrolGoal;
    public MoveBackToPatrolGoal moveBackGoal;
    public int experienceLevel;
    public int totalExperience;
    public float experienceProgress;
    private int lastLevelUpTime;
    private final Map<String, Integer> foodRequirements = new HashMap<String, Integer>();
    private String food1;
    private String food2;

    public AbstractHumanCompanionEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        int i;
        this.m_7105_(false);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        for (i = 0; i < CompanionData.alertMobs.length; ++i) {
            this.alertMobGoals.add(new NearestAttackableTargetGoal((Mob)this, CompanionData.alertMobs[i], false));
        }
        for (i = 0; i < CompanionData.huntMobs.length; ++i) {
            this.huntMobGoals.add(new NearestAttackableTargetGoal((Mob)this, CompanionData.huntMobs[i], false));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new EatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, new AvoidCreeperGoal<Creeper>(this, Creeper.class, 10.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new MoveBackToGuardGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CustomFollowOwnerGoal(this, 1.3, 8.0f, 2.5f, false));
        this.f_21345_.m_25352_(5, (Goal)new CustomWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(9, (Goal)new LowHealthGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new CustomOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new CustomOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.32);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)1);
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(ALERT, (Object)false);
        this.f_19804_.m_135372_(HUNTING, (Object)false);
        this.f_19804_.m_135372_(PATROLLING, (Object)false);
        this.f_19804_.m_135372_(FOLLOWING, (Object)false);
        this.f_19804_.m_135372_(GUARDING, (Object)false);
        this.f_19804_.m_135372_(STATIONERY, (Object)false);
        this.f_19804_.m_135372_(PATROL_POS, Optional.empty());
        this.f_19804_.m_135372_(PATROL_RADIUS, (Object)10);
        this.f_19804_.m_135372_(SEX, (Object)0);
        this.f_19804_.m_135372_(BASE_HEALTH, (Object)((Integer)Config.BASE_HEALTH.get()));
        this.f_19804_.m_135372_(EXP_LVL, (Object)0);
        this.f_19804_.m_135372_(FOOD1, (Object)"");
        this.f_19804_.m_135372_(FOOD2, (Object)"");
        this.f_19804_.m_135372_(FOOD1_AMT, (Object)0);
        this.f_19804_.m_135372_(FOOD2_AMT, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int baseHealth = (Integer)Config.BASE_HEALTH.get() + CompanionData.getHealthModifier();
        this.modifyMaxHealth(baseHealth - 20, "companion base health", true);
        this.m_21153_(this.m_21233_());
        this.setBaseHealth(baseHealth);
        this.setSex(this.f_19796_.nextInt(2));
        this.setCompanionSkin(this.f_19796_.nextInt(CompanionData.skins[this.getSex()].length));
        this.m_6593_((Component)new TextComponent(CompanionData.getRandomName(this.getSex())));
        this.setPatrolPos(this.m_142538_());
        this.setPatrolling(true);
        this.setPatrolRadius(15);
        this.patrolGoal = new PatrolGoal(this, 60, this.getPatrolRadius());
        this.moveBackGoal = new MoveBackToPatrolGoal(this, this.getPatrolRadius());
        this.f_21345_.m_25352_(3, (Goal)this.moveBackGoal);
        this.f_21345_.m_25352_(3, (Goal)this.patrolGoal);
        this.setFoodRequirements();
        if (((Boolean)Config.SPAWN_ARMOR.get()).booleanValue()) {
            for (int i = 0; i < 4; ++i) {
                EquipmentSlot armorType = this.armorTypes[i];
                ItemStack itemstack = CompanionData.getSpawnArmor(armorType);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(i, itemstack);
            }
            this.checkArmor();
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.m_7927_());
        tag.m_128405_("skin", this.getCompanionSkin());
        tag.m_128379_("Eating", this.isEating());
        tag.m_128379_("Alert", this.isAlert());
        tag.m_128379_("Hunting", this.isHunting());
        tag.m_128379_("Patrolling", this.isPatrolling());
        tag.m_128379_("Following", this.isFollowing());
        tag.m_128379_("Guarding", this.isGuarding());
        tag.m_128379_("Stationery", this.isStationery());
        tag.m_128405_("radius", this.getPatrolRadius());
        tag.m_128405_("sex", this.getSex());
        tag.m_128405_("baseHealth", this.getBaseHealth());
        tag.m_128350_("XpP", this.experienceProgress);
        tag.m_128405_("XpLevel", this.experienceLevel);
        tag.m_128405_("XpTotal", this.totalExperience);
        tag.m_128359_("food1", this.food1);
        tag.m_128359_("food2", this.food2);
        tag.m_128405_("food1_amt", this.foodRequirements.get(this.food1).intValue());
        tag.m_128405_("food2_amt", this.foodRequirements.get(this.food2).intValue());
        if (this.getPatrolPos() != null) {
            int[] patrolPos = new int[]{this.getPatrolPos().m_123341_(), this.getPatrolPos().m_123342_(), this.getPatrolPos().m_123343_()};
            tag.m_128385_("patrol_pos", patrolPos);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCompanionSkin(tag.m_128451_("skin"));
        this.setEating(tag.m_128471_("Eating"));
        this.setAlert(tag.m_128471_("Alert"));
        this.setHunting(tag.m_128471_("Hunting"));
        this.setPatrolling(tag.m_128471_("Patrolling"));
        this.setFollowing(tag.m_128471_("Following"));
        this.setGuarding(tag.m_128471_("Guarding"));
        this.setStationery(tag.m_128471_("Stationery"));
        this.setPatrolRadius(tag.m_128451_("radius"));
        this.setSex(tag.m_128451_("sex"));
        this.experienceProgress = tag.m_128457_("XpP");
        this.experienceLevel = tag.m_128451_("XpLevel");
        this.setExpLvl(tag.m_128451_("XpLevel"));
        this.totalExperience = tag.m_128451_("XpTotal");
        this.food1 = tag.m_128461_("food1");
        this.food2 = tag.m_128461_("food2");
        this.foodRequirements.put(this.food1, tag.m_128451_("food1_amt"));
        this.foodRequirements.put(this.food2, tag.m_128451_("food2_amt"));
        if (tag.m_128451_("baseHealth") == 0) {
            this.setBaseHealth((Integer)Config.BASE_HEALTH.get());
        } else {
            this.setBaseHealth(tag.m_128451_("baseHealth"));
        }
        if (tag.m_128471_("Alert")) {
            this.addAlertGoals();
        }
        if (tag.m_128471_("Hunting")) {
            this.addHuntingGoals();
        }
        if (tag.m_128425_("inventory", 9)) {
            this.inventory.m_7797_(tag.m_128437_("inventory", 10));
        }
        if (tag.m_128441_("patrol_pos")) {
            int[] positions = tag.m_128465_("patrol_pos");
            this.setPatrolPos(new BlockPos(positions[0], positions[1], positions[2]));
        }
        if (tag.m_128441_("radius")) {
            this.patrolGoal = new PatrolGoal(this, 60, tag.m_128451_("radius"));
            this.moveBackGoal = new MoveBackToPatrolGoal(this, tag.m_128451_("radius"));
            this.f_21345_.m_25352_(3, (Goal)this.moveBackGoal);
            this.f_21345_.m_25352_(3, (Goal)this.patrolGoal);
        }
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.checkArmor();
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)((EntityType)EntityInit.Knight.get()).m_20615_((Level)level);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!this.m_21824_() && !this.f_19853_.m_5776_()) {
                if (itemstack.m_41614_()) {
                    String itemFood = itemstack.m_41720_().m_41466_().getString();
                    if (ArrayUtils.contains((Object[])this.foodRequirements.keySet().toArray(new String[0]), (Object)itemFood)) {
                        if (this.foodRequirements.get(itemFood) > 0) {
                            itemstack.m_41774_(1);
                            this.foodRequirements.put(itemFood, this.foodRequirements.get(itemFood) - 1);
                            if (this.foodRequirements.get(this.food1) <= 0 && this.foodRequirements.get(this.food2) <= 0) {
                                this.m_21828_(player);
                                player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), new TextComponent("Thanks!")}), this.m_142081_());
                                player.m_6352_((Component)new TextComponent("Companion added"), this.m_142081_());
                                this.setPatrolPos(null);
                                this.setPatrolling(false);
                                this.setFollowing(true);
                                this.setPatrolRadius(4);
                                this.patrolGoal.radius = 4;
                                this.moveBackGoal.radius = 4;
                            } else if (this.foodRequirements.get(itemFood) == 0) {
                                player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.ENOUGH_FOOD[this.f_19796_.nextInt(CompanionData.ENOUGH_FOOD.length)]}), this.m_142081_());
                            } else {
                                player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.tameFail[this.f_19796_.nextInt(CompanionData.tameFail.length)]}), this.m_142081_());
                            }
                        } else {
                            player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.ENOUGH_FOOD[this.f_19796_.nextInt(CompanionData.ENOUGH_FOOD.length)]}), this.m_142081_());
                        }
                    } else {
                        player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.WRONG_FOOD[this.f_19796_.nextInt(CompanionData.WRONG_FOOD.length)]}), this.m_142081_());
                    }
                } else {
                    String task = this.m_5446_().getString().split(" ")[0] + " wants: " + this.foodRequirements.get(this.food1) + " " + this.food1 + ", " + this.foodRequirements.get(this.food2) + " " + this.food2;
                    player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), CompanionData.notTamed[this.f_19796_.nextInt(CompanionData.notTamed.length)]}), this.m_142081_());
                    player.m_6352_((Component)new TextComponent(task), this.m_142081_());
                }
            } else {
                if (this.m_7307_((Entity)player)) {
                    if (player.m_6144_()) {
                        if (!this.f_19853_.m_5776_()) {
                            if (!this.m_21827_()) {
                                this.m_21839_(true);
                                TextComponent text = new TextComponent("I'll stand here.");
                                player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), text}), this.m_142081_());
                            } else {
                                this.m_21839_(false);
                                TextComponent text = new TextComponent("I'll move around.");
                                player.m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), text}), this.m_142081_());
                            }
                        }
                    } else if (!this.f_19853_.m_5776_()) {
                        this.openGui((ServerPlayer)player);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void openGui(ServerPlayer player) {
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        player.m_9217_();
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenInventoryPacket(player.f_8940_, this.inventory.m_6643_(), this.m_142049_()));
        player.f_36096_ = new CompanionContainer(player.f_8940_, player.m_150109_(), (Container)this.inventory);
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    public void checkArmor() {
        ItemStack head = this.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = this.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = this.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = this.m_6844_(EquipmentSlot.FEET);
        block6: for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (!(itemstack.m_41720_() instanceof ArmorItem)) continue;
            switch (((ArmorItem)itemstack.m_41720_()).m_40402_()) {
                case HEAD: {
                    if (head.m_41619_()) {
                        this.m_8061_(EquipmentSlot.HEAD, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)head.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.HEAD, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)head.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.HEAD, itemstack);
                    continue block6;
                }
                case CHEST: {
                    if (chest.m_41619_()) {
                        this.m_8061_(EquipmentSlot.CHEST, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)chest.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.CHEST, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)chest.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.CHEST, itemstack);
                    continue block6;
                }
                case LEGS: {
                    if (legs.m_41619_()) {
                        this.m_8061_(EquipmentSlot.LEGS, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)legs.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.LEGS, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)legs.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.LEGS, itemstack);
                    continue block6;
                }
                case FEET: {
                    if (feet.m_41619_()) {
                        this.m_8061_(EquipmentSlot.FEET, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40404_() > ((ArmorItem)feet.m_41720_()).m_40404_()) {
                        this.m_8061_(EquipmentSlot.FEET, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.m_41720_()).m_40401_() != ArmorMaterials.NETHERITE || ((ArmorItem)feet.m_41720_()).m_40401_() == ArmorMaterials.NETHERITE) continue block6;
                    this.m_8061_(EquipmentSlot.FEET, itemstack);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource p_34288_, float p_34289_) {
        if (p_34288_.m_7639_() == this.m_142480_() && !((Boolean)Config.FRIENDLY_FIRE_PLAYER.get()).booleanValue()) {
            return false;
        }
        if (p_34288_ == DamageSource.f_19315_ && !((Boolean)Config.FALL_DAMAGE.get()).booleanValue()) {
            return false;
        }
        this.m_6472_(p_34288_, p_34289_);
        return super.m_6469_(p_34288_, p_34289_);
    }

    public void m_6472_(DamageSource p_150073_, float p_150074_) {
        if (!(p_150074_ <= 0.0f)) {
            if ((p_150074_ /= 4.0f) < 1.0f) {
                p_150074_ = 1.0f;
            }
            for (ItemStack itemstack : this.m_6168_()) {
                if (p_150073_.m_19384_() && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
                itemstack.m_41622_((int)p_150074_, (LivingEntity)this, p_35997_ -> p_35997_.m_21166_(((ArmorItem)itemstack.m_41720_()).m_40402_()));
            }
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    protected void m_5907_() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public boolean m_7327_(Entity entity) {
        ItemStack itemstack = this.m_21205_();
        if (!this.f_19853_.f_46443_ && !itemstack.m_41619_() && entity instanceof LivingEntity) {
            itemstack.m_41622_(1, (LivingEntity)this, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
            if (this.m_21205_().m_41619_()) {
                TextComponent broken = new TextComponent("My sword broke!");
                if (this.m_21824_()) {
                    this.m_142480_().m_6352_((Component)new TranslatableComponent("chat.type.text", new Object[]{this.m_5446_(), broken}), this.m_142081_());
                }
            }
        }
        return super.m_7327_(entity);
    }

    public ItemStack m_5584_(Level world, ItemStack stack) {
        if (stack.m_41614_()) {
            this.m_5634_(stack.m_41720_().m_41473_().m_38744_());
        }
        super.m_5584_(world, stack);
        return stack;
    }

    public ItemStack checkFood() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (!itemstack.m_41614_() || !((float)itemstack.m_41720_().m_41473_().m_38744_() + this.m_21223_() <= this.m_21233_())) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void clearTarget() {
        this.m_6710_(null);
    }

    public void giveExperiencePoints(int pXpPoints) {
        this.experienceProgress += (float)pXpPoints / (float)this.getXpNeededForNextLevel();
        this.totalExperience = Mth.m_14045_((int)(this.totalExperience + pXpPoints), (int)0, (int)Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float f = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public void giveExperienceLevels(int pLevels) {
        this.experienceLevel += pLevels;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.setExpLvl(this.experienceLevel);
        if (pLevels > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.f_19797_ - 100.0f) {
            this.lastLevelUpTime = this.f_19797_;
        }
    }

    public int getXpNeededForNextLevel() {
        if (this.experienceLevel >= 30) {
            return 112 + (this.experienceLevel - 30) * 9;
        }
        return this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2;
    }

    public int m_6552_(Player player) {
        if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46133_) && !this.m_5833_()) {
            int i = this.experienceLevel * 7;
            return Math.min(i, 100);
        }
        return 0;
    }

    public void modifyMaxHealth(int change, String name, boolean permanent) {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22276_);
        Set modifiers = attributeinstance.m_22122_();
        if (!modifiers.isEmpty()) {
            for (AttributeModifier attributeModifier : modifiers) {
                if (attributeModifier == null || !attributeModifier.m_22214_().equals(name)) continue;
                this.m_21051_(Attributes.f_22276_).m_22130_(attributeModifier);
            }
        }
        AttributeModifier HEALTH_MODIFIER = new AttributeModifier(name, (double)change, AttributeModifier.Operation.ADDITION);
        if (permanent) {
            attributeinstance.m_22125_(HEALTH_MODIFIER);
        } else {
            attributeinstance.m_22118_(HEALTH_MODIFIER);
        }
    }

    public void checkStats() {
        if ((int)this.m_21233_() != this.getBaseHealth() + this.getExpLvl() / 3 && this.getExpLvl() / 3 != 0) {
            this.modifyMaxHealth(this.getExpLvl() / 3, "companion level health", false);
        }
    }

    public void m_8119_() {
        if (!this.f_19853_.m_5776_()) {
            this.checkArmor();
            if (this.f_19797_ % 10 == 0) {
                this.checkStats();
            }
        }
        super.m_8119_();
    }

    public void setFoodRequirements() {
        this.foodRequirements.clear();
        Item[] allFoods = CompanionData.ALL_FOODS;
        this.food1 = allFoods[this.f_19796_.nextInt(allFoods.length)].m_41466_().getString();
        this.food2 = allFoods[this.f_19796_.nextInt(allFoods.length)].m_41466_().getString();
        while (this.food1.equals(this.food2)) {
            this.food2 = allFoods[this.f_19796_.nextInt(allFoods.length)].m_41466_().getString();
        }
        this.foodRequirements.put(this.food1, this.f_19796_.nextInt(5) + 1);
        this.foodRequirements.put(this.food2, this.f_19796_.nextInt(5) + 1);
    }

    public void release() {
        this.m_7105_(false);
        this.m_21816_(null);
        this.setFollowing(false);
        this.setAlert(false);
        this.removeAlertGoals();
        this.setHunting(false);
        this.removeHuntingGoals();
        this.setPatrolPos(this.m_142538_());
        this.setPatrolling(true);
        this.setStationery(false);
        this.setPatrolRadius(15);
        this.setFoodRequirements();
        if (this.m_21827_()) {
            this.m_21839_(false);
        }
    }

    public void setExpLvl(int lvl) {
        this.f_19804_.m_135381_(EXP_LVL, (Object)lvl);
    }

    public int getExpLvl() {
        return (Integer)this.f_19804_.m_135370_(EXP_LVL);
    }

    public void setPatrolPos(BlockPos position) {
        this.f_19804_.m_135381_(PATROL_POS, Optional.ofNullable(position));
    }

    @Nullable
    public BlockPos getPatrolPos() {
        return ((Optional)this.f_19804_.m_135370_(PATROL_POS)).orElse(null);
    }

    public void setPatrolRadius(int radius) {
        this.f_19804_.m_135381_(PATROL_RADIUS, (Object)radius);
    }

    public int getPatrolRadius() {
        return (Integer)this.f_19804_.m_135370_(PATROL_RADIUS);
    }

    public ResourceLocation getResourceLocation() {
        return CompanionData.skins[this.getSex()][this.getCompanionSkin()];
    }

    public int getCompanionSkin() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setCompanionSkin(int skinIndex) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)skinIndex);
    }

    public void setSex(int sex) {
        this.f_19804_.m_135381_(SEX, (Object)sex);
    }

    public int getSex() {
        return (Integer)this.f_19804_.m_135370_(SEX);
    }

    public void setBaseHealth(int health) {
        this.f_19804_.m_135381_(BASE_HEALTH, (Object)health);
    }

    public int getBaseHealth() {
        return (Integer)this.f_19804_.m_135370_(BASE_HEALTH);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public boolean isAlert() {
        return (Boolean)this.f_19804_.m_135370_(ALERT);
    }

    public boolean isHunting() {
        return (Boolean)this.f_19804_.m_135370_(HUNTING);
    }

    public boolean isPatrolling() {
        return (Boolean)this.f_19804_.m_135370_(PATROLLING);
    }

    public boolean isGuarding() {
        return (Boolean)this.f_19804_.m_135370_(GUARDING);
    }

    public boolean isStationery() {
        return (Boolean)this.f_19804_.m_135370_(STATIONERY);
    }

    public boolean isFollowing() {
        return (Boolean)this.f_19804_.m_135370_(FOLLOWING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public void setAlert(boolean alert) {
        this.f_19804_.m_135381_(ALERT, (Object)alert);
    }

    public void setHunting(boolean hunting) {
        this.f_19804_.m_135381_(HUNTING, (Object)hunting);
    }

    public void setPatrolling(boolean patrolling) {
        this.f_19804_.m_135381_(PATROLLING, (Object)patrolling);
    }

    public void setGuarding(boolean guarding) {
        this.f_19804_.m_135381_(GUARDING, (Object)guarding);
    }

    public void setStationery(boolean stationery) {
        this.f_19804_.m_135381_(STATIONERY, (Object)stationery);
    }

    public void setFollowing(boolean following) {
        this.f_19804_.m_135381_(FOLLOWING, (Object)following);
    }

    public void addAlertGoals() {
        for (NearestAttackableTargetGoal alertMobGoal : this.alertMobGoals) {
            this.f_21346_.m_25352_(4, (Goal)alertMobGoal);
        }
    }

    public void removeAlertGoals() {
        for (NearestAttackableTargetGoal alertMobGoal : this.alertMobGoals) {
            this.f_21346_.m_25363_((Goal)alertMobGoal);
        }
    }

    public void addHuntingGoals() {
        for (NearestAttackableTargetGoal huntMobGoal : this.huntMobGoals) {
            this.f_21346_.m_25352_(4, (Goal)huntMobGoal);
        }
    }

    public void removeHuntingGoals() {
        for (NearestAttackableTargetGoal huntMobGoal : this.huntMobGoals) {
            this.f_21346_.m_25363_((Goal)huntMobGoal);
        }
    }
}

