/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;

public class DungeonStairs
extends DungeonPiece {
    public int stairType;

    public DungeonStairs() {
        super(StructurePieceTypes.STAIRS);
        this.stairType = 0;
    }

    public DungeonStairs(CompoundTag p_i51343_2_) {
        super(StructurePieceTypes.STAIRS, p_i51343_2_);
        this.stairType = p_i51343_2_.m_128451_("stairType");
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
        switch (this.stairType) {
            case 0: {
                this.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.BOTTOM_STAIRS);
                break;
            }
            case 1: {
                this.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.TOP_STAIRS);
            }
        }
    }

    public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return;
        }
        BlockPos pos = new BlockPos(this.x, this.y, this.z).m_141952_(this.model.getOffset(this.f_73379_));
        switch (this.stairType) {
            case 0: {
                this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, randomIn, PlacementConfiguration.BOTTOM_STAIRCASE, this.theme, this.secondaryTheme, this.stage, Rotation.NONE, false, false);
                this.ironBars((LevelAccessor)worldIn, structureBoundingBoxIn, this.model, randomIn);
                this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
                this.decorate((LevelAccessor)worldIn, pos, this.theme, randomIn, structureBoundingBoxIn, this.f_73383_, this.model);
                break;
            }
            case 1: {
                this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, randomIn, PlacementConfiguration.DEFAULT, this.theme, this.secondaryTheme, this.stage, Rotation.NONE, false, false);
                this.entrances((LevelAccessor)worldIn, structureBoundingBoxIn, this.model, randomIn);
                this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
                this.decorate((LevelAccessor)worldIn, pos, this.theme, randomIn, structureBoundingBoxIn, this.f_73383_, this.model);
            }
        }
    }

    public void ironBars(LevelAccessor world, BoundingBox bounds, DungeonModel model, Random random) {
        int z0;
        int y0;
        int x0;
        int pathStartX = (model.width - 3) / 2;
        int pathStartZ = (model.length - 3) / 2;
        if (this.sides[0]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(world, new BlockPos(this.x + x0, this.y + y0, this.z), random), this.x + x0, this.y + y0, this.z, bounds, true);
                }
            }
        }
        if (this.sides[1]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(world, new BlockPos(this.x + model.width, this.y + y0, this.z + z0), random), this.x + model.width - 1, this.y + y0, this.z + z0, bounds, true);
                }
            }
        }
        if (this.sides[2]) {
            for (x0 = pathStartX; x0 < pathStartX + 3; ++x0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(world, new BlockPos(this.x + x0, this.y + y0, this.z + model.length), random), this.x + x0, this.y + y0, this.z + model.length - 1, bounds, true);
                }
            }
        }
        if (this.sides[3]) {
            for (z0 = pathStartZ; z0 < pathStartZ + 3; ++z0) {
                for (y0 = 1; y0 < 4; ++y0) {
                    this.replaceBlockState(world, this.theme.fencing.get(world, new BlockPos(this.x, this.y + y0, this.z + z0), random), this.x, this.y + y0, this.z + z0, bounds, true);
                }
            }
        }
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            this.f_73383_ = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.f_73379_);
        }
    }

    @Override
    public boolean canConnect(Direction side, int x, int z) {
        return true;
    }

    public DungeonStairs bottom() {
        this.stairType = 0;
        return this;
    }

    public DungeonStairs top() {
        this.stairType = 1;
        return this;
    }

    @Override
    public void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
        super.m_183620_(context, tagCompound);
        tagCompound.m_128405_("stairType", this.stairType);
    }

    @Override
    public int getDungeonPieceType() {
        return 1;
    }
}

