/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Furnace
implements IBlockPlacementHandler {
    private static final Item[] FOOD = new Item[]{Items.f_42580_, Items.f_42582_, Items.f_42659_, Items.f_42530_, Items.f_42486_, Items.f_42698_, Items.f_42531_, Items.f_42674_};

    @Override
    public void place(LevelAccessor world, BlockState state, BlockPos pos, Random rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
        world.m_7731_(pos, state, 2);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof FurnaceBlockEntity) {
            FurnaceBlockEntity furnace = (FurnaceBlockEntity)tile;
            furnace.m_6836_(1, new ItemStack((ItemLike)Items.f_42413_, Furnace.coalAmount(rand)));
        } else {
            DungeonCrawl.LOGGER.warn("Failed to fetch a furnace entity at {}", (Object)pos.toString());
        }
    }

    private static int coalAmount(Random rand) {
        return Mth.m_14072_((Random)rand, (int)2, (int)8);
    }

    public static class Smoker
    implements IBlockPlacementHandler {
        @Override
        public void place(LevelAccessor world, BlockState state, BlockPos pos, Random rand, Theme theme, SecondaryTheme secondaryTheme, int lootLevel) {
            world.m_7731_(pos, state, 2);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof SmokerBlockEntity) {
                SmokerBlockEntity smoker = (SmokerBlockEntity)tile;
                smoker.m_6836_(1, new ItemStack((ItemLike)Items.f_42414_, Furnace.coalAmount(rand)));
                smoker.m_6836_(2, new ItemStack((ItemLike)FOOD[rand.nextInt(FOOD.length)], 1 + rand.nextInt(16)));
            } else {
                DungeonCrawl.LOGGER.warn("Failed to fetch a smoker entity at {}", (Object)pos.toString());
            }
        }
    }
}

