/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends StructureFeature<NoneFeatureConfiguration> {
    private static final int BIOME_CHECK_RADIUS = 1;

    public Dungeon() {
        super(NoneFeatureConfiguration.f_67815_, Dungeon::pieceGeneratorSupplier);
    }

    private static Optional<PieceGenerator<NoneFeatureConfiguration>> pieceGeneratorSupplier(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        int centerX = context.f_197355_().m_151382_(7);
        int centerZ = context.f_197355_().m_151391_(7);
        int centerHeight = context.f_197352_().m_156179_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        if (Dungeon.isInvalidSpot(context, 1)) {
            return Optional.empty();
        }
        int minGroundHeight = Dungeon.minHeight(context, centerX, centerZ, centerHeight);
        if (minGroundHeight < 45) {
            return Optional.empty();
        }
        int startHeight = (Boolean)Config.FIXED_GENERATION_HEIGHT.get() != false ? context.f_197352_().m_142051_(context.f_197357_()) - 20 : (minGroundHeight > 80 ? 80 + (minGroundHeight - 80) / 3 : minGroundHeight) - 20;
        return Optional.of((structurePiecesBuilder, generatorContext) -> {
            DungeonBuilder builder = new DungeonBuilder(context.f_197360_(), generatorContext.f_192703_(), startHeight, new BlockPos(centerX, centerHeight, centerZ), generatorContext.f_192705_(), (Random)generatorContext.f_192708_());
            builder.build().forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }

    private static boolean isInvalidSpot(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkPos pos = new ChunkPos(context.f_197355_().f_45578_ + x, context.f_197355_().f_45579_ + z);
                int centerX = QuartPos.m_175400_((int)pos.m_151382_(7));
                int centerZ = QuartPos.m_175400_((int)pos.m_151391_(7));
                Holder centerBiome = context.f_197352_().m_203495_(centerX, context.f_197352_().m_156179_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()), centerZ);
                if (context.f_197358_().test(centerBiome)) continue;
                DungeonCrawl.LOGGER.debug("Invalid biome {} at [{},{}]", (Object)((Biome)centerBiome.m_203334_()).getRegistryName(), (Object)pos.f_45578_, (Object)pos.f_45579_);
                return true;
            }
        }
        return false;
    }

    private static int minHeight(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, int centerX, int centerZ, int centerHeight) {
        int minHeight = centerHeight;
        for (int i = 1; i < 9; ++i) {
            int size = i * 5;
            minHeight = Math.min(minHeight, Dungeon.lowestCornerHeight(context, centerX - size, size << 1, centerZ - size, size << 1));
        }
        return minHeight;
    }

    private static int lowestCornerHeight(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, int x, int sizeX, int z, int sizeZ) {
        int height = context.f_197352_().m_156174_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.f_197357_());
        height = Math.min(height, context.f_197352_().m_156174_(x + sizeX, z, Heightmap.Types.OCEAN_FLOOR_WG, context.f_197357_()));
        height = Math.min(height, context.f_197352_().m_156174_(x, z + sizeZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_197357_()));
        height = Math.min(height, context.f_197352_().m_156174_(x + sizeX, z + sizeZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_197357_()));
        return height;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

