/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.IntValue SPAWNER_ENTITIES;
    public static final ForgeConfigSpec.IntValue SPAWNER_RANGE;
    public static final ForgeConfigSpec.BooleanValue CUSTOM_SPAWNERS;
    public static final ForgeConfigSpec.BooleanValue NO_NETHER_STUFF;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TOOLS;
    public static final ForgeConfigSpec.BooleanValue SOLID;
    public static final ForgeConfigSpec.BooleanValue NATURAL_DESPAWN;
    public static final ForgeConfigSpec.BooleanValue EXTENDED_DEBUG;
    public static final ForgeConfigSpec.BooleanValue TICK_FALLING_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue OVERWRITE_ENTITY_LOOT_TABLES;
    public static final ForgeConfigSpec.BooleanValue SECRET_ROOMS;
    public static final ForgeConfigSpec.BooleanValue FIXED_GENERATION_HEIGHT;
    private static final String SEPARATOR_LINE = "----------------------------------------------------------------------------------------------------+\n";

    public static void load(Path path) {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        CONFIG.setConfig((CommentedConfig)config);
    }

    private static <T> String commaSeparated(Iterator<T> elements, Function<T, String> toString) {
        StringBuilder builder = new StringBuilder();
        while (elements.hasNext()) {
            builder.append(toString.apply(elements.next()));
            if (!elements.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    static {
        BUILDER.push("Miscellaneous Settings");
        ENABLE_TOOLS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Enables the dungeon crawl developer tools. Do not use this for normal gameplay.\n").define("enable_tools", false);
        EXTENDED_DEBUG = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Enables extended debug logging to help detecting errors. Enabled by default.\n").define("extended_debug", true);
        BUILDER.pop();
        BUILDER.push("World Generation");
        SOLID = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Makes the entire dungeon solid, preventing caves, ravines, etc... from interfering with the dungeon.\n").define("solid", false);
        TICK_FALLING_BLOCKS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether falling blocks like sand or gravel should drop down after being placed during dungeon generation.\n").define("tick_falling_blocks", true);
        BUILDER.pop();
        BUILDER.push("Dungeon Settings");
        SECRET_ROOMS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether the dungeons should have secret rooms or not.\n").define("secret_rooms", true);
        FIXED_GENERATION_HEIGHT = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n\nWhether the dungeons should generate at a fixed height or not. Enable this if the dungeons are generating too high.").define("fixed_generation_height", false);
        OVERWRITE_ENTITY_LOOT_TABLES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether loot tables of certain spawner entities should be overwritten.\n For example, wither skeletons from dungeon spawners will never drop skulls if this is enabled.\n").define("overwrite_entity_loot_tables", true);
        NO_NETHER_STUFF = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether the hell stage should be built with blocks from the overworld instead from the nether.\n").define("no_nether_blocks", false);
        SPAWNER_RANGE = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The activation range for the spawners in the dungeons.\n").defineInRange("spawner_activation_range", 12, 1, 64);
        SPAWNER_ENTITIES = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n The number of different entities per spawner. Increasing the number increases the diversity of the monster equipment.\n").defineInRange("spawner_entities", 6, 1, 128);
        CUSTOM_SPAWNERS = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether custom mob spawners with equipment, etc.. should be used.\n").define("custom_spawners", true);
        NATURAL_DESPAWN = BUILDER.comment("----------------------------------------------------------------------------------------------------+\n Whether mobs from spawners should despawn naturally or not.\n").define("natural_despawn", true);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

