/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldCaptain;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldPirate;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldZombie
extends Zombie {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING = SynchedEntityData.m_135353_(KoboldZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int convert;

    public KoboldZombie(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KoboldZombie>)((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get()), world);
    }

    public KoboldZombie(EntityType<KoboldZombie> type, Level world) {
        super(type, world);
        this.m_20299_(0.5f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING, (Object)false);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Convert", this.convert);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Convert")) {
            int saved;
            this.convert = saved = tag.m_128451_("Convert");
        }
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.225;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.66f : 1.26f;
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean isConvert() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING);
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12615_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_12646_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12645_;
    }

    public void m_6075_() {
        super.m_6075_();
        Level world = this.f_19853_;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (!world.m_5776_() && this.m_6084_() && !this.m_21525_()) {
            if (this.convert > 1) {
                --this.convert;
                if (!this.isConvert()) {
                    this.m_20088_().m_135381_(DATA_CONVERTING, (Object)true);
                }
            } else if (this.convert == 1 && this.m_6084_()) {
                this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
                ItemStack weapon = this.m_21205_();
                ItemStack off = this.m_21206_();
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    if (world.m_204166_(new BlockPos(x, y, z)).m_203656_(BiomeTags.f_207610_)) {
                        if (weapon.m_41720_() instanceof SwordItem && weapon.m_41793_()) {
                            KoboldCaptain capty = (KoboldCaptain)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_CAPTAIN.get(), true);
                            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)capty);
                        } else {
                            KoboldPirate pirate = (KoboldPirate)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_PIRATE.get(), true);
                            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)pirate);
                        }
                    } else if (world.m_204166_(new BlockPos(x, y, z)).m_203656_(BiomeTags.f_207606_) && weapon.m_41720_() == Items.f_42717_ && off.m_41619_()) {
                        KoboldEngineer engi = (KoboldEngineer)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_ENGINEER.get(), true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)engi);
                    } else if (off.m_41720_() instanceof ShieldItem) {
                        KoboldWarrior war = (KoboldWarrior)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)war);
                    } else {
                        Kobold basic = (Kobold)this.m_21406_((EntityType)KoboldsMobs.KOBOLD.get(), true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)basic);
                    }
                }
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        super.m_6071_(player, hand);
        ItemStack apple = player.m_21120_(hand);
        Level world = this.f_19853_;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        int waitTicks = 0;
        int potionLevel = 0;
        if (!world.m_5776_() && apple.m_41720_() == Items.f_42436_ && this.m_21023_(MobEffects.f_19613_)) {
            if (world.m_46791_() == Difficulty.EASY) {
                potionLevel = 0;
                waitTicks = 1200;
            } else if (world.m_46791_() == Difficulty.NORMAL) {
                potionLevel = 0;
                waitTicks = 2400;
            } else if (world.m_46791_() == Difficulty.HARD) {
                potionLevel = 1;
                waitTicks = 4800;
            }
            if (!player.m_150110_().f_35937_) {
                apple.m_41774_(1);
            }
            player.m_21011_(hand, true);
            this.m_5496_(SoundEvents.f_12644_, 1.0f, 1.0f);
            this.m_21195_(MobEffects.f_19613_);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, waitTicks, potionLevel));
            this.convert = waitTicks;
            this.m_20088_().m_135381_(DATA_CONVERTING, (Object)true);
        }
        return InteractionResult.FAIL;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, data, tag);
        ItemStack sword = new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get());
        this.m_21553_(true);
        this.m_8061_(EquipmentSlot.MAINHAND, sword);
        return retval;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22266_(Attributes.f_22287_);
        return builder;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random) && Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random));
    }
}

