/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.KoboldsMod;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsModSounds;
import net.salju.kobolds.item.KoboldPotionUtils;

public class KoboldEnchanter
extends AbstractKoboldEntity {
    public KoboldEnchanter(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KoboldEnchanter>)((EntityType)KoboldsMobs.KOBOLD_ENCHANTER.get()), world);
    }

    public KoboldEnchanter(EntityType<KoboldEnchanter> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new KoboldTradeGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
    }

    @Override
    protected boolean m_7808_(ItemStack drop, ItemStack hand) {
        if (drop.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)hand)) {
                return false;
            }
            if (hand.m_41619_() || hand.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (hand.m_41720_() instanceof ArmorItem) {
                ArmorItem newbie = (ArmorItem)drop.m_41720_();
                ArmorItem worn = (ArmorItem)hand.m_41720_();
                if (newbie.m_40404_() != worn.m_40404_()) {
                    return newbie.m_40404_() > worn.m_40404_();
                }
                if (newbie.m_40405_() != worn.m_40405_()) {
                    return newbie.m_40405_() > worn.m_40405_();
                }
                return this.m_21477_(drop, hand);
            }
            return false;
        }
        return drop.m_41720_() == Items.f_42616_ && hand.m_41619_();
    }

    class KoboldTradeGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldTradeGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.checkHand() && !this.kobold.m_21023_(MobEffects.f_19596_);
        }

        public void m_8056_() {
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, -10, false, false));
            ItemStack potion = KoboldPotionUtils.sellPotion(new ItemStack((ItemLike)KoboldsItems.KOBOLD_POTION.get()), Mth.m_14072_((Random)new Random(), (int)0, (int)100));
            KoboldsMod.queueServerWork(100, () -> {
                if (this.kobold.m_6084_()) {
                    this.kobold.m_21011_(InteractionHand.MAIN_HAND, true);
                    this.kobold.m_5496_(KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_trade")), 1.0f, 1.0f);
                    Level world = this.kobold.f_19853_;
                    double x = this.kobold.m_20185_();
                    double y = this.kobold.m_20186_();
                    double z = this.kobold.m_20189_();
                    if (world instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)world;
                        if (Math.random() >= 0.1) {
                            Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.kobold, (int)2, (int)0);
                            Player target = lvl.m_45930_((Entity)this.kobold, 7.0);
                            if (target != null) {
                                pos = target.m_20182_();
                            }
                            BehaviorUtils.m_22613_((LivingEntity)this.kobold, (ItemStack)potion, (Vec3)pos);
                        } else {
                            List<ItemStack> list = AbstractKoboldEntity.getTradeItems(this.kobold, "kobolds:gameplay/enchanter_loot");
                            Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.kobold, (int)2, (int)0);
                            Player target = lvl.m_45930_((Entity)this.kobold, 7.0);
                            if (target != null) {
                                pos = target.m_20182_();
                            }
                            for (ItemStack stack : list) {
                                BehaviorUtils.m_22613_((LivingEntity)this.kobold, (ItemStack)stack, (Vec3)pos);
                            }
                        }
                    }
                    KoboldsMod.queueServerWork(20, () -> this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_));
                }
            });
        }

        protected boolean checkHand() {
            return this.kobold.m_21206_().m_41720_() == Items.f_42616_;
        }
    }
}

