/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.KoboldsMod;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsModSounds;

public class KoboldCaptain
extends AbstractKoboldEntity {
    public KoboldCaptain(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KoboldCaptain>)((EntityType)KoboldsMobs.KOBOLD_CAPTAIN.get()), world);
    }

    public KoboldCaptain(EntityType<KoboldCaptain> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new KoboldTradeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        super.m_6071_(player, hand);
        ItemStack gem = player.m_21120_(hand).m_41777_();
        ItemStack off = this.m_21206_();
        Level world = this.f_19853_;
        if (!world.m_5776_() && this.m_6084_() && off.m_41720_() == ItemStack.f_41583_.m_41720_() && (gem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_one"))) || gem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_two"))) || gem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_three"))))) {
            this.m_21008_(InteractionHand.OFF_HAND, gem);
            if (!player.m_150110_().f_35937_) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    class KoboldTradeGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldTradeGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.checkHand() && !this.kobold.m_21023_(MobEffects.f_19596_);
        }

        public void m_8056_() {
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, -10, false, false));
            ItemStack off = this.kobold.m_21206_();
            Level world = this.kobold.f_19853_;
            double x = this.kobold.m_20185_();
            double y = this.kobold.m_20186_();
            double z = this.kobold.m_20189_();
            if (off.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_one")))) {
                KoboldsMod.queueServerWork(100, () -> this.lambda$start$1((LevelAccessor)world));
            } else if (off.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_two")))) {
                KoboldsMod.queueServerWork(100, () -> this.lambda$start$3((LevelAccessor)world));
            } else if (off.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_three")))) {
                KoboldsMod.queueServerWork(100, () -> this.lambda$start$5((LevelAccessor)world));
            }
        }

        protected boolean checkHand() {
            ItemStack off = this.kobold.m_21206_();
            return off.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_one"))) || off.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_two"))) || off.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:captain_tier_three")));
        }

        private /* synthetic */ void lambda$start$5(LevelAccessor world) {
            if (this.kobold.m_6084_()) {
                this.kobold.m_21011_(InteractionHand.MAIN_HAND, true);
                this.kobold.m_5496_(KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_trade")), 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    List<ItemStack> list = AbstractKoboldEntity.getTradeItems(this.kobold, "kobolds:gameplay/captain_three_loot");
                    Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.kobold, (int)2, (int)1);
                    Player target = lvl.m_45930_((Entity)this.kobold, 7.0);
                    if (target != null) {
                        pos = target.m_20182_();
                    }
                    for (ItemStack stack : list) {
                        BehaviorUtils.m_22613_((LivingEntity)this.kobold, (ItemStack)stack, (Vec3)pos);
                    }
                }
                KoboldsMod.queueServerWork(20, () -> this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_));
            }
        }

        private /* synthetic */ void lambda$start$3(LevelAccessor world) {
            if (this.kobold.m_6084_()) {
                this.kobold.m_21011_(InteractionHand.MAIN_HAND, true);
                this.kobold.m_5496_(KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_trade")), 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    List<ItemStack> list = AbstractKoboldEntity.getTradeItems(this.kobold, "kobolds:gameplay/captain_two_loot");
                    Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.kobold, (int)2, (int)1);
                    Player target = lvl.m_45930_((Entity)this.kobold, 7.0);
                    if (target != null) {
                        pos = target.m_20182_();
                    }
                    for (ItemStack stack : list) {
                        BehaviorUtils.m_22613_((LivingEntity)this.kobold, (ItemStack)stack, (Vec3)pos);
                    }
                }
                KoboldsMod.queueServerWork(20, () -> this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_));
            }
        }

        private /* synthetic */ void lambda$start$1(LevelAccessor world) {
            if (this.kobold.m_6084_()) {
                this.kobold.m_21011_(InteractionHand.MAIN_HAND, true);
                this.kobold.m_5496_(KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_trade")), 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    List<ItemStack> list = AbstractKoboldEntity.getTradeItems(this.kobold, "kobolds:gameplay/captain_one_loot");
                    Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.kobold, (int)2, (int)1);
                    Player target = lvl.m_45930_((Entity)this.kobold, 7.0);
                    if (target != null) {
                        pos = target.m_20182_();
                    }
                    for (ItemStack stack : list) {
                        BehaviorUtils.m_22613_((LivingEntity)this.kobold, (ItemStack)stack, (Vec3)pos);
                    }
                }
                KoboldsMod.queueServerWork(20, () -> this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_));
            }
        }
    }
}

