/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.KoboldsMod;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsModSounds;

public class Kobold
extends AbstractKoboldEntity {
    public Kobold(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Kobold>)((EntityType)KoboldsMobs.KOBOLD.get()), world);
    }

    public Kobold(EntityType<Kobold> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new KoboldTradeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldWarriorGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
    }

    class KoboldTradeGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldTradeGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.checkHand() && !this.kobold.m_21023_(MobEffects.f_19596_);
        }

        public void m_8056_() {
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, -10, false, false));
            KoboldsMod.queueServerWork(100, () -> {
                if (this.kobold.m_6084_()) {
                    this.kobold.m_21011_(InteractionHand.MAIN_HAND, true);
                    this.kobold.m_5496_(KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_trade")), 1.0f, 1.0f);
                    Level world = this.kobold.f_19853_;
                    double x = this.kobold.m_20185_();
                    double y = this.kobold.m_20186_();
                    double z = this.kobold.m_20189_();
                    if (world instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)world;
                        List<ItemStack> list = AbstractKoboldEntity.getTradeItems(this.kobold, "kobolds:gameplay/trader_loot");
                        Vec3 pos = LandRandomPos.m_148488_((PathfinderMob)this.kobold, (int)2, (int)1);
                        Player target = lvl.m_45930_((Entity)this.kobold, 7.0);
                        if (target != null) {
                            pos = target.m_20182_();
                        }
                        for (ItemStack stack : list) {
                            BehaviorUtils.m_22613_((LivingEntity)this.kobold, (ItemStack)stack, (Vec3)pos);
                        }
                    }
                    KoboldsMod.queueServerWork(20, () -> this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_));
                }
            });
        }

        protected boolean checkHand() {
            return this.kobold.m_21206_().m_41720_() == Items.f_42616_;
        }
    }

    class KoboldWarriorGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldWarriorGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.checkHand() && !this.kobold.m_21023_(MobEffects.f_19596_);
        }

        public void m_8056_() {
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, -10, false, false));
            KoboldsMod.queueServerWork(600, () -> {
                ItemStack weapon = this.kobold.m_21205_();
                ItemStack off = this.kobold.m_21206_();
                Level world = this.kobold.f_19853_;
                double x = this.kobold.m_20185_();
                double y = this.kobold.m_20186_();
                double z = this.kobold.m_20189_();
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    ItemEntity drop = new ItemEntity((Level)lvl, x, y, z, weapon);
                    drop.m_32010_(10);
                    world.m_7967_((Entity)drop);
                    this.kobold.m_8061_(EquipmentSlot.MAINHAND, off);
                    this.kobold.m_21409_(EquipmentSlot.MAINHAND, 1.0f);
                    this.kobold.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
                    KoboldWarrior war = (KoboldWarrior)this.kobold.m_21406_((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), true);
                    ForgeEventFactory.onLivingConvert((LivingEntity)this.kobold, (LivingEntity)war);
                }
            });
        }

        protected boolean checkHand() {
            return this.kobold.m_21206_().m_41720_() instanceof AxeItem;
        }
    }
}

