/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.ForgeEventFactory;
import net.salju.kobolds.KoboldsMod;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldCaptain;
import net.salju.kobolds.entity.KoboldChild;
import net.salju.kobolds.entity.KoboldEnchanter;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldPirate;
import net.salju.kobolds.entity.KoboldRascal;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsModSounds;
import net.salju.kobolds.item.KoboldPotionUtils;

public abstract class AbstractKoboldEntity
extends Monster
implements CrossbowAttackMob,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack primary = new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get());
    private ItemStack trident = ItemStack.f_41583_;
    private boolean partyKobold;
    private int breed;
    private int cd;
    @Nullable
    private BlockPos jukebox;

    protected AbstractKoboldEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 4;
        this.m_21553_(true);
        this.m_21530_();
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 14.0f, 1.2, 1.8));
        this.f_21346_.m_25352_(0, (Goal)new KoboldRevengeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldShieldGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldHealGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new KoboldTridentAttackGoal(this, 1.0, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new RangedCrossbowAttackGoal((Monster)this, 1.0, 12.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, false, (Predicate)new KoboldAttackSelector(this)));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Primary", (Tag)this.primary.m_41739_(new CompoundTag()));
        tag.m_128365_("Trident", (Tag)this.trident.m_41739_(new CompoundTag()));
        tag.m_128405_("Breed", this.breed);
        tag.m_128405_("CD", this.cd);
    }

    public void m_7378_(CompoundTag tag) {
        ItemStack stack;
        super.m_7378_(tag);
        if (tag.m_128441_("Primary")) {
            this.primary = stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Primary"));
        }
        if (tag.m_128441_("Trident")) {
            this.trident = stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Trident"));
        }
        if (tag.m_128441_("Breed")) {
            int saved;
            this.breed = saved = tag.m_128451_("Breed");
        }
        if (tag.m_128441_("CD")) {
            int saved;
            this.cd = saved = tag.m_128451_("CD");
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6935_(Player player) {
        return false;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.225;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21532_();
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 2.0f);
        } else if (this.m_21206_().m_41720_() instanceof TridentItem) {
            this.trident = this.m_21206_();
            ThrownTrident proj = new ThrownTrident(this.f_19853_, (LivingEntity)this, this.trident);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - proj.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            proj.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
            this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_21187_().nextFloat() * 0.4f + 0.8f));
            this.f_19853_.m_7967_((Entity)proj);
            this.m_21008_(InteractionHand.MAIN_HAND, this.primary);
            this.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            this.cd = 1200;
        }
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_5811_(LivingEntity arg0, ItemStack arg1, Projectile arg2, float arg3) {
        this.m_32322_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void m_6136_(boolean charging) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)charging);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_21540_(ItemStack stack) {
        EquipmentSlot slot = AbstractKoboldEntity.m_147233_((ItemStack)stack);
        ItemStack current = this.m_6844_(slot);
        boolean flag = this.m_7808_(stack, current);
        if (stack.m_41720_() == Items.f_42616_ || stack.m_41720_() instanceof TridentItem) {
            slot = EquipmentSlot.OFFHAND;
            current = this.m_6844_(slot);
            flag = this.m_7808_(stack, current);
        }
        if (flag && this.m_7252_(stack)) {
            double d0 = this.m_21519_(slot);
            if (!current.m_41619_() && (double)Math.max(this.f_19796_.nextFloat() - 0.1f, 0.0f) < d0) {
                this.m_19983_(current);
            }
            if (stack.m_41720_() == Items.f_42616_ && stack.m_41613_() > 1) {
                ItemStack copy = stack.m_41620_(1);
                this.m_7581_(new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), copy));
                return false;
            }
            this.m_147218_(stack);
            this.m_21468_(slot, stack);
            return true;
        }
        return false;
    }

    protected boolean m_7808_(ItemStack drop, ItemStack hand) {
        if (drop.m_41720_() instanceof SwordItem) {
            if (hand.m_41619_() && this.m_21206_().m_41720_() instanceof TridentItem) {
                return false;
            }
            if (!(hand.m_41720_() instanceof SwordItem)) {
                return true;
            }
            SwordItem newbie = (SwordItem)drop.m_41720_();
            SwordItem weapon = (SwordItem)hand.m_41720_();
            if (newbie.m_43299_() != weapon.m_43299_()) {
                return newbie.m_43299_() > weapon.m_43299_();
            }
            return this.m_21477_(drop, hand);
        }
        if (drop.m_41720_() instanceof CrossbowItem && hand.m_41720_() instanceof CrossbowItem) {
            return this.m_21477_(drop, hand);
        }
        if (drop.m_41720_() instanceof ArmorItem) {
            if (EnchantmentHelper.m_44920_((ItemStack)hand)) {
                return false;
            }
            if (hand.m_41619_() || hand.m_41720_() instanceof BlockItem) {
                return true;
            }
            if (hand.m_41720_() instanceof ArmorItem) {
                ArmorItem newbie = (ArmorItem)drop.m_41720_();
                ArmorItem worn = (ArmorItem)hand.m_41720_();
                if (newbie.m_40404_() != worn.m_40404_()) {
                    return newbie.m_40404_() > worn.m_40404_();
                }
                if (newbie.m_40405_() != worn.m_40405_()) {
                    return newbie.m_40405_() > worn.m_40405_();
                }
                return this.m_21477_(drop, hand);
            }
            return false;
        }
        if (drop.m_41720_() instanceof ShieldItem && hand.m_41619_() && this.trident.m_41619_()) {
            return true;
        }
        if (drop.m_41720_() instanceof TridentItem && hand.m_41619_() && this.trident.m_41619_()) {
            this.primary = this.m_21205_();
            this.trident = drop;
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            return true;
        }
        return drop.m_41720_() == Items.f_42616_ && hand.m_41619_() && !(this instanceof KoboldCaptain);
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 12.76) || !this.f_19853_.m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.partyKobold = false;
            this.jukebox = null;
        }
        super.m_8107_();
    }

    public void m_6818_(BlockPos pos, boolean boop) {
        this.jukebox = pos;
        this.partyKobold = boop;
    }

    public void setCD(int i) {
        this.cd = i;
    }

    public boolean isPartyKobold() {
        return this.partyKobold;
    }

    public int getCD() {
        return this.cd;
    }

    public SoundEvent m_7515_() {
        return KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_idle"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        if (this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_hurt"));
    }

    public SoundEvent m_5592_() {
        return KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_death"));
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (source.m_7640_() instanceof Zombie && (!this.m_6162_() && this.f_19853_.m_46791_() == Difficulty.HARD || this.f_19853_.m_46791_() == Difficulty.NORMAL)) {
            this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                KoboldZombie zombo = (KoboldZombie)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get(), true);
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zombo);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        super.m_6071_(player, hand);
        ItemStack gem = player.m_21120_(hand).m_41777_();
        ItemStack weapon = this.m_21205_();
        ItemStack off = this.m_21206_();
        Level world = this.f_19853_;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (this.m_6084_()) {
            if (player.m_21205_().m_41619_() && player.m_21206_().m_41619_()) {
                this.m_5496_(KoboldsModSounds.REGISTRY.get(new ResourceLocation("kobolds:kobold_purr")), 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer ply = (ServerPlayer)player;
                    Advancement adv = ply.f_8924_.m_129889_().m_136041_(new ResourceLocation("kobolds:kobold_pet_advancement"));
                    AdvancementProgress ap = ply.m_8960_().m_135996_(adv);
                    if (!ap.m_8193_()) {
                        Iterator gator = ap.m_8219_().iterator();
                        while (gator.hasNext()) {
                            ply.m_8960_().m_135988_(adv, (String)gator.next());
                        }
                    }
                }
                player.m_6674_(InteractionHand.MAIN_HAND);
            } else if (!world.m_5776_() && off.m_41619_() && this.m_6142_()) {
                if (gem.m_41720_() instanceof AxeItem) {
                    if (this instanceof Kobold) {
                        this.m_21008_(InteractionHand.OFF_HAND, gem);
                        if (!player.m_150110_().f_35937_) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else if (gem.m_41720_() == Items.f_42616_) {
                    if (this instanceof Kobold || this instanceof KoboldPirate || this instanceof KoboldEnchanter || this instanceof KoboldEngineer) {
                        gem.m_41764_(1);
                        this.m_21008_(InteractionHand.OFF_HAND, gem);
                        if (!player.m_150110_().f_35937_) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else if (gem.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("kobolds:kobold_breed_items")))) {
                    KoboldWarrior target = (KoboldWarrior)world.m_45963_(KoboldWarrior.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142469_().m_82400_(32.0));
                    if (!(this instanceof KoboldWarrior) && !this.m_6162_() && target != null && this.breed <= 0) {
                        this.breed = 24000;
                        if (!player.m_150110_().f_35937_) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else if (gem.m_41720_() == KoboldsItems.KOBOLD_SPAWN_EGG.get() && this instanceof Kobold) {
                    Level adv = this.f_19853_;
                    if (adv instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)adv;
                        BlockPos spawn = new BlockPos(x, y, z);
                        KoboldChild koboldChild = (KoboldChild)((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).m_20600_(lvl, null, null, null, spawn, MobSpawnType.BREEDING, false, false);
                    }
                    if (!player.m_150110_().f_35937_) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, data, tag);
        this.m_6851_(difficulty);
        AbstractKoboldEntity abstractKoboldEntity = this;
        if (abstractKoboldEntity instanceof KoboldRascal) {
            KoboldRascal rascal = (KoboldRascal)abstractKoboldEntity;
            rascal.setDespawnDelay(24000);
            rascal.m_7292_(new MobEffectInstance(MobEffects.f_19609_, rascal.getDespawnDelay(), 0));
        }
        return retval;
    }

    protected void m_6851_(DifficultyInstance souls) {
        ItemStack sword = EnchantmentHelper.m_44877_((Random)new Random(), (ItemStack)new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()), (int)21, (boolean)false);
        ItemStack crossbow = EnchantmentHelper.m_44877_((Random)new Random(), (ItemStack)new ItemStack((ItemLike)Items.f_42717_), (int)21, (boolean)false);
        if (this instanceof KoboldWarrior) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_AXE.get()));
        } else if (this instanceof KoboldRascal || this instanceof KoboldCaptain) {
            this.m_8061_(EquipmentSlot.MAINHAND, sword);
        } else if (this instanceof KoboldEngineer) {
            this.m_8061_(EquipmentSlot.MAINHAND, crossbow);
        } else if (this instanceof Kobold || this instanceof KoboldPirate) {
            if (Math.random() >= 0.6) {
                if (Math.random() >= 0.15) {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
                } else {
                    this.m_8061_(EquipmentSlot.MAINHAND, crossbow);
                }
            } else if (Math.random() >= 0.15) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, sword);
            }
        }
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        if (this instanceof KoboldWarrior) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        } else if (this instanceof KoboldPirate && Math.random() >= 0.75) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42713_));
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            this.trident = this.m_21206_();
        }
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public void m_6075_() {
        super.m_6075_();
        Level world = this.f_19853_;
        if (!world.m_5776_() && this.m_6084_() && this.m_6142_()) {
            if (this.cd > 0) {
                if (this.cd == 1 && !this.trident.m_41619_()) {
                    this.primary = this.m_21205_();
                    this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    this.m_21008_(InteractionHand.OFF_HAND, this.trident);
                }
                --this.cd;
            }
            if (this.breed > 0) {
                if (this.breed == 12000 && world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    KoboldChild koboldChild = (KoboldChild)((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).m_20600_(lvl, null, null, null, pos, MobSpawnType.BREEDING, false, false);
                }
                --this.breed;
            }
            for (ThrownTrident proj : this.f_19853_.m_45976_(ThrownTrident.class, this.m_142469_().m_82400_(0.85))) {
                if (proj.m_37282_() != this || proj.f_37557_ <= 0 || !this.m_21206_().m_41619_()) continue;
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                this.m_21008_(InteractionHand.OFF_HAND, this.trident);
                this.cd = 0;
                proj.m_146870_();
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity target;
        Projectile proj;
        Entity direct = source.m_7640_();
        if (direct instanceof Projectile && (proj = (Projectile)direct).m_37282_() instanceof AbstractKoboldEntity || direct instanceof AbstractKoboldEntity || source.m_19384_()) {
            return false;
        }
        if (direct instanceof LivingEntity && (target = (LivingEntity)direct).m_21205_().m_41720_() instanceof AxeItem && this.m_21254_()) {
            this.cd = 100;
        }
        return super.m_6469_(source, amount);
    }

    public static List<ItemStack> getTradeItems(AbstractKoboldEntity kobold, String table) {
        LootTable loot = kobold.f_19853_.m_142572_().m_129898_().m_79217_(new ResourceLocation(table));
        List list = loot.m_79129_(new LootContext.Builder((ServerLevel)kobold.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)kobold).m_78975_(LootContextParamSets.f_81410_));
        return list;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        return builder;
    }

    class KoboldRevengeGoal
    extends HurtByTargetGoal {
        public KoboldRevengeGoal(AbstractKoboldEntity kobold) {
            super((PathfinderMob)kobold, new Class[0]);
            this.m_26044_(new Class[]{AbstractKoboldEntity.class});
        }

        public void m_8056_() {
            super.m_8056_();
            for (AbstractKoboldEntity kobolds : this.f_26135_.f_19853_.m_6443_(AbstractKoboldEntity.class, this.f_26135_.m_142469_().m_82400_(32.0), kobold -> kobold.m_5448_() == null)) {
                if (this.f_26135_.f_19853_.m_46791_() == Difficulty.PEACEFUL) continue;
                kobolds.m_6710_(this.f_26135_.m_5448_());
            }
        }
    }

    class KoboldShieldGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;

        public KoboldShieldGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.kobold.m_21206_().m_41720_() instanceof ShieldItem && this.raiseShield() && this.kobold.getCD() == 0;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.kobold.m_6672_(InteractionHand.OFF_HAND);
        }

        public void m_8041_() {
            this.kobold.m_5810_();
        }

        protected boolean raiseShield() {
            if (this.kobold.m_5448_() != null) {
                LivingEntity target = this.kobold.m_5448_();
                if (target instanceof RangedAttackMob && (double)this.kobold.m_20270_((Entity)target) >= 0.2) {
                    return true;
                }
                if ((double)this.kobold.m_20270_((Entity)target) >= 0.2 && (double)this.kobold.m_20270_((Entity)target) <= 5.2) {
                    return true;
                }
            }
            return false;
        }
    }

    class KoboldHealGoal
    extends Goal {
        public final AbstractKoboldEntity kobold;
        private ItemStack potion = new ItemStack((ItemLike)KoboldsItems.KOBOLD_POTION.get());

        public KoboldHealGoal(AbstractKoboldEntity kobold) {
            this.kobold = kobold;
        }

        public boolean m_8036_() {
            return this.kobold.m_21223_() < 12.0f && this.kobold.getCD() == 0 && this.checkHand() && !this.kobold.m_6162_() && !(this.kobold instanceof KoboldRascal);
        }

        public void m_8056_() {
            this.kobold.m_21008_(InteractionHand.OFF_HAND, KoboldPotionUtils.makePotion(this.potion, MobEffects.f_19601_, MobEffects.f_19605_, 1, 900));
            this.kobold.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 32, -4, false, false));
            this.kobold.m_5496_(SoundEvents.f_11911_, 0.5f, 1.0f);
            KoboldsMod.queueServerWork(32, () -> {
                for (MobEffectInstance effect : KoboldPotionUtils.getEffects(this.kobold.m_21206_())) {
                    this.kobold.m_7292_(effect);
                }
                this.kobold.setCD(900);
                this.kobold.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            });
        }

        protected boolean checkHand() {
            return this.kobold.m_21206_().m_41619_() || this.kobold.m_21206_().m_41720_() == KoboldsItems.KOBOLD_POTION.get();
        }
    }

    class KoboldTridentAttackGoal
    extends RangedAttackGoal {
        public final AbstractKoboldEntity kobold;

        public KoboldTridentAttackGoal(RangedAttackMob kobold, double dub, int inty, float enty) {
            super(kobold, dub, inty, enty);
            this.kobold = (AbstractKoboldEntity)kobold;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.kobold.m_21206_().m_41720_() == Items.f_42713_;
        }

        public void m_8056_() {
            super.m_8056_();
            this.kobold.m_21561_(true);
            this.kobold.m_6672_(InteractionHand.OFF_HAND);
        }

        public void m_8041_() {
            super.m_8041_();
            this.kobold.m_21561_(false);
            this.kobold.m_5810_();
        }
    }

    static class KoboldAttackSelector
    implements Predicate<LivingEntity> {
        private final AbstractKoboldEntity kobold;

        public KoboldAttackSelector(AbstractKoboldEntity source) {
            this.kobold = source;
        }

        @Override
        public boolean test(@Nullable LivingEntity target) {
            if (!(this.kobold instanceof KoboldEnchanter && this.kobold instanceof KoboldChild && target instanceof ZombifiedPiglin)) {
                if (this.kobold instanceof KoboldWarrior) {
                    return target instanceof Zombie || target instanceof Skeleton || target instanceof Spider || target instanceof Villager || target instanceof Raider;
                }
                if (this.kobold instanceof KoboldEngineer || this.kobold instanceof KoboldRascal) {
                    return target instanceof Villager || target instanceof Raider;
                }
                return target instanceof Zombie || target instanceof Villager || target instanceof Silverfish;
            }
            return false;
        }
    }
}

