/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class RascalModel<T extends AbstractKoboldEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation RASCAL_MODEL = new ModelLayerLocation(new ResourceLocation("kobolds", "kobold_rascal"), "main");
    public final ModelPart bag;

    public RascalModel(ModelPart root) {
        super(root);
        this.bag = root.m_171324_("bag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = KoboldModel.createMesh(CubeDeformation.f_171458_, 0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bag = partdefinition.m_171599_("bag", CubeListBuilder.m_171558_().m_171514_(26, 30).m_171488_(-1.0f, 0.0f, 2.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(33, 7).m_171488_(-5.0f, -0.85f, -1.5f, 8.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102812_.f_104203_ = -0.7854f;
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = 0.0f;
        this.f_102814_.f_104203_ = 0.0f;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        this.bag.f_104203_ = 0.0f;
        this.bag.f_104204_ = 0.0f;
        this.bag.f_104205_ = 0.0f;
        this.f_102810_.f_104203_ = 0.0f;
        this.f_102810_.f_104204_ = 0.0f;
        this.f_102810_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.f_102808_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102809_.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.f_102809_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_102811_.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (this.f_102609_) {
            this.f_102813_.f_104203_ = -1.5708f;
            this.f_102814_.f_104203_ = -1.5708f;
            this.f_102813_.f_104204_ = 0.2618f;
            this.f_102814_.f_104204_ = -0.2618f;
        }
        if (((AbstractKoboldEntity)((Object)kobold)).isPartyKobold()) {
            this.f_102808_.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.4f)) * 0.04f + 0.04f;
            this.f_102809_.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.4f)) * 0.04f + 0.04f;
        }
        if (kobold.m_21033_(EquipmentSlot.MAINHAND) && kobold.m_5912_()) {
            this.f_102811_.f_104203_ = -2.0944f;
            this.f_102811_.f_104204_ = 0.1745f;
        }
        if (this.f_102608_ > 0.0f) {
            if (kobold.m_5912_()) {
                float progress = this.f_102608_;
                progress = 1.0f - this.f_102608_;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                this.f_102811_.f_104203_ = (float)((double)this.f_102811_.f_104203_ - ((double)f2 / 1.2 - 1.0));
            } else {
                float progress = this.f_102608_;
                this.f_102810_.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                this.f_102811_.f_104204_ += this.f_102810_.f_104204_;
                this.f_102812_.f_104204_ += this.f_102810_.f_104204_;
                this.f_102812_.f_104203_ += this.f_102810_.f_104204_;
                progress = 1.0f - this.f_102608_;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.m_14031_((float)(progress * (float)Math.PI));
                float f3 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.f_102808_.f_104203_ - 0.7f) * 0.75f;
                this.f_102811_.f_104203_ = (float)((double)this.f_102811_.f_104203_ - ((double)f2 * 1.2 + (double)f3));
                this.f_102811_.f_104204_ += this.f_102810_.f_104204_ * 2.0f;
                this.f_102811_.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
            }
        }
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        switch (arm) {
            case LEFT: {
                this.f_102811_.m_104299_(poseStack);
                poseStack.m_85837_(-0.045, 0.096, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.f_102811_.m_104299_(poseStack);
                poseStack.m_85837_(-0.045, 0.096, 0.0);
                poseStack.m_85841_(0.75f, 0.75f, 0.75f);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102808_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102809_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.bag.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102810_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102811_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102813_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102812_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.f_102814_.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

