/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.salju.kobolds.entity.KoboldSkeleton;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldSkull
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public KoboldSkull() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76296_).m_60918_(SoundType.f_56724_).m_60913_(0.7f, 4.0f).m_60955_().m_60977_().m_60924_((bs, br, bp) -> false).m_60988_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return (switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> Shapes.m_83110_((VoxelShape)KoboldSkull.m_49796_((double)4.5, (double)0.0, (double)3.5, (double)11.5, (double)7.0, (double)10.5), (VoxelShape)KoboldSkull.m_49796_((double)5.5, (double)0.0, (double)10.5, (double)10.5, (double)3.0, (double)13.5));
            case Direction.NORTH -> Shapes.m_83110_((VoxelShape)KoboldSkull.m_49796_((double)4.5, (double)0.0, (double)5.5, (double)11.5, (double)7.0, (double)12.5), (VoxelShape)KoboldSkull.m_49796_((double)5.5, (double)0.0, (double)2.5, (double)10.5, (double)3.0, (double)5.5));
            case Direction.EAST -> Shapes.m_83110_((VoxelShape)KoboldSkull.m_49796_((double)3.5, (double)0.0, (double)4.5, (double)10.5, (double)7.0, (double)11.5), (VoxelShape)KoboldSkull.m_49796_((double)10.5, (double)0.0, (double)5.5, (double)13.5, (double)3.0, (double)10.5));
            case Direction.WEST -> Shapes.m_83110_((VoxelShape)KoboldSkull.m_49796_((double)5.5, (double)0.0, (double)4.5, (double)12.5, (double)7.0, (double)11.5), (VoxelShape)KoboldSkull.m_49796_((double)2.5, (double)0.0, (double)5.5, (double)5.5, (double)3.0, (double)10.5));
        }).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_6861_(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(blockstate, world, pos, neighborBlock, fromPos, moving);
        if (world.m_46755_(pos) > 0) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            BlockPos poz = new BlockPos((double)x + 0.5, (double)y, (double)z + 0.5);
            if (!world.m_5776_() && !world.m_46461_() && world.m_46861_(pos)) {
                world.m_46961_(pos, false);
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)lvl);
                    bolt.m_20219_(Vec3.m_82539_((Vec3i)poz));
                    bolt.m_20874_(true);
                    KoboldSkeleton skelebold = (KoboldSkeleton)((EntityType)KoboldsMobs.KOBOLD_SKELETON.get()).m_20600_(lvl, null, null, null, poz, MobSpawnType.MOB_SUMMONED, false, false);
                    lvl.m_7967_((Entity)bolt);
                }
            }
        }
    }

    public void m_7458_(BlockState blockstate, ServerLevel world, BlockPos pos, Random rng) {
        super.m_7458_(blockstate, world, pos, rng);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos poz = new BlockPos((double)x + 0.5, (double)y, (double)z + 0.5);
        if (!world.m_5776_() && !world.m_46461_() && world.m_46861_(pos)) {
            world.m_46961_(pos, false);
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)world);
            bolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
            bolt.m_20874_(true);
            KoboldSkeleton skelebold = (KoboldSkeleton)((EntityType)KoboldsMobs.KOBOLD_SKELETON.get()).m_20600_(world, null, null, null, poz, MobSpawnType.MOB_SUMMONED, false, false);
            world.m_7967_((Entity)bolt);
        }
    }
}

