/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.init;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.entity.IceologerEntity;
import com.faboslav.friendsandfoes.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.entity.MaulerEntity;
import com.faboslav.friendsandfoes.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.mixin.SpawnRestrictionAccessor;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.EnumUtils;

public final class ModEntity {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"friendsandfoes", (ResourceKey)Registry.f_122903_);
    private static boolean previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
    public static final RegistrySupplier<EntityType<CopperGolemEntity>> COPPER_GOLEM;
    public static final RegistrySupplier<EntityType<GlareEntity>> GLARE;
    public static final RegistrySupplier<EntityType<IceologerEntity>> ICEOLOGER;
    public static final RegistrySupplier<EntityType<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final RegistrySupplier<EntityType<MaulerEntity>> MAULER;
    public static final RegistrySupplier<EntityType<MoobloomEntity>> MOOBLOOM;

    public static void initRegister() {
        previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
        SharedConstants.f_136182_ = false;
        ENTITY_TYPES.register();
        SharedConstants.f_136182_ = previousUseChoiceTypeRegistrations;
        ModEntity.initMobAttributes();
    }

    public static void init() {
        ModEntity.initSpawnRestrictions();
        ModEntity.initBiomeModifications();
    }

    public static void initMobAttributes() {
        EntityAttributeRegistry.register(COPPER_GOLEM, CopperGolemEntity::createAttributes);
        EntityAttributeRegistry.register(GLARE, GlareEntity::createAttributes);
        EntityAttributeRegistry.register(ICEOLOGER, IceologerEntity::createAttributes);
        EntityAttributeRegistry.register(MAULER, MaulerEntity::createAttributes);
        EntityAttributeRegistry.register(MOOBLOOM, Cow::m_28307_);
    }

    public static void initSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister((EntityType)GLARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GlareEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((EntityType)ICEOLOGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_33056_);
        SpawnRestrictionAccessor.callRegister((EntityType)MAULER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MaulerEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((EntityType)MOOBLOOM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoobloomEntity::canSpawn);
    }

    public static void initBiomeModifications() {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableGlare && config.enableGlareSpawn) {
            Predicate<BiomeModifications.BiomeContext> LUSH_CAVES = ctx -> Objects.equals(ctx.getKey(), Biomes.f_151785_.m_135782_());
            ModEntity.registerBiomeModification(LUSH_CAVES, (EntityType)GLARE.get(), EnumUtils.isValidEnum(MobCategory.class, (String)"GLARES") ? MobCategory.valueOf((String)"GLARES") : MobCategory.CREATURE, config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            Predicate<BiomeModifications.BiomeContext> DESERT = ctx -> Objects.equals(ctx.getKey(), Biomes.f_48203_.m_135782_());
            Predicate<BiomeModifications.BiomeContext> BADLANDS = ctx -> Objects.equals(ctx.getKey(), Biomes.f_48159_.m_135782_());
            Predicate<BiomeModifications.BiomeContext> ERODED_BADLANDS = ctx -> Objects.equals(ctx.getKey(), Biomes.f_48194_.m_135782_());
            Predicate<BiomeModifications.BiomeContext> WOODED_BADLANDS = ctx -> Objects.equals(ctx.getKey(), Biomes.f_186753_.m_135782_());
            Predicate<BiomeModifications.BiomeContext> SAVANNA = ctx -> Objects.equals(ctx.getKey(), Biomes.f_48157_.m_135782_());
            Predicate<BiomeModifications.BiomeContext> SAVANNA_PLATEAU = ctx -> Objects.equals(ctx.getKey(), Biomes.f_48158_.m_135782_());
            ModEntity.registerBiomeModification(DESERT, (EntityType)MAULER.get(), MobCategory.CREATURE, config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(BADLANDS, (EntityType)MAULER.get(), MobCategory.CREATURE, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(ERODED_BADLANDS, (EntityType)MAULER.get(), MobCategory.CREATURE, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(WOODED_BADLANDS, (EntityType)MAULER.get(), MobCategory.CREATURE, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(SAVANNA, (EntityType)MAULER.get(), MobCategory.CREATURE, config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(SAVANNA_PLATEAU, (EntityType)MAULER.get(), MobCategory.CREATURE, config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            Predicate<BiomeModifications.BiomeContext> FLOWER_FOREST = ctx -> Objects.equals(ctx.getKey(), Biomes.f_48179_.m_135782_());
            Predicate<BiomeModifications.BiomeContext> MEADOW = ctx -> Objects.equals(ctx.getKey(), Biomes.f_186754_.m_135782_());
            ModEntity.registerBiomeModification(FLOWER_FOREST, (EntityType)MOOBLOOM.get(), MobCategory.CREATURE, config.moobloomFlowerForestSpawnWeight, config.moobloomFlowerForestSpawnMinGroupSize, config.moobloomFlowerForestSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(MEADOW, (EntityType)MOOBLOOM.get(), MobCategory.CREATURE, config.moobloomMeadowSpawnWeight, config.moobloomMeadowSpawnMinGroupSize, config.moobloomMeadowSpawnMaxGroupSize);
        }
    }

    private static void registerBiomeModification(Predicate<BiomeModifications.BiomeContext> biomes, EntityType<?> type, MobCategory spawnGroup, int weight, int min, int max) {
        BiomeModifications.addProperties(biomes, (ctx, p) -> p.getSpawnProperties().addSpawn(spawnGroup, new MobSpawnSettings.SpawnerData(type, weight, min, max)));
    }

    private ModEntity() {
    }

    static {
        SharedConstants.f_136182_ = false;
        COPPER_GOLEM = ENTITY_TYPES.register("copper_golem", () -> EntityType.Builder.m_20704_(CopperGolemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 1.375f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("copper_golem")));
        GLARE = ENTITY_TYPES.register("glare", () -> EntityType.Builder.m_20704_(GlareEntity::new, (MobCategory)(EnumUtils.isValidEnum(MobCategory.class, (String)"GLARES") ? MobCategory.valueOf((String)"GLARES") : MobCategory.CREATURE)).m_20699_(0.875f, 1.4375f).m_20702_(8).m_20717_(2).m_20712_(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = ENTITY_TYPES.register("iceologer", () -> EntityType.Builder.m_20704_(IceologerEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = ENTITY_TYPES.register("ice_chunk", () -> EntityType.Builder.m_20704_(IceologerIceChunkEntity::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(2.5f, 1.0f).m_20702_(6).m_20712_(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = ENTITY_TYPES.register("mauler", () -> EntityType.Builder.m_20704_(MaulerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.5625f, 0.5625f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = ENTITY_TYPES.register("moobloom", () -> EntityType.Builder.m_20704_(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20702_(10).m_20712_(FriendsAndFoes.makeStringID("moobloom")));
        SharedConstants.f_136182_ = previousUseChoiceTypeRegistrations;
    }
}

