/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal;

import com.faboslav.friendsandfoes.entity.GlareEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public final class GlareFollowOwnerGoal
extends Goal {
    private final GlareEntity glare;
    private LivingEntity owner;
    private final LevelReader world;
    private final double speed;
    private final PathNavigation navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;
    private final boolean leavesAllowed;

    public GlareFollowOwnerGoal(GlareEntity glare, float minDistance, float maxDistance, boolean leavesAllowed) {
        this.glare = glare;
        this.world = glare.f_19853_;
        this.speed = glare.getFastMovementSpeed();
        this.navigation = glare.m_21573_();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.leavesAllowed = leavesAllowed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.glare.m_142480_();
        if (livingEntity == null || livingEntity.m_5833_() || this.glare.m_21523_() || this.glare.m_21827_() || this.glare.m_20280_((Entity)livingEntity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        return !(this.glare.m_20280_((Entity)this.owner) <= (double)(this.maxDistance * this.maxDistance));
    }

    public void m_8056_() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.glare.m_21439_(BlockPathTypes.WATER);
        this.glare.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.glare.m_21441_(BlockPathTypes.WATER, this.oldWaterPathfindingPenalty);
    }

    public void m_8037_() {
        this.glare.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.glare.m_8132_());
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = this.m_183277_(10);
            if (!this.glare.m_21523_() && !this.glare.m_20159_()) {
                if (this.glare.m_20280_((Entity)this.owner) >= 512.0) {
                    this.tryTeleport();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speed);
                }
            }
        }
    }

    private void tryTeleport() {
        BlockPos blockPos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomInt(-3, 3);
            int k = this.getRandomInt(-1, 1);
            int l = this.getRandomInt(-3, 3);
            boolean bl = this.tryTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.glare.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.glare.m_146908_(), this.glare.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.world.m_8055_(pos.m_7495_());
        if (!this.leavesAllowed && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos = pos.m_141950_((Vec3i)this.glare.m_142538_());
        return this.world.m_45756_((Entity)this.glare, this.glare.m_142469_().m_82338_(blockPos));
    }

    private int getRandomInt(int min, int max) {
        return this.glare.m_21187_().nextInt(max - min + 1) + min;
    }
}

