/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal;

import com.faboslav.friendsandfoes.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.mixin.BeeEntityAccessor;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class BeePollinateMoobloomGoal
extends Goal {
    private final TargetingConditions VALID_MOOBLOOM_PREDICATE = TargetingConditions.m_148353_().m_26893_();
    private final Bee beeEntity;
    private final BeeEntityAccessor beeEntityAccessor;
    private MoobloomEntity moobloom;
    private boolean running;
    private int ticks = 0;
    private int pollinationTicks = 0;
    private int lastPollinationTick = 0;

    public BeePollinateMoobloomGoal(Bee beeEntity, BeeEntityAccessor beeEntityAccessor) {
        this.beeEntity = beeEntity;
        this.beeEntityAccessor = beeEntityAccessor;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.beeEntityAccessor.getTicksUntilCanPollinate() > 0) {
            return false;
        }
        if (this.beeEntity.m_21660_()) {
            return false;
        }
        if (this.beeEntity.m_27856_()) {
            return false;
        }
        if (this.beeEntity.f_19853_.m_46471_()) {
            return false;
        }
        if (RandomGenerator.generateRandomFloat() < 0.5f) {
            return false;
        }
        if (this.beeEntity.f_27699_.m_28086_()) {
            return false;
        }
        MoobloomEntity moobloom = this.findMoobloom();
        if (moobloom == null) {
            return false;
        }
        this.moobloom = moobloom;
        Vec3 moobloomPollinationPos = this.getMoobloomPollinationPos();
        this.beeEntity.m_21573_().m_26519_(moobloomPollinationPos.m_7096_(), moobloomPollinationPos.m_7098_(), moobloomPollinationPos.m_7094_(), (double)1.2f);
        return true;
    }

    public boolean m_8045_() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.beeEntity.m_21660_()) {
            return false;
        }
        if (this.beeEntity.m_20193_().m_46471_()) {
            return false;
        }
        if (this.completedPollination()) {
            return this.beeEntity.m_21187_().nextFloat() < 0.2f;
        }
        if (this.getMoobloom() == null) {
            return false;
        }
        return this.moobloom.m_6084_();
    }

    public void m_8056_() {
        this.pollinationTicks = 0;
        this.ticks = 0;
        this.lastPollinationTick = 0;
        this.setIsRunning(true);
        this.beeEntity.m_27853_();
    }

    public void cancel() {
        this.setIsRunning(false);
    }

    public void m_8041_() {
        if (this.completedPollination()) {
            this.pollinate();
            this.beeEntityAccessor.invokeSetHasNectar(true);
        }
        this.setIsRunning(false);
        this.beeEntity.m_21573_().m_26573_();
        this.beeEntityAccessor.setTicksUntilCanPollinate(200);
    }

    public void m_8037_() {
        ++this.ticks;
        if (this.ticks > 600) {
            this.setMoobloom(null);
            return;
        }
        Vec3 moobloomPollinationPos = this.getMoobloomPollinationPos();
        double dinstanceToMoobloom = this.beeEntity.m_20182_().m_82554_(moobloomPollinationPos);
        if (dinstanceToMoobloom >= 0.5) {
            this.beeEntity.m_21566_().m_6849_(moobloomPollinationPos.m_7096_(), moobloomPollinationPos.m_7098_(), moobloomPollinationPos.m_7094_(), 0.9);
            this.beeEntity.m_21563_().m_24946_(moobloomPollinationPos.m_7096_(), this.getMoobloom().m_20186_(), moobloomPollinationPos.m_7094_());
        }
        if (dinstanceToMoobloom <= 1.5) {
            ++this.pollinationTicks;
            if (this.beeEntity.m_21187_().nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                this.lastPollinationTick = this.pollinationTicks;
                this.beeEntity.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
            }
        }
    }

    private void pollinate() {
        for (int i = 0; i < 7; ++i) {
            double d = this.beeEntity.m_21187_().nextGaussian() * 0.02;
            double e = this.beeEntity.m_21187_().nextGaussian() * 0.02;
            double f = this.beeEntity.m_21187_().nextGaussian() * 0.02;
            ((ServerLevel)this.beeEntity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.beeEntity.m_20208_(1.0), this.beeEntity.m_20187_() + 0.5, this.beeEntity.m_20262_(1.0), 1, d, e, f, 1.0);
        }
    }

    @Nullable
    private MoobloomEntity findMoobloom() {
        List moobloomEntities = this.beeEntity.f_19853_.m_45971_(MoobloomEntity.class, this.VALID_MOOBLOOM_PREDICATE, (LivingEntity)this.beeEntity, this.beeEntity.m_142469_().m_82400_(32.0));
        double d = Double.MAX_VALUE;
        MoobloomEntity closestMoobloomEntity = null;
        for (MoobloomEntity moobloomEntity : moobloomEntities) {
            if (moobloomEntity.m_6162_() || !(this.beeEntity.m_20280_((Entity)moobloomEntity) < d)) continue;
            closestMoobloomEntity = moobloomEntity;
            d = this.beeEntity.m_20280_((Entity)moobloomEntity);
        }
        return closestMoobloomEntity;
    }

    private Vec3 getMoobloomPollinationPos() {
        double moobloomPollinationYPos = this.getMoobloom().m_20186_() + (double)this.getMoobloom().m_20206_() * 1.5;
        return new Vec3(this.getMoobloom().m_20185_(), moobloomPollinationYPos, this.getMoobloom().m_20189_());
    }

    private boolean completedPollination() {
        return this.pollinationTicks > 200;
    }

    private boolean isRunning() {
        return this.running;
    }

    private void setIsRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public MoobloomEntity getMoobloom() {
        return this.moobloom;
    }

    public void setMoobloom(MoobloomEntity moobloomEntity) {
        this.moobloom = moobloomEntity;
    }
}

