/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.config;

import com.faboslav.friendsandfoes.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.config.annotation.Category;
import com.faboslav.friendsandfoes.config.annotation.Description;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public final class ConfigScreenBuilder {
    public static Screen createConfigScreen(FriendsAndFoesConfig config, Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setTitle((Component)new TextComponent("Friends&Foes")).setSavingRunnable(config::save).setParentScreen(parent);
        ConfigCategory category = null;
        try {
            for (Field field : config.getClass().getDeclaredFields()) {
                String categoryString = ConfigScreenBuilder.getFieldCategory(field);
                if (categoryString != null) {
                    category = builder.getOrCreateCategory((Component)new TextComponent(ConfigScreenBuilder.getFieldCategory(field)));
                }
                if (category == null) {
                    throw new RuntimeException("Missing category annotation.");
                }
                if (field.getGenericType() == Boolean.TYPE) {
                    category.addEntry((AbstractConfigListEntry)builder.entryBuilder().startBooleanToggle((Component)new TextComponent(ConfigScreenBuilder.getFieldDescription(field)), field.getBoolean(config)).setDefaultValue(field.getBoolean(new FriendsAndFoesConfig())).setSaveConsumer(enabled -> {
                        try {
                            field.set(config, enabled);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }).build());
                    continue;
                }
                if (field.getGenericType() != Integer.TYPE) continue;
                category.addEntry((AbstractConfigListEntry)builder.entryBuilder().startIntField((Component)new TextComponent(ConfigScreenBuilder.getFieldDescription(field)), field.getInt(config)).setDefaultValue(field.getInt(new FriendsAndFoesConfig())).setSaveConsumer(enabled -> {
                    try {
                        field.set(config, enabled);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }).build());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return builder.build();
    }

    @Nullable
    private static String getFieldCategory(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Category)) continue;
            return ((Category)annotation).value();
        }
        return null;
    }

    private static String getFieldDescription(Field field) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Description)) continue;
            return ((Description)annotation).value();
        }
        throw new RuntimeException("Field " + field.getName() + " is missing description annotation.");
    }
}

