/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.model;

import com.faboslav.friendsandfoes.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.MaulerEntity;
import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MaulerEntityModel<T extends MaulerEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_ROOT = "root";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_UPPER_JAW = "upperJaw";
    private static final String MODEL_PART_LOWER_JAW = "lowerJaw";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_FRONT_LEFT_LEG = "frontLeftLeg";
    private static final String MODEL_PART_FRONT_RIGHT_LEG = "frontRightLeg";
    private static final String MODEL_PART_BACK_LEFT_LEG = "backLeftLeg";
    private static final String MODEL_PART_BACK_RIGHT_LEG = "backRightLeg";
    private final ModelPart head;
    private final ModelPart upperJaw;
    private final ModelPart lowerJaw;
    private final ModelPart body;
    private final ModelPart frontLeftLeg;
    private final ModelPart frontRightLeg;
    private final ModelPart backLeftLeg;
    private final ModelPart backRightLeg;

    public MaulerEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.m_171324_(MODEL_PART_HEAD);
        this.upperJaw = this.head.m_171324_(MODEL_PART_UPPER_JAW);
        this.lowerJaw = this.head.m_171324_(MODEL_PART_LOWER_JAW);
        this.body = this.root.m_171324_(MODEL_PART_BODY);
        this.frontLeftLeg = this.root.m_171324_(MODEL_PART_FRONT_LEFT_LEG);
        this.frontRightLeg = this.root.m_171324_(MODEL_PART_FRONT_RIGHT_LEG);
        this.backLeftLeg = this.root.m_171324_(MODEL_PART_BACK_LEFT_LEG);
        this.backRightLeg = this.root.m_171324_(MODEL_PART_BACK_RIGHT_LEG);
        this.setCurrentModelTransforms(MODEL_PART_ROOT, this.root);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        root.m_171599_(MODEL_PART_HEAD, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition head = root.m_171597_(MODEL_PART_HEAD);
        head.m_171599_(MODEL_PART_UPPER_JAW, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.5f, -3.0f, -10.0f, 9.0f, 3.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        head.m_171599_(MODEL_PART_LOWER_JAW, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-4.5f, 0.0f, -10.0f, 9.0f, 3.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        root.m_171599_(MODEL_PART_BODY, CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-3.5f, 0.0f, -3.0f, 7.0f, 2.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)1.0f));
        root.m_171599_(MODEL_PART_FRONT_LEFT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 5).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)2.5f, (float)21.0f, (float)-1.0f));
        root.m_171599_(MODEL_PART_FRONT_RIGHT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)-2.5f, (float)21.0f, (float)-1.0f));
        root.m_171599_(MODEL_PART_BACK_LEFT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)2.5f, (float)21.0f, (float)3.0f));
        root.m_171599_(MODEL_PART_BACK_RIGHT_LEG, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.m_171419_((float)-2.5f, (float)21.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T mauler, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.applyModelTransforms(MODEL_PART_ROOT, this.root);
        this.modelAnimator.setEntity((AnimatedEntity)mauler);
        float burrowingDownAnimationProgress = ((MaulerEntity)mauler).getBurrowingDownAnimationProgress();
        float maulerHeightWithOffset = 10.0f;
        if (burrowingDownAnimationProgress > 0.0f && burrowingDownAnimationProgress < 1.0f) {
            float targetY = maulerHeightWithOffset * burrowingDownAnimationProgress;
            this.modelAnimator.animateYPositionWithProgress(this.root, targetY, AnimationMath.absSin(animationProgress));
            return;
        }
        if (((MaulerEntity)mauler).getBurrowingDownAnimationProgress() == 1.0f) {
            this.root.f_104201_ = maulerHeightWithOffset;
            return;
        }
        this.head.f_104203_ = headPitch * 0.005f;
        float baseSpeed = mauler.m_21660_() ? 14.0f : 10.0f;
        float jumpHeight = mauler.m_21660_() ? -4.5f : -2.5f;
        this.root.f_104201_ = jumpHeight * Math.abs(Mth.m_14156_((float)limbAngle, (float)baseSpeed) * limbDistance);
        float legPitch = Mth.m_14156_((float)limbAngle, (float)baseSpeed) * limbDistance;
        float frontLegPitch = -1.5f * legPitch;
        float backLegPitch = 1.5f * legPitch;
        this.frontLeftLeg.f_104203_ = frontLegPitch;
        this.frontRightLeg.f_104203_ = frontLegPitch;
        this.backLeftLeg.f_104203_ = backLegPitch;
        this.backRightLeg.f_104203_ = backLegPitch;
        if (mauler.m_21660_() && !((MaulerEntity)mauler).isBurrowedDown() && ((MaulerEntity)mauler).isMoving() && mauler.m_20096_() && mauler.m_20184_().m_7098_() <= 1.0E-4) {
            float targetX = AnimationMath.toRadians(5.0) + AnimationMath.toRadians(-65.0) * AnimationMath.absSin(animationProgress, 1.0f, 0.35f);
            float delta = AnimationMath.absSin(animationProgress);
            this.modelAnimator.animateXRotationWithProgress(this.upperJaw, targetX, delta);
            this.modelAnimator.animateXRotationOverTicks(this.lowerJaw, AnimationMath.toRadians(-5.0), 10);
        } else {
            this.modelAnimator.animateXRotationOverTicks(this.upperJaw, 0.0f, 10);
            this.modelAnimator.animateXRotationOverTicks(this.lowerJaw, 0.0f, 10);
        }
    }
}

