/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.worldGen.structures;

import com.BrassAmber.ba_bt.BattleTowersConfig;
import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.util.BTStatics;
import com.BrassAmber.ba_bt.util.BTUtil;
import com.BrassAmber.ba_bt.util.GolemType;
import com.BrassAmber.ba_bt.util.SaveTowers;
import com.BrassAmber.ba_bt.worldGen.BTOceanJigsawPlacement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class OceanBattleTower
extends StructureFeature<JigsawConfiguration> {
    public static final Codec<JigsawConfiguration> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)40).fieldOf("size").forGetter(JigsawConfiguration::m_67765_)).apply((Applicative)codec, JigsawConfiguration::new));

    public OceanBattleTower() {
        super(CODEC, OceanBattleTower::createPiecesGenerator, OceanBattleTower::afterPlace);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static BlockPos isSpawnableChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context, ChunkPos chunkPos, ChunkGenerator chunkGen) {
        int seaLevel = chunkGen.m_6337_();
        Predicate predicate = context.f_197358_();
        if (chunkGen.m_212265_(BuiltinStructureSets.f_209826_, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, 6)) {
            return BlockPos.f_121853_;
        }
        ArrayList<ChunkPos> testable = new ArrayList<ChunkPos>(List.of(new ChunkPos(chunkPos.f_45578_ + 4, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ + 4), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ + 4), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ - 4, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ - 4, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ - 4), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ - 4), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ + 4, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_ + 3), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ + 2), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_ - 3, chunkPos.f_45579_ - 1), new ChunkPos(chunkPos.f_45578_ - 2, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_ - 3), new ChunkPos(chunkPos.f_45578_ + 2, chunkPos.f_45579_ - 2), new ChunkPos(chunkPos.f_45578_ + 3, chunkPos.f_45579_ - 1)));
        for (ChunkPos pos : testable) {
            Holder biome = chunkGen.m_203495_(QuartPos.m_175400_((int)pos.m_151390_()), QuartPos.m_175400_((int)seaLevel), QuartPos.m_175400_((int)pos.m_151393_()));
            if (predicate.test(biome)) continue;
            return BlockPos.f_121853_;
        }
        return chunkPos.m_151394_(seaLevel - 12);
    }

    @NotNull
    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        boolean firstTowerDistanceCheck;
        Predicate predicate = context.f_197358_();
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator chunkGen = context.f_197352_();
        BlockPos chunkCenter = chunkPos.m_151394_(0);
        int x = chunkCenter.m_123341_();
        int z = chunkCenter.m_123343_();
        int y = chunkGen.m_156174_(chunkCenter.m_123341_(), chunkCenter.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        Holder biome = chunkGen.m_203495_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z));
        if (!predicate.test(biome)) {
            return Optional.empty();
        }
        int firstTowerDistance = (Integer)BattleTowersConfig.firstTowerDistance.get();
        int minimumSeparation = (Integer)BattleTowersConfig.oceanMinimumSeperation.get();
        int seperationRange = (Integer)BattleTowersConfig.oceanAverageSeperationModifier.get();
        boolean bl = firstTowerDistanceCheck = BTUtil.chunkDistanceTo(ChunkPos.f_186419_, chunkPos) >= firstTowerDistance;
        if (!firstTowerDistanceCheck) {
            return Optional.empty();
        }
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_);
        int nextSeperation = minimumSeparation + worldgenRandom.nextInt(seperationRange * 2);
        int closestDistance = 2000;
        if (!SaveTowers.towers.get(1).isEmpty()) {
            for (ChunkPos towerPos : SaveTowers.towers.get(1)) {
                int distance = BTUtil.chunkDistanceTo(chunkPos, towerPos);
                closestDistance = Math.min(closestDistance, distance);
            }
        }
        if (closestDistance <= nextSeperation) {
            return Optional.empty();
        }
        BlockPos spawnPos = OceanBattleTower.isSpawnableChunk(context, chunkPos, chunkGen);
        if (spawnPos.m_123342_() != 0) {
            Optional<PieceGenerator<JigsawConfiguration>> piecesGenerator = BTOceanJigsawPlacement.addPieces(context, PoolElementStructurePiece::new, spawnPos);
            if (piecesGenerator.isPresent()) {
                BrassAmberBattleTowers.LOGGER.info("Ocean Tower at " + spawnPos);
                BrassAmberBattleTowers.SAVETOWERS.addTower(chunkPos, "Ocean_Towers");
            }
            return piecesGenerator;
        }
        return Optional.empty();
    }

    public static void afterPlace(WorldGenLevel worldGenLevel, StructureFeatureManager featureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        BoundingBox boundingbox = piecesContainer.m_192756_();
        int bbYStart = boundingbox.m_162396_();
        List<Block> towerBlocks = BTStatics.towerBlocks.get(GolemType.getNumForType(GolemType.OCEAN));
        BlockPos chunckCenter = chunkPos.m_151394_(bbYStart);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.m_142448_(bbYStart);
        int startX = chunckCenter.m_123341_() - 8;
        int endX = chunckCenter.m_123341_() + 8;
        int startZ = chunckCenter.m_123343_() - 8;
        int endZ = chunckCenter.m_123343_() + 8;
        ArrayList<BlockPos> startPositions = new ArrayList<BlockPos>();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                blockpos$mutableblockpos.m_122178_(x, bbYStart, z);
                if (!towerBlocks.contains(worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_())) continue;
                startPositions.add(new BlockPos(x, bbYStart - 1, z));
            }
        }
        block2: for (BlockPos startPos : startPositions) {
            for (int y = startPos.m_123342_(); y > worldGenLevel.m_141937_(); --y) {
                blockpos$mutableblockpos.m_122178_(startPos.m_123341_(), y, startPos.m_123343_());
                if (!(worldGenLevel.m_46859_((BlockPos)blockpos$mutableblockpos) || worldGenLevel.m_46801_((BlockPos)blockpos$mutableblockpos) || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof SeagrassBlock || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof TallSeagrassBlock)) {
                    worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50378_.m_49966_(), 2);
                    worldGenLevel.m_7731_(blockpos$mutableblockpos.m_7495_(), Blocks.f_50378_.m_49966_(), 2);
                    continue block2;
                }
                worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50378_.m_49966_(), 2);
            }
        }
    }
}

