/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.worldGen.structures;

import com.BrassAmber.ba_bt.BattleTowersConfig;
import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.util.BTStatics;
import com.BrassAmber.ba_bt.util.BTTags;
import com.BrassAmber.ba_bt.util.BTUtil;
import com.BrassAmber.ba_bt.util.SaveTowers;
import com.BrassAmber.ba_bt.worldGen.BTLandJigsawPlacement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DeadBushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

public class LandBattleTower
extends StructureFeature<JigsawConfiguration> {
    private static boolean watered;
    public static final Codec<JigsawConfiguration> CODEC;

    public LandBattleTower() {
        super(CODEC, LandBattleTower::createPiecesGenerator, LandBattleTower::afterPlace);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static BlockPos isSpawnableChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context, int biomeType, WorldgenRandom worldgenRandom, ChunkPos chunkPos, ChunkGenerator chunkGen) {
        ArrayList<ResourceKey> vanillaStructures = new ArrayList<ResourceKey>();
        vanillaStructures.add(BuiltinStructureSets.f_209820_);
        vanillaStructures.add(BuiltinStructureSets.f_209821_);
        vanillaStructures.add(BuiltinStructureSets.f_209822_);
        vanillaStructures.add(BuiltinStructureSets.f_209823_);
        vanillaStructures.add(BuiltinStructureSets.f_209824_);
        vanillaStructures.add(BuiltinStructureSets.f_209825_);
        vanillaStructures.add(BuiltinStructureSets.f_209827_);
        vanillaStructures.add(BuiltinStructureSets.f_209830_);
        vanillaStructures.add(BuiltinStructureSets.f_209831_);
        for (ResourceKey set : vanillaStructures) {
            if (!chunkGen.m_212265_(set, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, 3)) continue;
            return BlockPos.f_121853_;
        }
        ArrayList<ChunkPos> testables = new ArrayList<ChunkPos>(List.of(chunkPos, new ChunkPos(chunkPos.f_45578_, chunkPos.f_45579_ + 1), new ChunkPos(chunkPos.f_45578_ + 1, chunkPos.f_45579_), new ChunkPos(chunkPos.f_45578_, chunkPos.f_45579_ - 1), new ChunkPos(chunkPos.f_45578_ - 1, chunkPos.f_45579_)));
        ArrayList<ChunkPos> usablePositions = new ArrayList<ChunkPos>();
        ArrayList<Integer> usableHeights = new ArrayList<Integer>();
        ArrayList<Boolean> hasWater = new ArrayList<Boolean>();
        for (ChunkPos pos : testables) {
            int middleHieght = chunkGen.m_156179_(pos.m_151390_(), pos.m_151393_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            Holder biome = chunkGen.m_203495_(QuartPos.m_175400_((int)pos.m_151390_()), QuartPos.m_175400_((int)middleHieght), QuartPos.m_175400_((int)pos.m_151393_()));
            int lowestY = 215;
            int highestY = 0;
            hasWater.clear();
            int minX = pos.m_45604_();
            int minZ = pos.m_45605_();
            for (int x = 0; x < 6; ++x) {
                for (int z = 0; z < 6; ++z) {
                    int newX = minX + x * 3;
                    int newZ = minZ + z * 3;
                    int newLandHeight = chunkGen.m_156179_(newX, newZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    lowestY = Math.min(newLandHeight, lowestY);
                    highestY = Math.max(newLandHeight, highestY);
                    NoiseColumn columnOfBlocks = chunkGen.m_141914_(newX, newZ, context.f_197357_());
                    BlockState topBlock = columnOfBlocks.m_183556_(newLandHeight);
                    if (topBlock != Blocks.f_49990_.m_49966_()) continue;
                    hasWater.add(Boolean.TRUE);
                }
            }
            if (highestY > 215) {
                BrassAmberBattleTowers.LOGGER.info("Terrain to high for Land Tower");
                return BlockPos.f_121853_;
            }
            boolean isFlat = highestY - lowestY <= 12;
            boolean bl = watered = hasWater.size() >= 16;
            if (watered && biomeType != 1) {
                return BlockPos.f_121853_;
            }
            int usableHeight = lowestY + (highestY - lowestY) / 4;
            boolean acceptableBiome = LandBattleTower.acceptableBiome((Holder<Biome>)biome, biomeType);
            if (!isFlat || !acceptableBiome) continue;
            usablePositions.add(pos);
            usableHeights.add(usableHeight);
        }
        if (usablePositions.size() > 0) {
            int index = worldgenRandom.nextInt(usablePositions.size());
            int landHeight = (Integer)usableHeights.get(index);
            return ((ChunkPos)usablePositions.get(index)).m_151394_(landHeight);
        }
        return BlockPos.f_121853_;
    }

    @NotNull
    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        boolean sandy;
        boolean firstTowerDistanceCheck;
        int firstTowerDistance = (Integer)BattleTowersConfig.firstTowerDistance.get();
        int minimumSeparation = (Integer)BattleTowersConfig.landMinimumSeperation.get();
        int seperationRange = (Integer)BattleTowersConfig.landAverageSeperationModifier.get();
        ChunkPos chunkPos = context.f_197355_();
        ChunkGenerator chunkGen = context.f_197352_();
        boolean bl = firstTowerDistanceCheck = BTUtil.chunkDistanceTo(ChunkPos.f_186419_, chunkPos) < firstTowerDistance;
        if (firstTowerDistanceCheck) {
            return Optional.empty();
        }
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource((long)chunkPos.f_45578_));
        worldgenRandom.m_190068_(context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_);
        int nextSeperation = minimumSeparation + worldgenRandom.nextInt(seperationRange * 2);
        int closestDistance = 2000;
        if (!SaveTowers.towers.get(0).isEmpty()) {
            for (ChunkPos towerPos : SaveTowers.towers.get(0)) {
                int distance = BTUtil.chunkDistanceTo(chunkPos, towerPos);
                closestDistance = Math.min(closestDistance, distance);
            }
        }
        if (closestDistance <= nextSeperation) {
            return Optional.empty();
        }
        BlockPos chunkCenter = chunkPos.m_151394_(0);
        int x = chunkCenter.m_123341_();
        int z = chunkCenter.m_123343_();
        int y = chunkGen.m_156174_(chunkCenter.m_123341_(), chunkCenter.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        Holder biome = chunkGen.m_203495_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z));
        ResourceLocation location = ((StructureTemplatePool)((JigsawConfiguration)context.f_197356_()).m_204802_().m_203334_()).m_210587_();
        int towerType = 0;
        towerType = location.m_135815_().equals(BrassAmberBattleTowers.locate("land_tower/start_pool_overgrown").m_135815_()) ? 1 : towerType;
        towerType = location.m_135815_().equals(BrassAmberBattleTowers.locate("land_tower/start_pool_sandy").m_135815_()) ? 2 : towerType;
        boolean acceptableBiome = LandBattleTower.acceptableBiome((Holder<Biome>)biome, towerType);
        if (!acceptableBiome) {
            return Optional.empty();
        }
        BlockPos spawnPos = LandBattleTower.isSpawnableChunk(context, towerType, worldgenRandom, chunkPos, chunkGen);
        boolean bl2 = sandy = towerType == 2;
        if (spawnPos.m_123342_() != 0) {
            Optional<PieceGenerator<JigsawConfiguration>> piecesGenerator = BTLandJigsawPlacement.addPieces(context, PoolElementStructurePiece::new, spawnPos, watered, sandy);
            if (piecesGenerator.isPresent()) {
                BrassAmberBattleTowers.LOGGER.info(BTStatics.landTowerNames.get(towerType) + " Tower at " + spawnPos);
                BrassAmberBattleTowers.SAVETOWERS.addTower(chunkPos, "Land_Towers");
            }
            return piecesGenerator;
        }
        return Optional.empty();
    }

    public static void afterPlace(WorldGenLevel worldGenLevel, StructureFeatureManager featureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        BoundingBox boundingbox = piecesContainer.m_192756_();
        int bbYStart = boundingbox.m_162396_();
        boundingbox.m_162394_();
        BlockPos chunckCenter = chunkPos.m_151394_(bbYStart);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.m_142448_(bbYStart);
        int startX = chunckCenter.m_123341_() - 8;
        int endX = chunckCenter.m_123341_() + 8;
        int startZ = chunckCenter.m_123343_() - 8;
        int endZ = chunckCenter.m_123343_() + 8;
        ArrayList<BlockPos> startPositions = new ArrayList<BlockPos>();
        List<BlockState> acceptableBlocks = List.of(Blocks.f_50222_.m_49966_(), Blocks.f_50224_.m_49966_(), Blocks.f_50223_.m_49966_(), Blocks.f_50225_.m_49966_());
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                blockpos$mutableblockpos.m_122178_(x, bbYStart, z);
                if (!acceptableBlocks.contains(worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos))) continue;
                startPositions.add(new BlockPos(x, bbYStart - 1, z));
            }
        }
        block2: for (BlockPos startPos : startPositions) {
            for (int y = startPos.m_123342_(); y > worldGenLevel.m_141937_(); --y) {
                blockpos$mutableblockpos.m_122178_(startPos.m_123341_(), y, startPos.m_123343_());
                if (!(worldGenLevel.m_46859_((BlockPos)blockpos$mutableblockpos) || worldGenLevel.m_46801_((BlockPos)blockpos$mutableblockpos) || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof TallGrassBlock || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof FlowerBlock || worldGenLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60734_() instanceof DeadBushBlock)) {
                    worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50222_.m_49966_(), 2);
                    worldGenLevel.m_7731_(blockpos$mutableblockpos.m_7495_(), Blocks.f_50222_.m_49966_(), 2);
                    continue block2;
                }
                worldGenLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50222_.m_49966_(), 2);
            }
        }
    }

    public static boolean acceptableBiome(Holder<Biome> biome, int towerType) {
        boolean acceptable = false;
        if (towerType == 0) {
            acceptable = BTTags.Biomes.LAND.test(biome);
        } else if (towerType == 1) {
            acceptable = BTTags.Biomes.LAND_OVERGROWN.test(biome);
        } else if (towerType == 2) {
            acceptable = BTTags.Biomes.LAND_SANDY.test(biome);
        }
        if (((Boolean)BattleTowersConfig.terralithBiomeSpawning.get()).booleanValue() && !acceptable) {
            if (towerType == 0) {
                acceptable = BTTags.Biomes.TERRA_LAND.test(biome);
            } else if (towerType == 1) {
                acceptable = BTTags.Biomes.TERRA_LAND_OVERGROWN.test(biome);
            } else if (towerType == 2) {
                acceptable = BTTags.Biomes.TERRA_LAND_SANDY.test(biome);
            }
        }
        if (((Boolean)BattleTowersConfig.biomesOfPlentyBiomeSpawning.get()).booleanValue() && !acceptable) {
            if (towerType == 0) {
                acceptable = BTTags.Biomes.BOP_LAND.test(biome);
            } else if (towerType == 1) {
                acceptable = BTTags.Biomes.BOP_LAND_OVERGROWN.test(biome);
            } else if (towerType == 2) {
                acceptable = BTTags.Biomes.BOP_LAND_SANDY.test(biome);
            }
        }
        if (((Boolean)BattleTowersConfig.biomesYoullGoBiomeSpawning.get()).booleanValue() && !acceptable) {
            if (towerType == 0) {
                acceptable = BTTags.Biomes.BYG_LAND.test(biome);
            } else if (towerType == 1) {
                acceptable = BTTags.Biomes.BYG_LAND_OVERGROWN.test(biome);
            } else if (towerType == 2) {
                acceptable = BTTags.Biomes.BYG_LAND_SANDY.test(biome);
            }
        }
        return acceptable;
    }

    static {
        CODEC = RecordCodecBuilder.create(codec -> codec.group((App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(JigsawConfiguration::m_204802_), (App)Codec.intRange((int)0, (int)40).fieldOf("size").forGetter(JigsawConfiguration::m_67765_)).apply((Applicative)codec, JigsawConfiguration::new));
    }
}

