/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.worldGen;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.Logger;

public class BTLandJigsawPlacement {
    private static final Logger LOGGER = BrassAmberBattleTowers.LOGGER;

    public static Optional<PieceGenerator<JigsawConfiguration>> addPieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context, PieceFactory pieceFactory, BlockPos blockPos, boolean isWatered, boolean isSandy) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        RegistryAccess registryaccess = context.f_197360_();
        JigsawConfiguration jigsawconfiguration = (JigsawConfiguration)context.f_197356_();
        ChunkGenerator chunkgenerator = context.f_197352_();
        StructureManager structuremanager = context.f_197359_();
        LevelHeightAccessor levelheightaccessor = context.f_197357_();
        StructureFeature.m_67096_();
        Registry registry = registryaccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)worldgenrandom);
        StructureTemplatePool structuretemplatepool = (StructureTemplatePool)jigsawconfiguration.m_204802_().m_203334_();
        StructurePoolElement structurepoolelement = structuretemplatepool.m_210585_((Random)worldgenrandom);
        if (structurepoolelement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece poolelementstructurepiece = pieceFactory.create(structuremanager, structurepoolelement, blockPos, structurepoolelement.m_210540_(), rotation, structurepoolelement.m_207470_(structuremanager, blockPos, rotation));
        BoundingBox boundingbox = poolelementstructurepiece.m_73547_();
        int i = (boundingbox.m_162399_() + boundingbox.m_162395_()) / 2;
        int j = (boundingbox.m_162401_() + boundingbox.m_162398_()) / 2;
        int heightChange = 0;
        if (isWatered) {
            heightChange = 5;
        }
        if (isSandy) {
            heightChange = worldgenrandom.nextInt(100) < 25 ? worldgenrandom.m_189320_(6, 12) : 5;
        }
        int k = blockPos.m_123342_() - heightChange;
        int l = boundingbox.m_162396_() + poolelementstructurepiece.m_72647_();
        poolelementstructurepiece.m_6324_(0, k - l, 0);
        return Optional.of((p_210282_, p_210283_) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolelementstructurepiece);
            if (jigsawconfiguration.m_67765_() > 0) {
                int i1 = 120;
                AABB aabb = new AABB((double)(i - i1), (double)(k - i1), (double)(j - i1), (double)(i + i1 + 1), (double)(k + i1 + 1), (double)(j + i1 + 1));
                Placer jigsawplacement$placer = new Placer((Registry<StructureTemplatePool>)registry, jigsawconfiguration.m_67765_(), pieceFactory, chunkgenerator, structuremanager, list, (Random)worldgenrandom);
                jigsawplacement$placer.placing.addLast(new PieceState(poolelementstructurepiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aabb), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)), (BooleanOp)BooleanOp.f_82685_)), 0));
                while (!jigsawplacement$placer.placing.isEmpty()) {
                    PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
                    jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, levelheightaccessor);
                }
                list.forEach(arg_0 -> ((StructurePiecesBuilder)p_210282_).m_142679_(arg_0));
            }
        });
    }

    public static void addPieces(RegistryAccess registryAccess, PoolElementStructurePiece structurePiece, int maxDepth, PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> pieces, Random random, LevelHeightAccessor heightAccessor) {
        Registry registry = registryAccess.m_175515_(Registry.f_122884_);
        Placer jigsawplacement$placer = new Placer((Registry<StructureTemplatePool>)registry, maxDepth, pieceFactory, chunkGenerator, structureManager, pieces, random);
        jigsawplacement$placer.placing.addLast(new PieceState(structurePiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.f_83036_), 0));
        while (!jigsawplacement$placer.placing.isEmpty()) {
            PieceState jigsawplacement$piecestate = jigsawplacement$placer.placing.removeFirst();
            jigsawplacement$placer.tryPlacingChildren(jigsawplacement$piecestate.piece, jigsawplacement$piecestate.free, jigsawplacement$piecestate.depth, heightAccessor);
        }
    }

    public static interface PieceFactory {
        public PoolElementStructurePiece create(StructureManager var1, StructurePoolElement var2, BlockPos var3, int var4, Rotation var5, BoundingBox var6);
    }

    static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final PieceFactory factory;
        private final ChunkGenerator chunkGenerator;
        private final StructureManager structureManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final Random random;
        final Deque<PieceState> placing = Queues.newArrayDeque();

        Placer(Registry<StructureTemplatePool> poolsIn, int maxDepth, PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> structurePieces, Random random) {
            this.pools = poolsIn;
            this.maxDepth = maxDepth;
            this.factory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.pieces = structurePieces;
            this.random = random;
        }

        void tryPlacingChildren(PoolElementStructurePiece structurePiece, MutableObject<VoxelShape> mutableObject, int currentDepth, LevelHeightAccessor heightAccessor) {
            StructurePoolElement structurepoolelement = structurePiece.m_209918_();
            BlockPos blockpos = structurePiece.m_72646_();
            Rotation rotation = structurePiece.m_6830_();
            StructureTemplatePool.Projection structuretemplatepool$projection = structurepoolelement.m_210539_();
            boolean startIsRigid = structuretemplatepool$projection == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox boundingbox = structurePiece.m_73547_();
            int bb_y = boundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo : structurepoolelement.m_207245_(this.structureManager, blockpos, rotation, this.random)) {
                Direction structureBlockFacing = JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_);
                BlockPos structureBlockPos = structuretemplate$structureblockinfo.f_74675_;
                BlockPos inFrontSBlockPos = structureBlockPos.m_142300_(structureBlockFacing);
                int sBlockRelativeY = structureBlockPos.m_123342_() - bb_y;
                int landHeight = -1;
                ResourceLocation poolLocation = new ResourceLocation(structuretemplate$structureblockinfo.f_74677_.m_128461_("pool"));
                Optional optional = this.pools.m_6612_(poolLocation);
                if (optional.isPresent() && (((StructureTemplatePool)optional.get()).m_210590_() != 0 || Objects.equals(poolLocation, Pools.f_127186_.m_135782_()))) {
                    ResourceLocation poolFallback = ((StructureTemplatePool)optional.get()).m_210573_();
                    Optional optional1 = this.pools.m_6612_(poolFallback);
                    if (optional1.isPresent() && (((StructureTemplatePool)optional1.get()).m_210590_() != 0 || Objects.equals(poolFallback, Pools.f_127186_.m_135782_()))) {
                        StructurePoolElement shuffledElement;
                        MutableObject<VoxelShape> mutableobject1;
                        boolean insideBBFlag = boundingbox.m_71051_((Vec3i)inFrontSBlockPos);
                        if (insideBBFlag) {
                            mutableobject1 = mutableobject;
                            if (mutableobject.getValue() == null) {
                                mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)boundingbox)));
                            }
                        } else {
                            mutableobject1 = mutableObject;
                        }
                        ArrayList shuffledElements = Lists.newArrayList();
                        if (currentDepth != this.maxDepth) {
                            shuffledElements.addAll(((StructureTemplatePool)optional.get()).m_210588_(this.random));
                        }
                        shuffledElements.addAll(((StructureTemplatePool)optional1.get()).m_210588_(this.random));
                        Iterator iterator = shuffledElements.iterator();
                        while (iterator.hasNext() && (shuffledElement = (StructurePoolElement)iterator.next()) != EmptyPoolElement.f_210175_) {
                            for (Rotation shuffledRotation : Rotation.m_55958_((Random)this.random)) {
                                List connectedElements = shuffledElement.m_207245_(this.structureManager, BlockPos.f_121853_, shuffledRotation, this.random);
                                BoundingBox shuffledElementBB = shuffledElement.m_207470_(this.structureManager, BlockPos.f_121853_, shuffledRotation);
                                for (StructureTemplate.StructureBlockInfo structuretemplate$structureblockinfo1 : connectedElements) {
                                    int newPieceY;
                                    int rigidAdjust;
                                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo, (StructureTemplate.StructureBlockInfo)structuretemplate$structureblockinfo1)) continue;
                                    BlockPos connectedSBlockPos = structuretemplate$structureblockinfo1.f_74675_;
                                    BlockPos connectedSInFront = inFrontSBlockPos.m_141950_((Vec3i)connectedSBlockPos);
                                    BoundingBox connectedBB = shuffledElement.m_207470_(this.structureManager, connectedSInFront, shuffledRotation);
                                    int connectedBBMinY = connectedBB.m_162396_();
                                    StructureTemplatePool.Projection structuretemplatepool$projection1 = shuffledElement.m_210539_();
                                    boolean connectedIsRigid = structuretemplatepool$projection1 == StructureTemplatePool.Projection.RIGID;
                                    int ConnectedSY = connectedSBlockPos.m_123342_();
                                    int sBlock2RelativeY = sBlockRelativeY - ConnectedSY + JigsawBlock.m_54250_((BlockState)structuretemplate$structureblockinfo.f_74676_).m_122430_();
                                    if (startIsRigid && connectedIsRigid) {
                                        rigidAdjust = bb_y + sBlock2RelativeY;
                                    } else {
                                        if (landHeight == -1) {
                                            landHeight = this.chunkGenerator.m_156174_(structureBlockPos.m_123341_(), structureBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
                                        }
                                        rigidAdjust = landHeight - ConnectedSY;
                                    }
                                    int distanceToNewY = rigidAdjust - connectedBBMinY;
                                    BoundingBox rigidAdjustBB = connectedBB.m_71045_(0, distanceToNewY, 0);
                                    BlockPos rigidAdjConnectedSInFront = connectedSInFront.m_142082_(0, distanceToNewY, 0);
                                    mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)rigidAdjustBB)), (BooleanOp)BooleanOp.f_82685_));
                                    int sLandHeight = structurePiece.m_72647_();
                                    int connectedSLandHeight = connectedIsRigid ? sLandHeight - sBlock2RelativeY : shuffledElement.m_210540_();
                                    PoolElementStructurePiece newPiece = this.factory.create(this.structureManager, shuffledElement, rigidAdjConnectedSInFront, connectedSLandHeight, shuffledRotation, rigidAdjustBB);
                                    if (startIsRigid) {
                                        newPieceY = bb_y + sBlockRelativeY;
                                    } else if (connectedIsRigid) {
                                        newPieceY = rigidAdjust + ConnectedSY;
                                    } else {
                                        if (landHeight == -1) {
                                            landHeight = this.chunkGenerator.m_156174_(structureBlockPos.m_123341_(), structureBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
                                        }
                                        newPieceY = landHeight + sBlock2RelativeY / 2;
                                    }
                                    structurePiece.m_209916_(new JigsawJunction(inFrontSBlockPos.m_123341_(), newPieceY - sBlockRelativeY + sLandHeight, inFrontSBlockPos.m_123343_(), sBlock2RelativeY, structuretemplatepool$projection1));
                                    newPiece.m_209916_(new JigsawJunction(structureBlockPos.m_123341_(), newPieceY - ConnectedSY + connectedSLandHeight, structureBlockPos.m_123343_(), -sBlock2RelativeY, structuretemplatepool$projection));
                                    this.pieces.add((PoolElementStructurePiece)newPiece);
                                    if (currentDepth + 1 > this.maxDepth) continue block0;
                                    this.placing.addLast(new PieceState(newPiece, mutableobject1, currentDepth + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)poolFallback);
                    continue;
                }
                LOGGER.warn("Empty or non-existent pool: {}", (Object)poolLocation);
            }
        }
    }

    static final class PieceState {
        final PoolElementStructurePiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        PieceState(PoolElementStructurePiece pieceIn, MutableObject<VoxelShape> freeIn, int depthIn) {
            this.piece = pieceIn;
            this.free = freeIn;
            this.depth = depthIn;
        }
    }
}

