/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.util;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.io.FileUtils;

public class SaveTowers {
    public static ArrayList<ChunkPos> landTowers = new ArrayList();
    public static ArrayList<ChunkPos> oceanTowers = new ArrayList();
    public static List<List<ChunkPos>> towers = List.of(landTowers, oceanTowers);
    public static List<String> towerNames = List.of("Land_Towers", "Ocean_Towers");
    public static MinecraftServer server;
    public static Path levelPath;

    public void setServer(MinecraftServer newServer) {
        server = newServer;
        towers.get(0).clear();
        towers.get(1).clear();
        this.getTowers();
    }

    public void serverClosed() {
        for (int i = 0; i < towerNames.size(); ++i) {
            String name = towerNames.get(i);
            File towerFile = levelPath.resolve(name).toFile();
            ArrayList<CallSite> towerStrings = new ArrayList<CallSite>();
            for (ChunkPos xz : towers.get(towerNames.indexOf(name))) {
                towerStrings.add((CallSite)((Object)(xz.f_45578_ + "," + xz.f_45579_)));
            }
            try {
                FileUtils.writeLines((File)towerFile, towerStrings);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void getTowers() {
        levelPath = SaveTowers.getOrCreateGameRelativePath(server.m_129843_(LevelResource.f_78182_).resolve("battletowers"), "battletowers");
        for (int i = 0; i < towerNames.size(); ++i) {
            Path towerPath = levelPath.resolve(towerNames.get(i));
            List<Object> lines = new ArrayList();
            try {
                lines = Files.readAllLines(towerPath, StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String line : lines) {
                String[] xz = line.split(",");
                towers.get(i).add(new ChunkPos(Integer.parseInt(xz[0]), Integer.parseInt(xz[1])));
            }
        }
    }

    public void addTower(ChunkPos pos, String name) {
        towers.get(towerNames.indexOf(name)).add(pos);
    }

    public static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            SaveTowers.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            BrassAmberBattleTowers.LOGGER.debug(LogMarkers.CORE, "Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    BrassAmberBattleTowers.LOGGER.fatal(LogMarkers.CORE, "Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    BrassAmberBattleTowers.LOGGER.fatal(LogMarkers.CORE, "Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)e);
                }
                throw new RuntimeException("Problem creating directory", e);
            }
            BrassAmberBattleTowers.LOGGER.debug(LogMarkers.CORE, "Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }

    public static Path getOrCreateGameRelativePath(Path path, String name) {
        return SaveTowers.getOrCreateDirectory(FMLPaths.GAMEDIR.get().resolve(path), name);
    }

    static {
        levelPath = Path.of("", new String[0]);
    }
}

