/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.util;

import com.BrassAmber.ba_bt.entity.LandDestructionEntity;
import com.BrassAmber.ba_bt.entity.OceanDestructionEntity;
import com.BrassAmber.ba_bt.entity.block.BTAbstractObelisk;
import com.BrassAmber.ba_bt.entity.block.BTMonolith;
import com.BrassAmber.ba_bt.entity.hostile.BTCultist;
import com.BrassAmber.ba_bt.entity.hostile.PlatinumSkeleton;
import com.BrassAmber.ba_bt.init.BTEntityTypes;
import com.BrassAmber.ba_bt.init.BTItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public enum GolemType implements StringRepresentable
{
    EMPTY("empty", (Component)new TextComponent("Empty")),
    LAND("land", (Component)new TranslatableComponent("entity.ba_bt.land_golem")),
    OCEAN("ocean", (Component)new TranslatableComponent("entity.ba_bt.ocean_golem")),
    CORE("core", (Component)new TranslatableComponent("entity.ba_bt.core_golem")),
    NETHER("nether", (Component)new TranslatableComponent("entity.ba_bt.nether_golem")),
    END("end", (Component)new TranslatableComponent("entity.ba_bt.end_golem")),
    SKY("sky", (Component)new TranslatableComponent("entity.ba_bt.sky_golem")),
    CITY("city", (Component)new TextComponent("~"));

    private final String name;
    private final Component displayName;

    private GolemType(String name, Component displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    @NotNull
    public static EntityType<?> getGolemFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY, LAND -> (EntityType)BTEntityTypes.LAND_GOLEM.get();
            case OCEAN -> (EntityType)BTEntityTypes.OCEAN_GOLEM.get();
            case CORE -> (EntityType)BTEntityTypes.CORE_GOLEM.get();
            case NETHER -> (EntityType)BTEntityTypes.NETHER_GOLEM.get();
            case END -> (EntityType)BTEntityTypes.END_GOLEM.get();
            case SKY -> (EntityType)BTEntityTypes.SKY_GOLEM.get();
        };
    }

    @NotNull
    public static EntityType<BTMonolith> getMonolithFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY, LAND -> (EntityType)BTEntityTypes.LAND_MONOLITH.get();
            case OCEAN -> (EntityType)BTEntityTypes.OCEAN_MONOLITH.get();
            case CORE -> (EntityType)BTEntityTypes.CORE_MONOLITH.get();
            case NETHER -> (EntityType)BTEntityTypes.NETHER_MONOLITH.get();
            case END -> (EntityType)BTEntityTypes.END_MONOLITH.get();
            case SKY -> (EntityType)BTEntityTypes.SKY_MONOLITH.get();
        };
    }

    @NotNull
    public static EntityType<BTAbstractObelisk> getObeliskFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY, LAND -> (EntityType)BTEntityTypes.LAND_OBELISK.get();
            case OCEAN -> (EntityType)BTEntityTypes.OCEAN_OBELISK.get();
            case CORE -> (EntityType)BTEntityTypes.CORE_OBELISK.get();
            case NETHER -> (EntityType)BTEntityTypes.NETHER_OBELISK.get();
            case END -> (EntityType)BTEntityTypes.END_OBELISK.get();
            case SKY -> (EntityType)BTEntityTypes.SKY_OBELISK.get();
        };
    }

    @Nullable
    public static Item getMonolithItemFor(GolemType golemType) {
        return switch (golemType) {
            default -> null;
            case LAND -> (Item)BTItems.LAND_MONOLITH.get();
            case OCEAN -> (Item)BTItems.OCEAN_MONOLITH.get();
            case CORE -> (Item)BTItems.CORE_MONOLITH.get();
            case NETHER -> (Item)BTItems.NETHER_MONOLITH.get();
            case END -> (Item)BTItems.END_MONOLITH.get();
            case SKY -> (Item)BTItems.SKY_MONOLITH.get();
        };
    }

    public static GolemType getTypeForMonolith(BTMonolith BTMonolithEntity) {
        EntityType<?> entityType = BTMonolithEntity.getMonolithType();
        if (entityType != null) {
            if (entityType.equals(BTEntityTypes.LAND_MONOLITH.get())) {
                return LAND;
            }
            if (entityType.equals(BTEntityTypes.OCEAN_MONOLITH.get())) {
                return OCEAN;
            }
            if (entityType.equals(BTEntityTypes.CORE_MONOLITH.get())) {
                return CORE;
            }
            if (entityType.equals(BTEntityTypes.NETHER_MONOLITH.get())) {
                return NETHER;
            }
            if (entityType.equals(BTEntityTypes.END_MONOLITH.get())) {
                return END;
            }
            if (entityType.equals(BTEntityTypes.SKY_MONOLITH.get())) {
                return SKY;
            }
        }
        return EMPTY;
    }

    @Nullable
    public static Item getEyeFor(GolemType golemType) {
        return switch (golemType) {
            default -> throw new IncompatibleClassChangeError();
            case EMPTY, CITY -> null;
            case LAND -> (Item)BTItems.LAND_GUARDIAN_EYE.get();
            case OCEAN -> (Item)BTItems.OCEAN_GUARDIAN_EYE.get();
            case CORE -> (Item)BTItems.CORE_GUARDIAN_EYE.get();
            case NETHER -> (Item)BTItems.NETHER_GUARDIAN_EYE.get();
            case END -> (Item)BTItems.END_GUARDIAN_EYE.get();
            case SKY -> (Item)BTItems.SKY_GUARDIAN_EYE.get();
        };
    }

    @Nullable
    public static GolemType getPreviousGolemType(GolemType golemType) {
        return switch (golemType) {
            default -> null;
            case EMPTY, LAND -> EMPTY;
            case OCEAN -> LAND;
            case CORE -> OCEAN;
            case NETHER -> CORE;
            case END -> NETHER;
            case SKY -> END;
        };
    }

    @Nullable
    public static Item getKeyFor(GolemType golemType) {
        return switch (golemType) {
            default -> null;
            case LAND -> (Item)BTItems.LAND_MONOLOITH_KEY.get();
            case OCEAN -> (Item)BTItems.OCEAN_MONOLOITH_KEY.get();
            case CORE -> (Item)BTItems.CORE_MONOLOITH_KEY.get();
            case NETHER -> (Item)BTItems.NETHER_MONOLOITH_KEY.get();
            case END -> (Item)BTItems.END_MONOLOITH_KEY.get();
            case SKY -> (Item)BTItems.SKY_MONOLOITH_KEY.get();
        };
    }

    public static GolemType getTypeForName(String name) {
        return switch (name) {
            default -> null;
            case "land" -> LAND;
            case "ocean" -> OCEAN;
            case "core" -> CORE;
            case "nether" -> NETHER;
            case "end" -> END;
            case "sky" -> SKY;
            case "city" -> CITY;
        };
    }

    public static Entity getDestructionEntity(GolemType golemType, Level level, BlockPos blockPos) {
        Entity destruction = null;
        switch (golemType) {
            default: {
                break;
            }
            case LAND: {
                destruction = new LandDestructionEntity(blockPos, level);
                blockPos = blockPos.m_6630_(6);
                break;
            }
            case OCEAN: {
                destruction = new OceanDestructionEntity(level);
                blockPos = blockPos.m_175288_(level.m_5736_() - 88);
            }
        }
        if (destruction != null) {
            destruction.m_6034_((double)blockPos.m_123341_() + 0.25, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.25);
        }
        return destruction;
    }

    public static Entity getSpecialEnemy(GolemType golemType, ServerLevel serverLevel) {
        return switch (golemType) {
            default -> null;
            case LAND -> (BTCultist)((EntityType)BTEntityTypes.BT_CULTIST.get()).m_20615_((Level)serverLevel);
            case OCEAN -> (Guardian)EntityType.f_20455_.m_20615_((Level)serverLevel);
            case CORE -> (MagmaCube)EntityType.f_20468_.m_20615_((Level)serverLevel);
            case NETHER -> (WitherSkeleton)EntityType.f_20497_.m_20615_((Level)serverLevel);
            case END -> (EnderMan)EntityType.f_20566_.m_20615_((Level)serverLevel);
            case SKY -> (PlatinumSkeleton)((EntityType)BTEntityTypes.PLATINUM_SKELETON.get()).m_20615_((Level)serverLevel);
        };
    }

    public static EntityType<?> getSpecialEnemyType(GolemType golemType) {
        return switch (golemType) {
            default -> null;
            case LAND -> (EntityType)BTEntityTypes.BT_CULTIST.get();
            case OCEAN -> EntityType.f_20455_;
            case CORE -> EntityType.f_20468_;
            case NETHER -> EntityType.f_20497_;
            case END -> EntityType.f_20566_;
            case SKY -> (EntityType)BTEntityTypes.PLATINUM_SKELETON.get();
        };
    }

    public static Class<? extends Entity> getSpecialEnemyClass(GolemType golemType) {
        return switch (golemType) {
            default -> null;
            case LAND -> BTCultist.class;
            case OCEAN -> Guardian.class;
            case CORE -> MagmaCube.class;
            case NETHER -> WitherSkeleton.class;
            case END -> EnderMan.class;
            case SKY -> PlatinumSkeleton.class;
        };
    }

    public static Integer getNumForType(GolemType golemType) {
        return switch (golemType) {
            default -> null;
            case LAND -> 0;
            case OCEAN -> 1;
            case CORE -> 2;
            case NETHER -> 3;
            case END -> 4;
            case SKY -> 5;
            case CITY -> 6;
        };
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public Component getDisplayName() {
        return this.displayName;
    }
}

