/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.util;

import com.BrassAmber.ba_bt.init.BTBlockEntityTypes;
import com.BrassAmber.ba_bt.init.BTBlocks;
import com.BrassAmber.ba_bt.sound.BTSoundEvents;
import com.BrassAmber.ba_bt.util.GolemType;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class BTUtil {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Supplier<SoundEvent> getTowerMusic(GolemType type) {
        return switch (type) {
            case GolemType.OCEAN -> () -> BTSoundEvents.MUSIC_OCEAN_TOWER;
            case GolemType.CORE -> () -> BTSoundEvents.MUSIC_CORE_TOWER;
            case GolemType.NETHER -> () -> BTSoundEvents.MUSIC_NETHER_TOWER;
            case GolemType.END -> () -> BTSoundEvents.MUSIC_END_TOWER;
            case GolemType.SKY -> () -> BTSoundEvents.MUSIC_SKY_TOWER;
            case GolemType.CITY -> () -> BTSoundEvents.MUSIC_CITY;
            default -> () -> BTSoundEvents.MUSIC_LAND_TOWER;
        };
    }

    @NotNull
    public static BlockEntityType<? extends ChestBlockEntity> getChestEntity(Block block) {
        if (((Block)BTBlocks.LAND_CHEST.get()).equals(block)) {
            return (BlockEntityType)BTBlockEntityTypes.LAND_CHEST.get();
        }
        if (((Block)BTBlocks.LAND_GOLEM_CHEST.get()).equals(block)) {
            return (BlockEntityType)BTBlockEntityTypes.LAND_GOLEM_CHEST.get();
        }
        if (((Block)BTBlocks.OCEAN_CHEST.get()).equals(block)) {
            return (BlockEntityType)BTBlockEntityTypes.OCEAN_CHEST.get();
        }
        if (((Block)BTBlocks.OCEAN_GOLEM_CHEST.get()).equals(block)) {
            return (BlockEntityType)BTBlockEntityTypes.OCEAN_GOLEM_CHEST.get();
        }
        return (BlockEntityType)BTBlockEntityTypes.LAND_CHEST.get();
    }

    @NotNull
    public static String getTowerName(BlockEntityType<? extends ChestBlockEntity> block) {
        if (((BlockEntityType)BTBlockEntityTypes.LAND_GOLEM_CHEST.get()).equals(block) || ((BlockEntityType)BTBlockEntityTypes.LAND_CHEST.get()).equals(block)) {
            return "land";
        }
        if (((BlockEntityType)BTBlockEntityTypes.OCEAN_CHEST.get()).equals(block) || ((BlockEntityType)BTBlockEntityTypes.OCEAN_GOLEM_CHEST.get()).equals(block)) {
            return "ocean";
        }
        return "land";
    }

    public static Item itemByString(String id) {
        return (Item)ForgeRegistries.ITEMS.getHolder(ResourceLocation.m_135820_((String)id)).orElseGet(() -> Holder.m_205709_((Object)Items.f_42329_)).m_203334_();
    }

    public static int median(ArrayList<Integer> nums) {
        Collections.sort(nums);
        if (nums.size() % 2 == 1) {
            return nums.get((nums.size() + 1) / 2 - 1);
        }
        double lower = nums.get(nums.size() / 2 - 1).intValue();
        double upper = nums.get(nums.size() / 2).intValue();
        return (int)((lower + upper) / 2.0);
    }

    public static double sqrDistanceTo2D(Entity self, double targetX, double targetZ) {
        double dX = self.m_20185_() - targetX;
        double dZ = self.m_20189_() - targetZ;
        return Math.abs(dX * dX + dZ * dZ);
    }

    public static double sqrDistanceTo2D(Entity self, Entity target) {
        double dX = self.m_20185_() - target.m_20185_();
        double dZ = self.m_20189_() - target.m_20189_();
        return Math.abs(dX * dX + dZ * dZ);
    }

    public static int chunkDistanceTo(ChunkPos start, ChunkPos end) {
        return Mth.m_14107_((double)BTUtil.distanceTo2D(start.f_45578_ - end.f_45578_, start.f_45579_ - end.f_45579_));
    }

    public static double distanceTo2D(Entity self, double targetX, double targetZ) {
        double dX = self.m_20185_() - targetX;
        double dZ = self.m_20189_() - targetZ;
        return Math.sqrt(Math.abs(dX * dX + dZ * dZ));
    }

    public static double distanceTo2D(Entity self, Entity entity) {
        double dX = Math.abs(self.m_20185_() - entity.m_20185_());
        double dZ = Math.abs(self.m_20189_() - entity.m_20189_());
        return Math.sqrt(dX * dX + dZ * dZ);
    }

    public static double distanceTo2D(Entity self, BlockPos end) {
        double dX = Math.abs(self.m_20185_() - (double)end.m_123341_());
        double dZ = Math.abs(self.m_20189_() - (double)end.m_123343_());
        return Math.sqrt(dX * dX + dZ * dZ);
    }

    public static double distanceTo2D(BlockPos origin, BlockPos end) {
        double dX = Math.abs(origin.m_123341_() - end.m_123341_());
        double dZ = Math.abs(origin.m_123343_() - end.m_123343_());
        return Math.sqrt(dX * dX + dZ * dZ);
    }

    public static double distanceTo2D(double side, double side2) {
        return Math.sqrt(side * side + side2 * side2);
    }

    public static double distanceTo3D(Entity self, double targetX, double targetY, double targetZ) {
        double dXZ = BTUtil.distanceTo2D(self, targetX, targetZ);
        double dY = self.m_20186_() - targetY;
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static double distanceTo3D(Entity self, Entity entity) {
        double dXZ = BTUtil.distanceTo2D(self, entity);
        double dY = self.m_20186_() - entity.m_20186_();
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static double distanceTo3D(Entity self, BlockPos end) {
        double dXZ = BTUtil.distanceTo2D(self, end);
        double dY = self.m_20186_() - (double)end.m_123342_();
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static double distanceTo3D(BlockPos origin, BlockPos end) {
        double dXZ = BTUtil.distanceTo2D(origin, end);
        double dY = origin.m_123342_() - end.m_123342_();
        return Math.sqrt(Math.abs(dXZ * dXZ + dY * dY));
    }

    public static void removeBodyOfWater(BlockPos start, Level level) {
        HashSet<BlockPos> waterPositions = new HashSet<BlockPos>();
        int recursion = 0;
        BTUtil.removeBodyOWater(waterPositions, start, recursion, level);
        waterPositions.forEach(pos -> level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0));
    }

    public static void removeBodyOWater(Set<BlockPos> storage, BlockPos position, int recursion, Level level) {
        if (!level.m_46801_(position) || recursion == 250) {
            return;
        }
        if (storage.contains(position)) {
            return;
        }
        storage.add(position);
        BTUtil.removeBodyOWater(storage, position.m_142127_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_142126_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_142128_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_142125_(), recursion + 1, level);
        BTUtil.removeBodyOWater(storage, position.m_7495_(), recursion + 1, level);
    }

    public static void btListFill(List<Item> loot, List<Integer> amounts, Container container, LootContext lootContext) {
        Random random = lootContext.m_78933_();
        List<Integer> possibleSlots = BTUtil.btGetAvailableSlots(container, random);
        int rows = Math.floorDiv(container.m_6643_(), 9);
        int middleOfChest = Math.floorDiv(rows, 2) * 9 + 4;
        possibleSlots.removeIf(i -> i == middleOfChest);
        for (int i2 = 0; i2 < loot.size(); ++i2) {
            int randomSlot = possibleSlots.remove(random.nextInt(possibleSlots.size()));
            ItemStack addStack = new ItemStack((ItemLike)loot.get(i2), amounts.get(i2).intValue());
            container.m_6836_(randomSlot, addStack);
            if (possibleSlots.isEmpty()) break;
        }
    }

    public static void btFill(LootTable loot, Container container, LootContext lootContext) {
        List list = loot.m_79129_(lootContext);
        Random random = lootContext.m_78933_();
        List<Integer> list1 = BTUtil.btGetAvailableSlots(container, random);
        BTUtil.btShuffleAndSplitItems(list, list1.size(), random);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.m_41619_()) {
                container.m_6836_(list1.remove(list1.size() - 1).intValue(), ItemStack.f_41583_);
                continue;
            }
            container.m_6836_(list1.remove(list1.size() - 1).intValue(), itemstack);
        }
    }

    private static List<Integer> btGetAvailableSlots(Container p_79127_, Random p_79128_) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_79127_.m_6643_(); ++i) {
            if (!p_79127_.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        Collections.shuffle(list, p_79128_);
        return list;
    }

    private static void btShuffleAndSplitItems(List<ItemStack> itemStackList, int listSize, Random random) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = itemStackList.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (listSize - itemStackList.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.m_14072_((Random)random, (int)0, (int)(list.size() - 1)));
            int i = Mth.m_14072_((Random)random, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && random.nextBoolean()) {
                list.add(itemstack2);
            } else {
                itemStackList.add(itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && random.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            itemStackList.add(itemstack1);
        }
        itemStackList.addAll(list);
        Collections.shuffle(itemStackList, random);
    }

    public static void doCommand(Entity self, String command) {
        self.f_19853_.m_142572_().m_129892_().m_82117_(self.m_20203_().m_81325_(4), command);
    }

    public static void doNoOutputCommand(Entity self, String command) {
        self.f_19853_.m_142572_().m_129892_().m_82117_(self.m_20203_().m_81325_(4).m_81324_(), command);
    }

    public static void doNoOutputPostionedCommand(Entity self, String command, Vec3 vec) {
        self.f_19853_.m_142572_().m_129892_().m_82117_(self.m_20203_().m_81325_(4).m_81348_(vec), command);
    }
}

