/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.util;

import com.BrassAmber.ba_bt.BattleTowersConfig;
import com.BrassAmber.ba_bt.init.BTItems;
import com.BrassAmber.ba_bt.item.item.BTEmptyLootItem;
import com.BrassAmber.ba_bt.item.item.BTEnchantedBookHolder;
import com.BrassAmber.ba_bt.util.BTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class BTLoot {
    public static final List<Item> badLoot = BTLoot.getItemList((List)BattleTowersConfig.generalBadLoot.get());
    public static final List<Item> fillerLoot = BTLoot.getItemList((List)BattleTowersConfig.generalFillerLoot.get());
    public static final List<Item> decentLoot = BTLoot.getItemList((List)BattleTowersConfig.generalDecentLoot.get());
    public static final List<Item> goodLoot = BTLoot.getItemList((List)BattleTowersConfig.generalGoodLoot.get());
    public static final List<Integer> badLootCounts = new ArrayList<Integer>();
    public static final List<Integer> fillerLootCounts = new ArrayList<Integer>();
    public static final List<Integer> decentLootCounts = new ArrayList<Integer>();
    public static final List<Integer> goodLootCounts = new ArrayList<Integer>();
    public static final List<List<Item>> towerBadLoot;
    public static final List<List<Item>> towerFillerLoot;
    public static final List<List<Item>> towerDecentLoot;
    public static final List<List<Item>> towerGoodLoot;
    public static final List<List<Integer>> towerBadLootCounts;
    public static final List<List<Integer>> towerFillerLootCounts;
    public static final List<List<Integer>> towerDecentLootCounts;
    public static final List<List<Integer>> towerGoodLootCounts;
    public static final List<List<Item>> golemLoot;
    public static final List<List<Integer>> golemLootCounts;
    public static final List<List<Integer>> landFloorRolls;
    public static final List<List<Integer>> oceanFloorRolls;
    public static final List<List<Integer>> golemLootRolls;
    public static final List<List<List<Integer>>> towerLootRolls;
    public static final List<LootType> lootTypes;

    public static List<Item> getItemList(List<? extends String> itemIds) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (String string : itemIds) {
            if (string.equals("minecraft:air")) {
                itemList.add((Item)BTItems.BT_EMPTY_LOOT_ITEM.get());
                continue;
            }
            if (string.equals("minecraft:enchanted_book")) {
                itemList.add((Item)BTItems.EBOOK_HOLDER.get());
                continue;
            }
            itemList.add(BTUtil.itemByString(string));
        }
        return itemList;
    }

    public static LootPool.Builder fillPool(int rolls, List<Item> items, List<Integer> counts, int enchantLevel) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)rolls));
        int w = 0;
        for (Item item : items) {
            LootPoolSingletonContainer.Builder lootItem;
            boolean enchantItem;
            int itemCount = counts.get(w);
            float maxCount = itemCount % 10;
            float minCount = ((float)itemCount - maxCount) / 10.0f;
            int weight = 10;
            boolean isTool = (item instanceof TieredItem || item instanceof TridentItem || item instanceof ElytraItem || item instanceof ProjectileWeaponItem) && (Boolean)BattleTowersConfig.enchantTools.get() != false;
            boolean isArmor = item instanceof ArmorItem && (Boolean)BattleTowersConfig.enchantArmor.get() != false;
            boolean bl = enchantItem = isTool || isArmor || item instanceof BTEnchantedBookHolder;
            if (item instanceof BTEmptyLootItem) {
                lootItem = EmptyLootItem.m_79533_();
                weight = 0;
            } else if (item instanceof BTEnchantedBookHolder) {
                lootItem = LootItem.m_79579_((ItemLike)Items.f_42517_);
                weight = 8;
            } else {
                lootItem = LootItem.m_79579_((ItemLike)item);
                if (item instanceof RecordItem) {
                    weight = 2;
                }
            }
            Random random = new Random();
            Random r2 = new Random(random.nextLong());
            if (isTool || isArmor) {
                weight = 6;
            }
            if (enchantItem && r2.nextFloat(10.0f) > 4.0f) {
                lootItem.m_5577_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)ConstantValue.m_165692_((float)enchantLevel)).m_80499_());
            }
            lootItem.m_79707_(weight);
            lootItem.m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minCount, (float)maxCount)));
            pool.m_79076_((LootPoolEntryContainer.Builder)lootItem);
            ++w;
        }
        return pool;
    }

    public static LootTable getLootTable(int towerType, int floor) {
        return BTLoot.getLootTableBuilder(towerType, floor, towerLootRolls.get(towerType).get(floor)).m_79167_();
    }

    public static LootTable.Builder getLootTableBuilder(int towerType, int floor, List<Integer> lootRolls) {
        LootTable.Builder chestLoot = LootTable.m_79147_();
        ArrayList pools = new ArrayList(Collections.emptyList());
        for (int i = 0; i < lootRolls.size(); ++i) {
            int rolls = lootRolls.get(i);
            LootType type = lootTypes.get(i);
            List<Item> baseItems = type.getBaseLoot();
            List<Item> towerItems = type.getTowerLoot(towerType);
            ArrayList<Item> allItems = new ArrayList<Item>();
            allItems.addAll(baseItems);
            allItems.addAll(towerItems);
            List<Integer> baseCounts = type.getBaseCounts();
            List<Integer> towerCounts = type.getTowerCounts(towerType);
            ArrayList<Integer> allCounts = new ArrayList<Integer>();
            allCounts.addAll(baseCounts);
            allCounts.addAll(towerCounts);
            LootPool.Builder pool = BTLoot.fillPool(rolls, allItems, allCounts, 3 * floor + (Integer)BattleTowersConfig.bookLevelEnchant.get());
            pools.add(pool);
        }
        return chestLoot.m_79161_((LootPool.Builder)pools.get(0)).m_79161_((LootPool.Builder)pools.get(1)).m_79161_((LootPool.Builder)pools.get(2)).m_79161_((LootPool.Builder)pools.get(3));
    }

    public static LootTable getGolemLootTable(int towerType) {
        List<Integer> lootRolls = golemLootRolls.get(towerType);
        int golemRolls = lootRolls.get(4);
        LootTable.Builder chestLoot = BTLoot.getLootTableBuilder(towerType, 8, lootRolls.subList(0, 4));
        LootPool.Builder pool = BTLoot.fillPool(golemRolls, golemLoot.get(towerType), golemLootCounts.get(towerType), 20 + (Integer)BattleTowersConfig.bookLevelEnchant.get());
        int emptyChance = Mth.m_14107_((double)((double)golemLoot.get(towerType).size() * 7.5 * (double)0.1f));
        pool.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(emptyChance));
        return chestLoot.m_79161_(pool).m_79167_();
    }

    static {
        badLootCounts.addAll((Collection)BattleTowersConfig.generalBadLootCounts.get());
        fillerLootCounts.addAll((Collection)BattleTowersConfig.generalFillerLootCounts.get());
        decentLootCounts.addAll((Collection)BattleTowersConfig.generalDecentLootCounts.get());
        goodLootCounts.addAll((Collection)BattleTowersConfig.generalGoodLootCounts.get());
        towerBadLoot = List.of(BTLoot.getItemList((List)BattleTowersConfig.landTowerBadLoot.get()), BTLoot.getItemList((List)BattleTowersConfig.oceanTowerBadLoot.get()));
        towerFillerLoot = List.of(BTLoot.getItemList((List)BattleTowersConfig.landTowerFillerLoot.get()), BTLoot.getItemList((List)BattleTowersConfig.oceanTowerFillerLoot.get()));
        towerDecentLoot = List.of(BTLoot.getItemList((List)BattleTowersConfig.landTowerDecentLoot.get()), BTLoot.getItemList((List)BattleTowersConfig.oceanTowerDecentLoot.get()));
        towerGoodLoot = List.of(BTLoot.getItemList((List)BattleTowersConfig.landTowerGoodLoot.get()), BTLoot.getItemList((List)BattleTowersConfig.oceanTowerGoodLoot.get()));
        towerBadLootCounts = List.of(new ArrayList(), new ArrayList());
        towerFillerLootCounts = List.of(new ArrayList(), new ArrayList());
        towerDecentLootCounts = List.of(new ArrayList(), new ArrayList());
        towerGoodLootCounts = List.of(new ArrayList(), new ArrayList());
        towerBadLootCounts.get(0).addAll((Collection)BattleTowersConfig.landBadLootCounts.get());
        towerBadLootCounts.get(1).addAll((Collection)BattleTowersConfig.oceanBadLootCounts.get());
        towerFillerLootCounts.get(0).addAll((Collection)BattleTowersConfig.landFillerLootCounts.get());
        towerFillerLootCounts.get(1).addAll((Collection)BattleTowersConfig.oceanFillerLootCounts.get());
        towerDecentLootCounts.get(0).addAll((Collection)BattleTowersConfig.landDecentLootCounts.get());
        towerDecentLootCounts.get(1).addAll((Collection)BattleTowersConfig.oceanDecentLootCounts.get());
        towerGoodLootCounts.get(0).addAll((Collection)BattleTowersConfig.landGoodLootCounts.get());
        towerGoodLootCounts.get(1).addAll((Collection)BattleTowersConfig.oceanGoodLootCounts.get());
        golemLoot = List.of(BTLoot.getItemList((List)BattleTowersConfig.landTowerGolemLoot.get()), BTLoot.getItemList((List)BattleTowersConfig.oceanTowerGolemLoot.get()));
        golemLootCounts = List.of(new ArrayList(), new ArrayList());
        golemLootCounts.get(0).addAll((Collection)BattleTowersConfig.landGolemLootCounts.get());
        golemLootCounts.get(1).addAll((Collection)BattleTowersConfig.oceanGolemLootCounts.get());
        landFloorRolls = List.of(List.of(Integer.valueOf(4), Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(1), Integer.valueOf(2)), List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(2), Integer.valueOf(2)), List.of(Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(3), Integer.valueOf(2)), List.of(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(3)), List.of(Integer.valueOf(1), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(3)), List.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(4)));
        oceanFloorRolls = List.of(List.of(Integer.valueOf(5), Integer.valueOf(3), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(2), Integer.valueOf(1)), List.of(Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(1), Integer.valueOf(2)), List.of(Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(2), Integer.valueOf(2)), List.of(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(3), Integer.valueOf(2)), List.of(Integer.valueOf(2), Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(3)), List.of(Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(3)), List.of(Integer.valueOf(0), Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(5)));
        golemLootRolls = List.of(List.of(Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(6), Integer.valueOf(5), Integer.valueOf(4)), List.of(Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(6), Integer.valueOf(5), Integer.valueOf(4)));
        towerLootRolls = List.of(landFloorRolls, oceanFloorRolls);
        lootTypes = List.of(LootType.BadLoot, LootType.FillerLoot, LootType.DecentLoot, LootType.GoodLoot);
    }

    public static enum LootType implements StringRepresentable
    {
        Empty("empty", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()),
        BadLoot("bad", badLoot, towerBadLoot, badLootCounts, towerBadLootCounts),
        FillerLoot("filler", fillerLoot, towerFillerLoot, fillerLootCounts, towerFillerLootCounts),
        DecentLoot("decent", decentLoot, towerDecentLoot, decentLootCounts, towerDecentLootCounts),
        GoodLoot("good", goodLoot, towerGoodLoot, goodLootCounts, towerGoodLootCounts);

        private final String name;
        private final List<Item> loot;
        private final List<List<Item>> towerLoot;
        private final List<Integer> counts;
        private final List<List<Integer>> towerCounts;

        private LootType(String name, List<Item> loot, List<List<Item>> towerLoot, List<Integer> counts, List<List<Integer>> towerCounts) {
            this.name = name;
            this.loot = loot;
            this.towerLoot = towerLoot;
            this.counts = counts;
            this.towerCounts = towerCounts;
        }

        public List<Item> getBaseLoot() {
            return this.loot;
        }

        public List<Item> getTowerLoot(int towerType) {
            return this.towerLoot.get(towerType);
        }

        public List<Integer> getBaseCounts() {
            return this.counts;
        }

        public List<Integer> getTowerCounts(int towerType) {
            return this.towerCounts.get(towerType);
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

