/*
 * Decompiled with CFR 0.152.
 */
package com.BrassAmber.ba_bt.item.item;

import com.BrassAmber.ba_bt.BrassAmberBattleTowers;
import com.BrassAmber.ba_bt.init.BTExtras;
import com.BrassAmber.ba_bt.util.BTUtil;
import com.BrassAmber.ba_bt.util.GolemType;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ResonanceStoneItem
extends RecordItem {
    public Enchantment enchantment;
    public MobEffect effect;
    private final GolemType golemType;
    public boolean effectOn;
    private boolean initialized;

    public ResonanceStoneItem(String golemName, Item.Properties properties) {
        super(2, BTUtil.getTowerMusic(GolemType.getTypeForName(golemName)), properties);
        this.golemType = GolemType.getTypeForName(golemName);
        this.effectOn = false;
        this.initialized = false;
    }

    public boolean m_8120_(ItemStack itemStack) {
        return itemStack.m_41613_() == 1;
    }

    public UseAnim m_6164_(ItemStack p_40678_) {
        return UseAnim.SPYGLASS;
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return 2000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int time) {
        int i = this.m_8105_(itemStack) - time;
        if (i > 4 && !level.m_5776_()) {
            this.effectOn = !this.effectOn;
            BrassAmberBattleTowers.LOGGER.info("Resonance effect: " + this.effectOn);
        }
        super.m_5551_(itemStack, level, entity, time);
    }

    public void addEnchantment(ItemStack stackInUse) {
        if (this.enchantment != null) {
            Map<Enchantment, Integer> map = Map.of(this.enchantment, 1);
            EnchantmentHelper.m_44865_(map, (ItemStack)stackInUse);
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean b) {
        super.m_6883_(itemStack, level, entity, i, b);
        if (!this.initialized) {
            switch (this.golemType) {
                case OCEAN: {
                    this.enchantment = (Enchantment)BTExtras.DEPTH_DROPPER.get();
                    this.effect = (MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get();
                    break;
                }
                default: {
                    this.enchantment = null;
                    this.effect = null;
                }
            }
            this.initialized = true;
        }
        if (this.enchantment != null && EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(this.enchantment) && !level.m_5776_() && entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            if (this.effectOn) {
                player.m_147215_(new MobEffectInstance((MobEffect)BTExtras.DEPTH_DROPPER_EFFECT.get(), 80, 3), null);
            }
        }
    }
}

